/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.factories;

import com.oracle.truffle.llvm.parser.factories.DarwinAMD64PlatformCapability;
import com.oracle.truffle.llvm.parser.factories.LinuxAMD64PlatformCapability;
import com.oracle.truffle.llvm.parser.factories.UnknownBasicPlatformCapability;
import com.oracle.truffle.llvm.runtime.PlatformCapability;
import com.oracle.truffle.llvm.runtime.memory.LLVMSyscallOperationNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.syscall.LLVMAMD64UnknownSyscallNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.syscall.LLVMInfo;
import java.nio.file.Path;
import java.nio.file.Paths;

public abstract class BasicPlatformCapability<S extends Enum<S>>
extends PlatformCapability<S> {
    private static final Path SULONG_LIBDIR = Paths.get("native", "lib");
    public static final String LIBSULONG_FILENAME = "libsulong.bc";
    public static final String LIBSULONGXX_FILENAME = "libsulong++.bc";
    private final boolean loadCxxLibraries;

    public static BasicPlatformCapability<?> create(boolean loadCxxLibraries) {
        if (LLVMInfo.SYSNAME.equalsIgnoreCase("linux") && LLVMInfo.MACHINE.equalsIgnoreCase("x86_64")) {
            return new LinuxAMD64PlatformCapability(loadCxxLibraries);
        }
        if (LLVMInfo.SYSNAME.equalsIgnoreCase("mac os x") && LLVMInfo.MACHINE.equalsIgnoreCase("x86_64")) {
            return new DarwinAMD64PlatformCapability(loadCxxLibraries);
        }
        return new UnknownBasicPlatformCapability(loadCxxLibraries);
    }

    protected BasicPlatformCapability(Class<S> cls, boolean loadCxxLibraries) {
        super(cls);
        this.loadCxxLibraries = loadCxxLibraries;
    }

    @Override
    public Path getSulongLibrariesPath() {
        return SULONG_LIBDIR;
    }

    @Override
    public String[] getSulongDefaultLibraries() {
        if (this.loadCxxLibraries) {
            return new String[]{LIBSULONG_FILENAME, LIBSULONGXX_FILENAME};
        }
        return new String[]{LIBSULONG_FILENAME};
    }

    @Override
    public LLVMSyscallOperationNode createSyscallNode(long index) {
        try {
            return this.createSyscallNode(this.getSyscall(index));
        }
        catch (IllegalArgumentException e) {
            return new LLVMAMD64UnknownSyscallNode(index);
        }
    }

    protected abstract LLVMSyscallOperationNode createSyscallNode(S var1);
}

