/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.macho;

import com.oracle.truffle.llvm.parser.binary.BinaryParser;
import com.oracle.truffle.llvm.parser.macho.MachODylibCommand;
import com.oracle.truffle.llvm.parser.macho.MachOHeader;
import com.oracle.truffle.llvm.parser.macho.MachOLoadCommand;
import com.oracle.truffle.llvm.parser.macho.MachOLoadCommandTable;
import com.oracle.truffle.llvm.parser.macho.MachORPathCommand;
import com.oracle.truffle.llvm.parser.macho.MachOReader;
import com.oracle.truffle.llvm.parser.macho.MachOSegmentCommand;
import com.oracle.truffle.llvm.runtime.except.LLVMParserException;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.graalvm.polyglot.io.ByteSequence;

public final class MachOFile {
    private static final String INTERMEDIATE_SEGMENT = "";
    private static final String BITCODE_SECTION = "__bitcode";
    private static final String LLVM_SEGMENT = "__LLVM";
    private static final String BUNDLE_SECTION = "__bundle";
    private static final int MH_OBJECT = 1;
    private static final int MH_EXECUTE = 2;
    private static final int MH_DYLIB = 6;
    private static final int MH_FVMLIB = 3;
    private static final int MH_CORE = 4;
    private static final int MH_PRELOAD = 5;
    private static final int MH_DYLINKER = 7;
    private static final int MH_BUNDLE = 8;
    private static final int MH_DYLIB_STUB = 9;
    private final MachOHeader header;
    private final MachOLoadCommandTable loadCommandTable;
    private final ByteSequence buffer;
    private static final Pattern RPATH_PATTERN = Pattern.compile("@loader_path");

    MachOFile(MachOHeader header, MachOLoadCommandTable loadCommandTable, ByteSequence buffer) {
        this.header = header;
        this.loadCommandTable = loadCommandTable;
        this.buffer = buffer;
    }

    public MachOSegmentCommand getSegment(String name) {
        return this.loadCommandTable.getSegment(name);
    }

    public MachOHeader getHeader() {
        return this.header;
    }

    private Stream<MachOLoadCommand> getLoadCommand(int cmdId) {
        return Arrays.stream(this.loadCommandTable.getLoadCommands()).filter(cmd -> cmd.getCmd() == cmdId);
    }

    public List<String> getDyLibs(String origin) {
        return this.getLoadCommand(12).map(MachODylibCommand.class::cast).map(e -> MachOFile.fixupRPath(origin, e.getName())).collect(Collectors.toList());
    }

    public List<String> getRPaths(String origin) {
        return this.getLoadCommand(-2147483620).map(MachORPathCommand.class::cast).map(e -> MachOFile.fixupRPath(origin, e.getName())).collect(Collectors.toList());
    }

    private static String fixupRPath(String origin, String path) {
        if (origin == null) {
            return path;
        }
        return RPATH_PATTERN.matcher(path).replaceAll(origin);
    }

    public ByteSequence extractBitcode() {
        switch (this.header.getFileType()) {
            case 1: {
                return this.getSectionData(INTERMEDIATE_SEGMENT, BITCODE_SECTION);
            }
            case 2: 
            case 6: {
                return this.getSectionData(LLVM_SEGMENT, BUNDLE_SECTION);
            }
        }
        throw new LLVMParserException("Mach-O file type not supported!");
    }

    public ByteSequence getSectionData(String segment, String section) {
        MachOSegmentCommand seg = this.loadCommandTable.getSegment(segment);
        if (seg == null) {
            return null;
        }
        MachOSegmentCommand.MachOSection sect = seg.getSection(section);
        if (sect == null) {
            return null;
        }
        int offset = sect.getOffset();
        long size = sect.getSize();
        return this.buffer.subSequence(offset, offset + (int)size);
    }

    public static MachOFile create(ByteSequence data) {
        return MachOReader.create(data);
    }

    public static boolean isMachOMagicNumber(long magic) {
        return MachOFile.isMachO32MagicNumber(magic) || MachOFile.isMachO64MagicNumber(magic);
    }

    public static boolean isMachO32MagicNumber(long magic) {
        return magic == BinaryParser.Magic.MH_MAGIC.magic || magic == BinaryParser.Magic.MH_CIGAM.magic;
    }

    public static boolean isMachO64MagicNumber(long magic) {
        return magic == BinaryParser.Magic.MH_MAGIC_64.magic || magic == BinaryParser.Magic.MH_CIGAM_64.magic;
    }
}

