/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.metadata;

import com.oracle.truffle.llvm.parser.listeners.Metadata;
import com.oracle.truffle.llvm.parser.metadata.MDBaseNode;
import com.oracle.truffle.llvm.parser.metadata.MDVoidNode;
import com.oracle.truffle.llvm.parser.metadata.MetadataValueList;
import com.oracle.truffle.llvm.parser.metadata.MetadataVisitor;
import com.oracle.truffle.llvm.parser.metadata.ParseUtil;

public final class MDFile
implements MDBaseNode {
    private MDBaseNode directory;
    private MDBaseNode file = MDVoidNode.INSTANCE;
    private static final int ARGINDEX_FILENAME = 1;
    private static final int ARGINDEX_DIRECTORY = 2;

    private MDFile() {
        this.directory = MDVoidNode.INSTANCE;
    }

    @Override
    public void accept(MetadataVisitor visitor) {
        visitor.visit(this);
    }

    public MDBaseNode getFile() {
        return this.file;
    }

    public MDBaseNode getDirectory() {
        return this.directory;
    }

    @Override
    public void replace(MDBaseNode oldValue, MDBaseNode newValue) {
        if (this.file == oldValue) {
            this.file = newValue;
        }
        if (this.directory == oldValue) {
            this.directory = newValue;
        }
    }

    public static MDFile create38(long[] args, MetadataValueList md) {
        MDFile file = new MDFile();
        file.file = md.getNullable(args[1], file);
        file.directory = md.getNullable(args[2], file);
        return file;
    }

    public static MDFile create32(long[] args, Metadata md) {
        MDFile file = new MDFile();
        file.file = ParseUtil.resolveReference(args, 1, file, md);
        file.directory = ParseUtil.resolveReference(args, 2, file, md);
        return file;
    }

    public static MDFile create(MDBaseNode fileNode, MDBaseNode dirNode) {
        MDFile file = new MDFile();
        file.file = fileNode;
        file.directory = dirNode;
        return file;
    }
}

