/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.metadata;

import com.oracle.truffle.llvm.parser.metadata.MDBaseNode;
import com.oracle.truffle.llvm.parser.metadata.MDVoidNode;
import com.oracle.truffle.llvm.parser.metadata.MetadataValueList;
import com.oracle.truffle.llvm.parser.metadata.MetadataVisitor;

public final class MDMacroFile
implements MDBaseNode {
    private final long type;
    private final long line;
    private MDBaseNode file;
    private MDBaseNode elements;
    private static final int ARGINDEX_TYPE = 1;
    private static final int ARGINDEX_LINE = 2;
    private static final int ARGINDEX_FILE = 3;
    private static final int ARGINDEX_ELEMENTS = 4;

    private MDMacroFile(long type, long line) {
        this.type = type;
        this.line = line;
        this.file = MDVoidNode.INSTANCE;
        this.elements = MDVoidNode.INSTANCE;
    }

    public long getType() {
        return this.type;
    }

    public long getLine() {
        return this.line;
    }

    public MDBaseNode getFile() {
        return this.file;
    }

    public MDBaseNode getElements() {
        return this.elements;
    }

    @Override
    public void replace(MDBaseNode oldValue, MDBaseNode newValue) {
        if (this.file == oldValue) {
            this.file = newValue;
        }
        if (this.elements == oldValue) {
            this.elements = newValue;
        }
    }

    @Override
    public void accept(MetadataVisitor visitor) {
        visitor.visit(this);
    }

    public static MDMacroFile create38(long[] args, MetadataValueList md) {
        long type = args[1];
        long line = args[2];
        MDMacroFile macroFile = new MDMacroFile(type, line);
        macroFile.file = md.getNullable(args[3], macroFile);
        macroFile.elements = md.getNullable(args[4], macroFile);
        return macroFile;
    }
}

