/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.metadata;

import com.oracle.truffle.llvm.parser.listeners.Metadata;
import com.oracle.truffle.llvm.parser.metadata.MDBaseNode;
import com.oracle.truffle.llvm.parser.metadata.MDValue;
import com.oracle.truffle.llvm.parser.metadata.MDVoidNode;
import com.oracle.truffle.llvm.parser.metadata.MetadataValueList;
import com.oracle.truffle.llvm.parser.metadata.MetadataVisitor;
import com.oracle.truffle.llvm.parser.metadata.ParseUtil;
import com.oracle.truffle.llvm.parser.model.symbols.constants.integer.IntegerConstant;
import com.oracle.truffle.llvm.parser.scanner.RecordBuffer;
import com.oracle.truffle.llvm.runtime.types.PrimitiveType;

public final class MDSubrange
implements MDBaseNode {
    private final long lowerBound;
    private MDBaseNode count;
    private static final int VERSION_SHIFT = 1;
    private static final long VERSION_MASK = 1L;
    private static final int ARGINDEX_32_LOWERBOUND = 1;
    private static final int ARGINDEX_32_UPPERBOUND = 2;

    private MDSubrange(long lowerBound) {
        this.lowerBound = lowerBound;
        this.count = MDVoidNode.INSTANCE;
    }

    @Override
    public void accept(MetadataVisitor visitor) {
        visitor.visit(this);
    }

    public long getLowerBound() {
        return this.lowerBound;
    }

    public MDBaseNode getCount() {
        return this.count;
    }

    @Override
    public void replace(MDBaseNode oldValue, MDBaseNode newValue) {
        if (this.count == oldValue) {
            this.count = newValue;
        }
    }

    public static MDSubrange createNewFormat(RecordBuffer buffer, MetadataValueList md) {
        long version = buffer.read() >> 1 & 1L;
        long count = buffer.read();
        long startFrom = ParseUtil.unrotateSign(buffer.read());
        MDSubrange subrange = new MDSubrange(startFrom);
        subrange.count = version == 1L ? md.getNullable(count, subrange) : MDValue.create(new IntegerConstant(PrimitiveType.I64, count));
        return subrange;
    }

    public static MDSubrange createOldFormat(long[] args, Metadata md) {
        long lowerBound = ParseUtil.asLong(args, 1, md);
        long upperBound = ParseUtil.asLong(args, 2, md);
        long size = upperBound - lowerBound + 1L;
        MDSubrange subrange = new MDSubrange(lowerBound);
        subrange.count = MDValue.create(new IntegerConstant(PrimitiveType.I64, size));
        return subrange;
    }
}

