/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.metadata.debuginfo;

import com.oracle.truffle.llvm.parser.metadata.MDBaseNode;
import com.oracle.truffle.llvm.parser.metadata.MetadataAttachmentHolder;
import com.oracle.truffle.llvm.parser.metadata.MetadataValueList;
import com.oracle.truffle.llvm.parser.metadata.debuginfo.DIScopeBuilder;
import com.oracle.truffle.llvm.parser.metadata.debuginfo.DITypeExtractor;
import com.oracle.truffle.llvm.parser.metadata.debuginfo.MDNameExtractor;
import com.oracle.truffle.llvm.parser.model.SymbolImpl;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMSourceLocation;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMSourceSymbol;
import com.oracle.truffle.llvm.runtime.debug.type.LLVMSourceStaticMemberType;
import com.oracle.truffle.llvm.runtime.debug.type.LLVMSourceType;
import java.util.HashMap;
import java.util.Map;

final class DebugInfoCache {
    private final Map<MDBaseNode, LLVMSourceSymbol> parsedVariables = new HashMap<MDBaseNode, LLVMSourceSymbol>();
    private final DIScopeBuilder scopeBuilder;
    private final DITypeExtractor typeExtractor;

    static MDBaseNode getDebugInfo(MetadataAttachmentHolder holder) {
        if (holder.hasAttachedMetadata()) {
            return holder.getMetadataAttachment("dbg");
        }
        return null;
    }

    DebugInfoCache(MetadataValueList metadata, Map<LLVMSourceStaticMemberType, SymbolImpl> staticMembers, LLVMContext context) {
        this.scopeBuilder = new DIScopeBuilder(metadata, context);
        this.typeExtractor = new DITypeExtractor(this.scopeBuilder, metadata, staticMembers);
    }

    LLVMSourceSymbol getSourceSymbol(MDBaseNode mdVariable, boolean isStatic) {
        LLVMSourceSymbol lookup = this.parsedVariables.get(mdVariable);
        if (lookup != null) {
            return lookup;
        }
        LLVMSourceLocation location = this.scopeBuilder.buildLocation(mdVariable);
        LLVMSourceType type = this.typeExtractor.parseType(mdVariable);
        String varName = MDNameExtractor.getName(mdVariable);
        LLVMSourceSymbol symbol = LLVMSourceSymbol.create(varName, location, type, isStatic);
        this.parsedVariables.put(mdVariable, symbol);
        if (location != null) {
            location = location.getParent();
        }
        if (location != null) {
            location.addSymbol(symbol);
        }
        return symbol;
    }

    LLVMSourceLocation buildLocation(MDBaseNode node) {
        return this.scopeBuilder.buildLocation(node);
    }

    LLVMSourceType parseType(MDBaseNode mdType) {
        return this.typeExtractor.parseType(mdType);
    }

    void endLocalScope() {
        this.scopeBuilder.clearLocalScopes();
    }

    void importScope(MDBaseNode node, LLVMSourceLocation importedScope) {
        this.scopeBuilder.importScope(node, importedScope);
    }
}

