/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.metadata.debuginfo;

import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.llvm.parser.metadata.MDBaseNode;
import com.oracle.truffle.llvm.parser.metadata.MDExpression;
import com.oracle.truffle.llvm.parser.metadata.MDLocalVariable;
import com.oracle.truffle.llvm.parser.metadata.MDLocation;
import com.oracle.truffle.llvm.parser.metadata.MetadataSymbol;
import com.oracle.truffle.llvm.parser.metadata.MetadataVisitor;
import com.oracle.truffle.llvm.parser.metadata.debuginfo.DIScopeBuilder;
import com.oracle.truffle.llvm.parser.metadata.debuginfo.DebugInfoCache;
import com.oracle.truffle.llvm.parser.metadata.debuginfo.ImportsProcessor;
import com.oracle.truffle.llvm.parser.metadata.debuginfo.MDSymbolExtractor;
import com.oracle.truffle.llvm.parser.metadata.debuginfo.SourceFunction;
import com.oracle.truffle.llvm.parser.metadata.debuginfo.SourceVariable;
import com.oracle.truffle.llvm.parser.metadata.debuginfo.ValueFragment;
import com.oracle.truffle.llvm.parser.model.IRScope;
import com.oracle.truffle.llvm.parser.model.SymbolImpl;
import com.oracle.truffle.llvm.parser.model.blocks.InstructionBlock;
import com.oracle.truffle.llvm.parser.model.functions.FunctionDeclaration;
import com.oracle.truffle.llvm.parser.model.functions.FunctionDefinition;
import com.oracle.truffle.llvm.parser.model.symbols.constants.NullConstant;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.DbgDeclareInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.DbgValueInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.DebugTrapInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.Instruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.VoidCallInstruction;
import com.oracle.truffle.llvm.parser.model.visitors.FunctionVisitor;
import com.oracle.truffle.llvm.parser.model.visitors.InstructionVisitorAdapter;
import com.oracle.truffle.llvm.parser.nodes.LLVMSymbolReadResolver;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMSourceLocation;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMSourceSymbol;
import com.oracle.truffle.llvm.runtime.debug.type.LLVMSourceFunctionType;
import com.oracle.truffle.llvm.runtime.debug.type.LLVMSourceType;
import com.oracle.truffle.llvm.runtime.types.MetaType;
import java.util.ArrayDeque;

public final class DebugInfoFunctionProcessor {
    private static final int LLVM_DBG_INTRINSICS_VALUE_ARGINDEX = 0;
    private static final String LLVM_DBG_DECLARE_NAME = "llvm.dbg.declare";
    private static final int LLVM_DBG_DECLARE_LOCALREF_ARGINDEX = 1;
    private static final int LLVM_DBG_DECLARE_EXPR_ARGINDEX = 2;
    private static final String LLVM_DBG_ADDR_NAME = "llvm.dbg.addr";
    private static final String LLVM_DBG_VALUE_NAME = "llvm.dbg.value";
    private static final int LLVM_DBG_VALUE_INDEX_ARGINDEX_OLD = 1;
    private static final int LLVM_DBG_VALUE_LOCALREF_ARGINDEX_OLD = 2;
    private static final int LLVM_DBG_VALUE_EXPR_ARGINDEX_OLD = 3;
    private static final int LLVM_DBG_VALUE_LOCALREF_ARGSIZE_OLD = 4;
    private static final int LLVM_DBG_VALUE_LOCALREF_ARGINDEX_NEW = 1;
    private static final int LLVM_DBG_VALUE_EXPR_ARGINDEX_NEW = 2;
    private static final int LLVM_DBG_VALUE_LOCALREF_ARGSIZE_NEW = 3;
    private static final String LLVM_DEBUGTRAP_NAME = "llvm.debugtrap";
    private final DebugInfoCache cache;

    DebugInfoFunctionProcessor(DebugInfoCache cache) {
        this.cache = cache;
    }

    public void process(FunctionDefinition function, IRScope scope, Source bitcodeSource, LLVMContext context) {
        ImportsProcessor.process(scope.getMetadata(), context, this.cache);
        this.initSourceFunction(function, bitcodeSource);
        function.accept(new SymbolProcessor(function.getSourceFunction()));
        scope.getMetadata().consumeLocals(new MetadataProcessor());
        for (SourceVariable local : function.getSourceFunction().getVariables()) {
            local.processFragments();
        }
        this.cache.endLocalScope();
    }

    private void initSourceFunction(FunctionDefinition function, Source bitcodeSource) {
        MDBaseNode debugInfo = DebugInfoCache.getDebugInfo(function);
        LLVMSourceLocation scope = null;
        LLVMSourceFunctionType type = null;
        if (debugInfo != null) {
            scope = this.cache.buildLocation(debugInfo);
            LLVMSourceType actualType = this.cache.parseType(debugInfo);
            if (actualType instanceof LLVMSourceFunctionType) {
                type = (LLVMSourceFunctionType)actualType;
            }
        }
        if (scope == null) {
            String sourceText = String.format("%s:%s", bitcodeSource.getName(), function.getName());
            Source irSource = Source.newBuilder((String)"llvm", (CharSequence)sourceText, (String)sourceText).mimeType(DIScopeBuilder.getMimeType(null)).build();
            SourceSection simpleSection = irSource.createSection(1);
            scope = LLVMSourceLocation.createBitcodeFunction(function.getName(), simpleSection);
        }
        SourceFunction sourceFunction = new SourceFunction(scope, type);
        function.setSourceFunction(sourceFunction);
    }

    private static SymbolImpl getArg(VoidCallInstruction call, int index) {
        return index < call.getArgumentCount() ? call.getArgument(index) : null;
    }

    private static MDExpression getExpression(VoidCallInstruction call, int index) {
        MDBaseNode mdNode;
        SymbolImpl argSymbol = DebugInfoFunctionProcessor.getArg(call, index);
        if (argSymbol instanceof MetadataSymbol && (mdNode = ((MetadataSymbol)argSymbol).getNode()) instanceof MDExpression) {
            return (MDExpression)mdNode;
        }
        return MDExpression.EMPTY;
    }

    private final class MetadataProcessor
    implements MetadataVisitor {
        private MetadataProcessor() {
        }

        @Override
        public void visit(MDLocalVariable md) {
            DebugInfoFunctionProcessor.this.cache.getSourceSymbol(md, false);
        }
    }

    private final class SymbolProcessor
    implements FunctionVisitor,
    InstructionVisitorAdapter {
        private final SourceFunction function;
        private final ArrayDeque<Integer> removeFromBlock = new ArrayDeque();
        private int blockInstIndex = 0;
        private DbgValueInstruction lastDbgValue = null;
        private InstructionBlock currentBlock = null;

        private SymbolProcessor(SourceFunction function) {
            this.function = function;
        }

        @Override
        public void visit(InstructionBlock block) {
            this.currentBlock = block;
            this.lastDbgValue = null;
            this.blockInstIndex = 0;
            while (this.blockInstIndex < block.getInstructionCount()) {
                block.getInstruction(this.blockInstIndex).accept(this);
                ++this.blockInstIndex;
            }
            if (!this.removeFromBlock.isEmpty()) {
                for (int i : this.removeFromBlock) {
                    this.currentBlock.remove(i);
                }
                this.removeFromBlock.clear();
            }
        }

        @Override
        public void visitInstruction(Instruction instruction) {
            LLVMSourceLocation scope;
            MDLocation loc = instruction.getDebugLocation();
            if (loc != null && (scope = DebugInfoFunctionProcessor.this.cache.buildLocation(loc)) != null) {
                instruction.setSourceLocation(scope);
            }
        }

        @Override
        public void visit(VoidCallInstruction call) {
            SymbolImpl callTarget = call.getCallTarget();
            if (callTarget instanceof FunctionDeclaration) {
                switch (((FunctionDeclaration)callTarget).getName()) {
                    case "llvm.dbg.declare": {
                        this.handleDebugIntrinsic(call, true);
                        return;
                    }
                    case "llvm.dbg.addr": {
                        this.handleDebugIntrinsic(call, true);
                        return;
                    }
                    case "llvm.dbg.value": {
                        this.handleDebugIntrinsic(call, false);
                        return;
                    }
                    case "llvm.debugtrap": {
                        this.visitDebugTrap(call);
                        return;
                    }
                }
            }
            this.visitInstruction(call);
        }

        private void visitDebugTrap(VoidCallInstruction call) {
            DebugTrapInstruction trap = DebugTrapInstruction.create(call);
            this.currentBlock.set(this.blockInstIndex, trap);
            this.visitInstruction(trap);
        }

        private SourceVariable getVariable(VoidCallInstruction call, int index) {
            SymbolImpl varSymbol = DebugInfoFunctionProcessor.getArg(call, index);
            if (varSymbol instanceof MetadataSymbol) {
                MDBaseNode mdLocal = ((MetadataSymbol)varSymbol).getNode();
                LLVMSourceSymbol symbol = DebugInfoFunctionProcessor.this.cache.getSourceSymbol(mdLocal, false);
                return this.function.getLocal(symbol);
            }
            return null;
        }

        private void handleDebugIntrinsic(VoidCallInstruction call, boolean isDeclaration) {
            int mdExprArgIndex;
            int mdLocalArgIndex;
            SymbolImpl value = DebugInfoFunctionProcessor.getArg(call, 0);
            if (value instanceof MetadataSymbol) {
                value = MDSymbolExtractor.getSymbol(((MetadataSymbol)value).getNode());
            }
            if (value == null) {
                value = new NullConstant(MetaType.DEBUG);
            }
            if (isDeclaration) {
                mdLocalArgIndex = 1;
                mdExprArgIndex = 2;
            } else if (call.getArgumentCount() == 3) {
                mdLocalArgIndex = 1;
                mdExprArgIndex = 2;
            } else if (call.getArgumentCount() == 4) {
                mdLocalArgIndex = 2;
                mdExprArgIndex = 3;
            } else {
                return;
            }
            SourceVariable variable = this.getVariable(call, mdLocalArgIndex);
            if (variable == null) {
                this.removeFromBlock.addFirst(this.blockInstIndex);
                return;
            }
            MDExpression expression = DebugInfoFunctionProcessor.getExpression(call, mdExprArgIndex);
            if (ValueFragment.describesFragment(expression)) {
                variable.addFragment(ValueFragment.parse(expression));
            } else {
                variable.addFullDefinition();
            }
            if (isDeclaration) {
                DbgDeclareInstruction dbgDeclare = new DbgDeclareInstruction(value, variable, expression);
                variable.addDeclaration(dbgDeclare);
                this.currentBlock.set(this.blockInstIndex, dbgDeclare);
            } else {
                DbgValueInstruction dbgValue;
                SymbolImpl indexSymbol;
                Long l;
                long index = 0L;
                if (call.getArgumentCount() == 4 && (l = LLVMSymbolReadResolver.evaluateLongIntegerConstant(indexSymbol = call.getArgument(1))) != null) {
                    index = l;
                }
                if ((dbgValue = new DbgValueInstruction(value, variable, index, expression)).equals(this.lastDbgValue)) {
                    this.removeFromBlock.addFirst(this.blockInstIndex);
                } else {
                    variable.addValue(dbgValue);
                    this.currentBlock.set(this.blockInstIndex, dbgValue);
                    this.lastDbgValue = dbgValue;
                }
            }
        }
    }
}

