/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.model.functions;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.llvm.parser.metadata.MDAttachment;
import com.oracle.truffle.llvm.parser.metadata.MetadataAttachmentHolder;
import com.oracle.truffle.llvm.parser.metadata.debuginfo.SourceFunction;
import com.oracle.truffle.llvm.parser.model.SymbolImpl;
import com.oracle.truffle.llvm.parser.model.attributes.AttributesCodeEntry;
import com.oracle.truffle.llvm.parser.model.attributes.AttributesGroup;
import com.oracle.truffle.llvm.parser.model.blocks.InstructionBlock;
import com.oracle.truffle.llvm.parser.model.enums.Linkage;
import com.oracle.truffle.llvm.parser.model.enums.Visibility;
import com.oracle.truffle.llvm.parser.model.functions.FunctionParameter;
import com.oracle.truffle.llvm.parser.model.functions.FunctionSymbol;
import com.oracle.truffle.llvm.parser.model.symbols.constants.Constant;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.Instruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.ValueInstruction;
import com.oracle.truffle.llvm.parser.model.visitors.FunctionVisitor;
import com.oracle.truffle.llvm.parser.model.visitors.SymbolVisitor;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMSourceLocation;
import com.oracle.truffle.llvm.runtime.types.FunctionType;
import com.oracle.truffle.llvm.runtime.types.Type;
import com.oracle.truffle.llvm.runtime.types.symbols.LLVMIdentifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public final class FunctionDefinition
extends FunctionSymbol
implements Constant,
MetadataAttachmentHolder {
    private static final InstructionBlock[] EMPTY = new InstructionBlock[0];
    private final List<FunctionParameter> parameters = new ArrayList<FunctionParameter>();
    private final Visibility visibility;
    private List<MDAttachment> mdAttachments = null;
    private SourceFunction sourceFunction = SourceFunction.DEFAULT;
    private InstructionBlock[] blocks = EMPTY;
    private int currentBlock = 0;

    private FunctionDefinition(FunctionType type, String name, Linkage linkage, Visibility visibility, AttributesCodeEntry paramAttr) {
        super(type, name, linkage, paramAttr);
        this.visibility = visibility;
    }

    public FunctionDefinition(FunctionType type, Linkage linkage, Visibility visibility, AttributesCodeEntry paramAttr) {
        this(type, "<anon>", linkage, visibility, paramAttr);
    }

    @Override
    public boolean hasAttachedMetadata() {
        return this.mdAttachments != null;
    }

    @Override
    public List<MDAttachment> getAttachedMetadata() {
        if (this.mdAttachments == null) {
            this.mdAttachments = new ArrayList<MDAttachment>(1);
        }
        return this.mdAttachments;
    }

    public String getSourceName() {
        String scopeName = this.sourceFunction.getName();
        return "<anon>".equals(scopeName) ? null : scopeName;
    }

    @Override
    public void replace(SymbolImpl oldValue, SymbolImpl newValue) {
    }

    @Override
    public void accept(SymbolVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void accept(FunctionVisitor visitor) {
        for (InstructionBlock block : this.blocks) {
            visitor.visit(block);
        }
    }

    public void allocateBlocks(int count) {
        this.blocks = new InstructionBlock[count];
        for (int i = 0; i < count; ++i) {
            this.blocks[i] = new InstructionBlock(i);
        }
    }

    public FunctionParameter createParameter(Type t) {
        AttributesGroup attrGroup = this.getParameterAttributesGroup(this.parameters.size());
        FunctionParameter parameter = new FunctionParameter(t, attrGroup);
        this.parameters.add(parameter);
        return parameter;
    }

    public void exitLocalScope() {
        int symbolIndex = 0;
        for (FunctionParameter parameter : this.parameters) {
            if (!"<anon>".equals(parameter.getName())) continue;
            parameter.setName(String.valueOf(symbolIndex++));
        }
        Set explicitBlockNames = Arrays.stream(this.blocks).map(InstructionBlock::getName).filter(blockName -> !LLVMIdentifier.isUnknown(blockName)).collect(Collectors.toSet());
        for (InstructionBlock block : this.blocks) {
            if (LLVMIdentifier.isUnknown(block.getName())) {
                do {
                    block.setName(LLVMIdentifier.toImplicitBlockName(symbolIndex++));
                } while (explicitBlockNames.contains(block.getName()));
            }
            for (int i = 0; i < block.getInstructionCount(); ++i) {
                ValueInstruction value;
                Instruction instruction = block.getInstruction(i);
                if (!(instruction instanceof ValueInstruction) || !LLVMIdentifier.isUnknown((value = (ValueInstruction)instruction).getName())) continue;
                value.setName(String.valueOf(symbolIndex++));
            }
        }
    }

    public InstructionBlock generateBlock() {
        return this.blocks[this.currentBlock++];
    }

    public InstructionBlock getBlock(long idx) {
        CompilerAsserts.neverPartOfCompilation();
        return this.blocks[(int)idx];
    }

    public List<InstructionBlock> getBlocks() {
        CompilerAsserts.neverPartOfCompilation();
        return Arrays.asList(this.blocks);
    }

    public List<FunctionParameter> getParameters() {
        CompilerAsserts.neverPartOfCompilation();
        return this.parameters;
    }

    public void nameBlock(int index, String argName) {
        this.blocks[index].setName(argName);
    }

    public void onAfterParse() {
        this.blocks = EMPTY;
        this.currentBlock = 0;
        this.mdAttachments = null;
        this.sourceFunction.clearLocals();
        this.parameters.clear();
    }

    public int hashCode() {
        CompilerAsserts.neverPartOfCompilation();
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        CompilerAsserts.neverPartOfCompilation();
        return super.equals(obj);
    }

    public String toString() {
        CompilerAsserts.neverPartOfCompilation();
        return String.format("%s %s {...}", this.getType(), this.getName());
    }

    public LLVMSourceLocation getLexicalScope() {
        return this.sourceFunction != null ? this.sourceFunction.getLexicalScope() : null;
    }

    public SourceFunction getSourceFunction() {
        return this.sourceFunction;
    }

    public void setSourceFunction(SourceFunction sourceFunction) {
        this.sourceFunction = sourceFunction;
    }

    @Override
    public boolean isExported() {
        return Linkage.isExported(this.getLinkage(), this.visibility);
    }

    @Override
    public boolean isOverridable() {
        return Linkage.isOverridable(this.getLinkage(), this.visibility);
    }

    @Override
    public boolean isExternal() {
        return Linkage.isExternal(this.getLinkage());
    }
}

