/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.model.symbols.constants;

import com.oracle.truffle.llvm.parser.model.SymbolImpl;
import com.oracle.truffle.llvm.parser.model.SymbolTable;
import com.oracle.truffle.llvm.parser.model.enums.CastOperator;
import com.oracle.truffle.llvm.parser.model.symbols.constants.AbstractConstant;
import com.oracle.truffle.llvm.parser.model.visitors.SymbolVisitor;
import com.oracle.truffle.llvm.runtime.types.Type;

public final class CastConstant
extends AbstractConstant {
    private final CastOperator operator;
    private SymbolImpl value;

    private CastConstant(Type type, CastOperator operator) {
        super(type);
        this.operator = operator;
    }

    @Override
    public void accept(SymbolVisitor visitor) {
        visitor.visit(this);
    }

    public CastOperator getOperator() {
        return this.operator;
    }

    public SymbolImpl getValue() {
        return this.value;
    }

    @Override
    public void replace(SymbolImpl original, SymbolImpl replacement) {
        if (this.value == original) {
            this.value = replacement;
        }
    }

    public static CastConstant fromSymbols(SymbolTable symbols, Type type, int opcode, int value) {
        CastConstant constant = new CastConstant(type, CastOperator.decode(opcode));
        constant.value = symbols.getForwardReferenced(value, constant);
        return constant;
    }
}

