/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.model.symbols.constants.aggregate;

import com.oracle.truffle.llvm.parser.model.SymbolImpl;
import com.oracle.truffle.llvm.parser.model.SymbolTable;
import com.oracle.truffle.llvm.parser.model.symbols.constants.AbstractConstant;
import com.oracle.truffle.llvm.parser.model.symbols.constants.Constant;
import com.oracle.truffle.llvm.parser.model.symbols.constants.aggregate.ArrayConstant;
import com.oracle.truffle.llvm.parser.model.symbols.constants.aggregate.StructureConstant;
import com.oracle.truffle.llvm.parser.model.symbols.constants.aggregate.VectorConstant;
import com.oracle.truffle.llvm.parser.model.symbols.constants.floatingpoint.FloatingPointConstant;
import com.oracle.truffle.llvm.parser.model.symbols.constants.integer.IntegerConstant;
import com.oracle.truffle.llvm.parser.model.symbols.globals.GlobalValueSymbol;
import com.oracle.truffle.llvm.parser.scanner.RecordBuffer;
import com.oracle.truffle.llvm.runtime.except.LLVMParserException;
import com.oracle.truffle.llvm.runtime.types.ArrayType;
import com.oracle.truffle.llvm.runtime.types.StructureType;
import com.oracle.truffle.llvm.runtime.types.Type;
import com.oracle.truffle.llvm.runtime.types.VectorType;

public abstract class AggregateConstant
extends AbstractConstant {
    private final SymbolImpl[] elements;

    AggregateConstant(Type type, int size) {
        super(type);
        this.elements = new SymbolImpl[size];
    }

    public SymbolImpl getElement(int idx) {
        return this.elements[idx];
    }

    public int getElementCount() {
        return this.elements.length;
    }

    @Override
    public void replace(SymbolImpl oldValue, SymbolImpl newValue) {
        if (!(newValue instanceof Constant) && !(newValue instanceof GlobalValueSymbol)) {
            throw new LLVMParserException("Values can only be replaced by Constants or Globals!");
        }
        for (int i = 0; i < this.elements.length; ++i) {
            if (this.elements[i] != oldValue) continue;
            this.elements[i] = newValue;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.getElementCount(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            SymbolImpl value = this.getElement(i);
            sb.append(value.getType()).append(" ").append(value);
        }
        return sb.toString();
    }

    public static AggregateConstant createFromData(Type type, RecordBuffer buffer) {
        AggregateConstant aggregateConstant;
        Type elementType;
        if (type instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)type;
            elementType = arrayType.getElementType();
            aggregateConstant = new ArrayConstant(arrayType, buffer.size());
        } else if (type instanceof VectorType) {
            VectorType vectorType = (VectorType)type;
            elementType = vectorType.getElementType();
            aggregateConstant = new VectorConstant((VectorType)type, buffer.size());
        } else {
            throw new LLVMParserException("Cannot create constant from data: " + type);
        }
        if (Type.isIntegerType(elementType)) {
            for (int i = 0; i < aggregateConstant.elements.length; ++i) {
                aggregateConstant.elements[i] = IntegerConstant.createFromData(elementType, buffer);
            }
        } else if (Type.isFloatingpointType(elementType)) {
            for (int i = 0; i < aggregateConstant.elements.length; ++i) {
                aggregateConstant.elements[i] = FloatingPointConstant.create(elementType, buffer);
            }
        } else {
            throw new LLVMParserException("No datum constant implementation for " + type);
        }
        return aggregateConstant;
    }

    public static AggregateConstant createFromValues(SymbolTable symbols, Type type, RecordBuffer buffer) {
        AggregateConstant aggregateConstant;
        int length = buffer.remaining();
        if (type instanceof ArrayType) {
            aggregateConstant = new ArrayConstant((ArrayType)type, length);
        } else if (type instanceof StructureType) {
            aggregateConstant = new StructureConstant((StructureType)type, length);
        } else if (type instanceof VectorType) {
            aggregateConstant = new VectorConstant((VectorType)type, length);
        } else {
            throw new LLVMParserException("Cannot create constant for type: " + type);
        }
        for (int elementIndex = 0; elementIndex < length; ++elementIndex) {
            aggregateConstant.elements[elementIndex] = symbols.getForwardReferenced(buffer.readInt(), aggregateConstant);
        }
        return aggregateConstant;
    }
}

