/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.model.symbols.constants.floatingpoint;

import com.oracle.truffle.llvm.parser.model.SymbolImpl;
import com.oracle.truffle.llvm.parser.model.symbols.constants.AbstractConstant;
import com.oracle.truffle.llvm.parser.model.symbols.constants.floatingpoint.DoubleConstant;
import com.oracle.truffle.llvm.parser.model.symbols.constants.floatingpoint.FloatConstant;
import com.oracle.truffle.llvm.parser.model.symbols.constants.floatingpoint.X86FP80Constant;
import com.oracle.truffle.llvm.parser.scanner.RecordBuffer;
import com.oracle.truffle.llvm.runtime.except.LLVMParserException;
import com.oracle.truffle.llvm.runtime.types.PrimitiveType;
import com.oracle.truffle.llvm.runtime.types.Type;
import java.nio.ByteBuffer;

public abstract class FloatingPointConstant
extends AbstractConstant {
    private static final int X86_FP80_BYTES = PrimitiveType.X86_FP80.getBitSize() / 8;

    FloatingPointConstant(Type type) {
        super(type);
    }

    public abstract String getStringValue();

    public static FloatingPointConstant create(Type type, RecordBuffer buffer) {
        switch (((PrimitiveType)type).getPrimitiveKind()) {
            case FLOAT: {
                return new FloatConstant(Float.intBitsToFloat(buffer.readInt()));
            }
            case DOUBLE: {
                return new DoubleConstant(Double.longBitsToDouble(buffer.read()));
            }
            case X86_FP80: {
                return new X86FP80Constant(ByteBuffer.allocate(X86_FP80_BYTES).putLong(buffer.read()).putShort((short)buffer.read()).array());
            }
        }
        throw new LLVMParserException("Unsupported Floating Point Type: " + type);
    }

    @Override
    public void replace(SymbolImpl oldValue, SymbolImpl newValue) {
    }
}

