/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.model.symbols.instructions;

import com.oracle.truffle.llvm.parser.model.SymbolImpl;
import com.oracle.truffle.llvm.parser.model.SymbolTable;
import com.oracle.truffle.llvm.parser.model.blocks.InstructionBlock;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.TerminatingInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.VoidInstruction;
import com.oracle.truffle.llvm.parser.model.visitors.SymbolVisitor;

public final class ConditionalBranchInstruction
extends VoidInstruction
implements TerminatingInstruction {
    private SymbolImpl condition;
    private final InstructionBlock trueSuccessor;
    private final InstructionBlock falseSuccessor;

    private ConditionalBranchInstruction(InstructionBlock trueSuccessor, InstructionBlock falseSuccessor) {
        this.trueSuccessor = trueSuccessor;
        this.falseSuccessor = falseSuccessor;
    }

    @Override
    public void accept(SymbolVisitor visitor) {
        visitor.visit(this);
    }

    public SymbolImpl getCondition() {
        return this.condition;
    }

    public InstructionBlock getFalseSuccessor() {
        return this.falseSuccessor;
    }

    public InstructionBlock getTrueSuccessor() {
        return this.trueSuccessor;
    }

    @Override
    public int getSuccessorCount() {
        return 2;
    }

    @Override
    public InstructionBlock getSuccessor(int index) {
        if (index == 0) {
            return this.trueSuccessor;
        }
        assert (index == 1);
        return this.falseSuccessor;
    }

    @Override
    public void replace(SymbolImpl original, SymbolImpl replacement) {
        if (this.condition == original) {
            this.condition = replacement;
        }
    }

    public static ConditionalBranchInstruction fromSymbols(SymbolTable symbols, int conditionIndex, InstructionBlock trueSuccessor, InstructionBlock falseSuccessor) {
        ConditionalBranchInstruction inst = new ConditionalBranchInstruction(trueSuccessor, falseSuccessor);
        inst.condition = symbols.getForwardReferenced(conditionIndex, inst);
        return inst;
    }
}

