/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.FrameUtil;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ControlFlowException;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.llvm.api.Toolchain;
import com.oracle.truffle.llvm.instruments.trace.LLVMTracerInstrument;
import com.oracle.truffle.llvm.runtime.ContextExtension;
import com.oracle.truffle.llvm.runtime.DefaultLibraryLocator;
import com.oracle.truffle.llvm.runtime.LLVMArgumentBuffer;
import com.oracle.truffle.llvm.runtime.LLVMFunctionDescriptor;
import com.oracle.truffle.llvm.runtime.LLVMIntrinsicProvider;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.LLVMScope;
import com.oracle.truffle.llvm.runtime.LLVMThread;
import com.oracle.truffle.llvm.runtime.LibraryLocator;
import com.oracle.truffle.llvm.runtime.NodeFactory;
import com.oracle.truffle.llvm.runtime.PlatformCapability;
import com.oracle.truffle.llvm.runtime.datalayout.DataLayout;
import com.oracle.truffle.llvm.runtime.debug.LLVMSourceContext;
import com.oracle.truffle.llvm.runtime.debug.type.LLVMSourceType;
import com.oracle.truffle.llvm.runtime.except.LLVMLinkerException;
import com.oracle.truffle.llvm.runtime.global.LLVMGlobal;
import com.oracle.truffle.llvm.runtime.global.LLVMGlobalContainer;
import com.oracle.truffle.llvm.runtime.interop.LLVMTypedForeignObject;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType;
import com.oracle.truffle.llvm.runtime.memory.LLVMMemory;
import com.oracle.truffle.llvm.runtime.memory.LLVMMemoryOpNode;
import com.oracle.truffle.llvm.runtime.memory.LLVMStack;
import com.oracle.truffle.llvm.runtime.memory.LLVMThreadingStack;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMStatementNode;
import com.oracle.truffle.llvm.runtime.options.SulongEngineOption;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.runtime.pthread.LLVMPThreadContext;
import com.oracle.truffle.llvm.runtime.types.FunctionType;
import com.oracle.truffle.llvm.runtime.types.Type;
import com.oracle.truffle.llvm.runtime.types.VoidType;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.graalvm.collections.EconomicMap;

public final class LLVMContext {
    private final List<Path> libraryPaths = new ArrayList<Path>();
    private final Object libraryPathsLock = new Object();
    private final Toolchain toolchain;
    @CompilerDirectives.CompilationFinal
    private Path internalLibraryPath;
    private final List<ExternalLibrary> externalLibraries = new ArrayList<ExternalLibrary>();
    private final Object externalLibrariesLock = new Object();
    private final List<String> internalLibraryNames;
    private final ConcurrentHashMap<LLVMPointer, LLVMGlobal> globalsReverseMap = new ConcurrentHashMap();
    private final ArrayList<LLVMPointer> globalsNonPointerStore = new ArrayList();
    private final ArrayList<LLVMPointer> globalsReadOnlyStore = new ArrayList();
    private final Object globalsStoreLock = new Object();
    private final List<LLVMThread> runningThreads = new ArrayList<LLVMThread>();
    @CompilerDirectives.CompilationFinal
    private LLVMThreadingStack threadingStack;
    private Object[] mainArguments;
    private final Map<String, String> environment;
    private final ArrayList<LLVMNativePointer> caughtExceptionStack = new ArrayList();
    private ConcurrentHashMap<String, Integer> nativeCallStatistics;
    private final Object handlesLock;
    private final EconomicMap<Object, Handle> handleFromManaged;
    private final EconomicMap<LLVMNativePointer, Handle> handleFromPointer;
    private final LLVMSourceContext sourceContext;
    @CompilerDirectives.CompilationFinal
    private TruffleLanguage.Env env;
    private final LLVMScope globalScope;
    private final DynamicLinkChain dynamicLinkChain;
    private final List<RootCallTarget> destructorFunctions;
    private final LLVMFunctionPointerRegistry functionPointerRegistry;
    private final LLVMInteropType.InteropTypeRegistry interopTypeRegistry;
    private final Map<Thread, Object> tls = new ConcurrentHashMap<Thread, Object>();
    private final LLVMNativePointer sigDfl;
    private final LLVMNativePointer sigIgn;
    private final LLVMNativePointer sigErr;
    private final LLVMPThreadContext pThreadContext;
    private boolean initialized;
    private boolean cleanupNecessary;
    private boolean initializeContextCalled;
    private DataLayout libsulongDatalayout;
    private Boolean datalayoutInitialised;
    private final LLVMLanguage language;
    private LLVMTracerInstrument tracer;
    private CallTarget freeGlobalBlocks;
    @CompilerDirectives.CompilationFinal
    private boolean traceLoaderEnabled;
    @CompilerDirectives.CompilationFinal
    private PrintStream traceLoaderStream;

    LLVMContext(LLVMLanguage language, TruffleLanguage.Env env, Toolchain toolchain) {
        this.language = language;
        this.libsulongDatalayout = null;
        this.datalayoutInitialised = false;
        this.env = env;
        this.initialized = false;
        this.cleanupNecessary = false;
        this.destructorFunctions = new ArrayList<RootCallTarget>();
        this.nativeCallStatistics = SulongEngineOption.isTrue((String)env.getOptions().get(SulongEngineOption.NATIVE_CALL_STATS)) ? new ConcurrentHashMap() : null;
        this.sigDfl = LLVMNativePointer.create(0L);
        this.sigIgn = LLVMNativePointer.create(1L);
        this.sigErr = LLVMNativePointer.create(-1L);
        this.handleFromManaged = EconomicMap.create();
        this.handleFromPointer = EconomicMap.create();
        this.handlesLock = new Object();
        this.functionPointerRegistry = new LLVMFunctionPointerRegistry();
        this.interopTypeRegistry = new LLVMInteropType.InteropTypeRegistry();
        this.sourceContext = new LLVMSourceContext();
        this.toolchain = toolchain;
        this.internalLibraryNames = Collections.unmodifiableList(Arrays.asList(language.getCapability(PlatformCapability.class).getSulongDefaultLibraries()));
        assert (!this.internalLibraryNames.isEmpty()) : "No internal libraries?";
        this.globalScope = new LLVMScope();
        this.dynamicLinkChain = new DynamicLinkChain();
        this.mainArguments = LLVMContext.getMainArguments(env);
        this.environment = System.getenv();
        this.addLibraryPaths(SulongEngineOption.getPolyglotOptionSearchPaths(env));
        this.pThreadContext = new LLVMPThreadContext(this);
    }

    boolean patchContext(TruffleLanguage.Env newEnv) {
        if (this.initializeContextCalled) {
            return false;
        }
        this.env = newEnv;
        this.nativeCallStatistics = SulongEngineOption.isTrue((String)newEnv.getOptions().get(SulongEngineOption.NATIVE_CALL_STATS)) ? new ConcurrentHashMap() : null;
        this.mainArguments = LLVMContext.getMainArguments(newEnv);
        return true;
    }

    private static Object[] getMainArguments(TruffleLanguage.Env environment) {
        Object mainArgs = environment.getConfig().get("Sulong Main Args");
        return mainArgs == null ? environment.getApplicationArguments() : (Object[])mainArgs;
    }

    void initialize() {
        this.initializeContextCalled = true;
        assert (this.threadingStack == null);
        String traceOption = (String)this.env.getOptions().get(SulongEngineOption.TRACE_IR);
        if (!"".equalsIgnoreCase(traceOption)) {
            if (!((Boolean)this.env.getOptions().get(SulongEngineOption.LL_DEBUG)).booleanValue()) {
                throw new IllegalStateException("'--llvm.traceIR' requires '--llvm.llDebug=true'");
            }
            this.tracer = new LLVMTracerInstrument();
            this.tracer.initialize(this.env, traceOption);
        } else {
            this.tracer = null;
        }
        this.threadingStack = new LLVMThreadingStack(Thread.currentThread(), LLVMContext.parseStackSize((String)this.env.getOptions().get(SulongEngineOption.STACK_SIZE)));
        for (ContextExtension ext : this.language.getLanguageContextExtension()) {
            ext.initialize();
        }
        String languageHome = this.language.getLLVMLanguageHome();
        if (languageHome != null) {
            PlatformCapability sysContextExt = this.language.getCapability(PlatformCapability.class);
            this.internalLibraryPath = Paths.get(languageHome, new String[0]).resolve(sysContextExt.getSulongLibrariesPath());
            this.addLibraryPath(this.internalLibraryPath.toString());
        }
        if (((Boolean)this.env.getOptions().get(SulongEngineOption.PRINT_TOOLCHAIN_PATH)).booleanValue()) {
            LLVMFunctionDescriptor functionDescriptor = this.createFunctionDescriptor("__sulong_print_toolchain_path", new FunctionType(VoidType.INSTANCE, new Type[0], false), new LLVMFunctionDescriptor.UnresolvedFunction(), null);
            functionDescriptor.define(this.getLanguage().getCapability(LLVMIntrinsicProvider.class), null);
            this.globalScope.register(functionDescriptor);
        }
    }

    private static long parseStackSize(String v) {
        String valueString = v.trim();
        long scale = 1L;
        switch (valueString.charAt(valueString.length() - 1)) {
            case 'K': 
            case 'k': {
                scale = 1024L;
                break;
            }
            case 'M': 
            case 'm': {
                scale = 0x100000L;
                break;
            }
            case 'G': 
            case 'g': {
                scale = 0x40000000L;
                break;
            }
            case 'T': 
            case 't': {
                scale = 0x10000000000L;
            }
        }
        if (scale != 1L) {
            valueString = valueString.substring(0, valueString.length() - 1);
        }
        return Long.parseLong(valueString) * scale;
    }

    public boolean isInitialized() {
        return this.threadingStack != null;
    }

    public LLVMStatementNode createInitializeContextNode(FrameDescriptor rootFrame) {
        return new InitializeContextNode(this, rootFrame);
    }

    public Toolchain getToolchain() {
        return this.toolchain;
    }

    @CompilerDirectives.TruffleBoundary
    private LLVMManagedPointer getApplicationArguments() {
        String[] result;
        if (this.mainArguments == null) {
            result = new String[]{""};
        } else {
            result = new String[this.mainArguments.length + 1];
            result[0] = "";
            for (int i = 1; i < result.length; ++i) {
                result[i] = this.mainArguments[i - 1].toString();
            }
        }
        return LLVMContext.toTruffleObjects(result);
    }

    @CompilerDirectives.TruffleBoundary
    private LLVMManagedPointer getEnvironmentVariables() {
        String[] result = (String[])this.environment.entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).toArray(String[]::new);
        return LLVMContext.toTruffleObjects(result);
    }

    @CompilerDirectives.TruffleBoundary
    private static LLVMManagedPointer getRandomValues() {
        byte[] result = new byte[16];
        LLVMContext.secureRandom().nextBytes(result);
        return LLVMContext.toManagedPointer(new LLVMArgumentBuffer(result));
    }

    private static SecureRandom secureRandom() {
        return new SecureRandom();
    }

    private static LLVMManagedPointer toTruffleObjects(String[] values) {
        LLVMArgumentBuffer[] result = new LLVMArgumentBuffer[values.length];
        for (int i = 0; i < values.length; ++i) {
            result[i] = new LLVMArgumentBuffer(values[i]);
        }
        return LLVMContext.toManagedPointer(new LLVMArgumentBuffer.LLVMArgumentArray(result));
    }

    private static LLVMManagedPointer toManagedPointer(Object value) {
        return LLVMManagedPointer.create(LLVMTypedForeignObject.createUnknown(value));
    }

    public void addLibsulongDataLayout(DataLayout datalayout) {
        if (this.datalayoutInitialised.booleanValue()) {
            throw new NullPointerException("The default datalayout cannot be overrwitten.");
        }
        this.libsulongDatalayout = datalayout;
        this.datalayoutInitialised = true;
    }

    public DataLayout getLibsulongDataLayout() {
        return this.libsulongDatalayout;
    }

    void finalizeContext() {
        this.pThreadContext.joinAllThreads();
        if (this.cleanupNecessary) {
            try {
                RootCallTarget disposeContext = this.globalScope.getFunction("__sulong_dispose_context").getLLVMIRFunctionSlowPath();
                try (LLVMStack.StackPointer stackPointer = this.threadingStack.getStack().newFrame();){
                    disposeContext.call(new Object[]{stackPointer});
                }
            }
            catch (ControlFlowException controlFlowException) {
                // empty catch block
            }
        }
    }

    private void initFreeGlobalBlocks(final NodeFactory nodeFactory) {
        if (this.freeGlobalBlocks == null) {
            this.freeGlobalBlocks = Truffle.getRuntime().createCallTarget(new RootNode(this.language){
                @Node.Child
                LLVMMemoryOpNode freeRo;
                @Node.Child
                LLVMMemoryOpNode freeRw;
                {
                    super(language);
                    this.freeRo = nodeFactory.createFreeGlobalsBlock(true);
                    this.freeRw = nodeFactory.createFreeGlobalsBlock(false);
                }

                public Object execute(VirtualFrame frame) {
                    for (LLVMPointer store : LLVMContext.this.globalsReadOnlyStore) {
                        if (store == null) continue;
                        this.freeRo.execute(store);
                    }
                    for (LLVMPointer store : LLVMContext.this.globalsNonPointerStore) {
                        if (store == null) continue;
                        this.freeRw.execute(store);
                    }
                    return null;
                }
            });
        }
    }

    void dispose(LLVMMemory memory) {
        this.printNativeCallStatistic();
        if (this.isInitialized()) {
            this.threadingStack.freeMainStack(memory);
        }
        if (this.freeGlobalBlocks != null) {
            this.freeGlobalBlocks.call(new Object[0]);
        }
        for (LLVMPointer pointer : this.globalsReverseMap.keySet()) {
            Object object;
            if (!LLVMManagedPointer.isInstance(pointer) || !((object = LLVMManagedPointer.cast(pointer).getObject()) instanceof LLVMGlobalContainer)) continue;
            ((LLVMGlobalContainer)object).dispose();
        }
        if (this.tracer != null) {
            this.tracer.dispose();
        }
    }

    public ExternalLibrary addInternalLibrary(String lib, boolean isNative) {
        CompilerAsserts.neverPartOfCompilation();
        Path path = this.locateInternalLibrary(lib);
        return this.getOrAddExternalLibrary(ExternalLibrary.internal(path, isNative));
    }

    @CompilerDirectives.TruffleBoundary
    private Path locateInternalLibrary(String lib) {
        if (this.internalLibraryPath == null) {
            throw new LLVMLinkerException(String.format("Cannot load \"%s\". Internal library path not set.", lib));
        }
        Path absPath = this.internalLibraryPath.resolve(lib);
        if (absPath.toFile().exists()) {
            return absPath;
        }
        return Paths.get(lib, new String[0]);
    }

    public ExternalLibrary addExternalLibrary(String lib, boolean isNative, Object reason) {
        return this.addExternalLibrary(lib, isNative, reason, DefaultLibraryLocator.INSTANCE);
    }

    public ExternalLibrary addExternalLibrary(String lib, boolean isNative, Object reason, LibraryLocator locator) {
        ExternalLibrary newLib;
        CompilerAsserts.neverPartOfCompilation();
        if (this.isInternalLibrary(lib)) {
            return null;
        }
        TruffleFile tf = locator.locate(this, lib, reason);
        if (tf == null) {
            Path path = Paths.get(lib, new String[0]);
            LibraryLocator.traceDelegateNative(this, path);
            newLib = ExternalLibrary.external(path, isNative);
        } else {
            newLib = ExternalLibrary.external(tf, isNative);
        }
        ExternalLibrary existingLib = this.getOrAddExternalLibrary(newLib);
        if (existingLib == newLib) {
            return newLib;
        }
        LibraryLocator.traceAlreadyLoaded(this, existingLib.path);
        return null;
    }

    public ExternalLibrary addExternalLibrary(ExternalLibrary newLib) {
        CompilerAsserts.neverPartOfCompilation();
        if (this.isInternalLibrary(newLib.name)) {
            return null;
        }
        ExternalLibrary existingLib = this.getOrAddExternalLibrary(newLib);
        if (existingLib == newLib) {
            return newLib;
        }
        LibraryLocator.traceAlreadyLoaded(this, existingLib.path);
        return null;
    }

    private boolean isInternalLibrary(String lib) {
        for (String interalLibs : this.internalLibraryNames) {
            if (!interalLibs.equals(lib)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExternalLibrary getOrAddExternalLibrary(ExternalLibrary externalLib) {
        Object object = this.externalLibrariesLock;
        synchronized (object) {
            int index = this.externalLibraries.indexOf(externalLib);
            if (index >= 0) {
                ExternalLibrary ret = this.externalLibraries.get(index);
                assert (ret.equals(externalLib));
                return ret;
            }
            this.externalLibraries.add(externalLib);
            return externalLib;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ExternalLibrary> getExternalLibraries(Predicate<ExternalLibrary> filter) {
        Object object = this.externalLibrariesLock;
        synchronized (object) {
            return this.externalLibraries.stream().filter(f -> filter.test((ExternalLibrary)f)).collect(Collectors.toList());
        }
    }

    public void addLibraryPaths(List<String> paths) {
        for (String p : paths) {
            this.addLibraryPath(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addLibraryPath(String p) {
        Path path = Paths.get(p, new String[0]);
        TruffleFile file = this.getEnv().getInternalTruffleFile(path.toString());
        if (file.isDirectory(new LinkOption[0])) {
            Object object = this.libraryPathsLock;
            synchronized (object) {
                if (!this.libraryPaths.contains(path)) {
                    this.libraryPaths.add(path);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<Path> getLibraryPaths() {
        Object object = this.libraryPathsLock;
        synchronized (object) {
            return this.libraryPaths;
        }
    }

    public LLVMLanguage getLanguage() {
        return this.language;
    }

    public TruffleLanguage.Env getEnv() {
        return this.env;
    }

    public LLVMScope getGlobalScope() {
        return this.globalScope;
    }

    @CompilerDirectives.TruffleBoundary
    public Object getThreadLocalStorage() {
        Object value = this.tls.get(Thread.currentThread());
        if (value != null) {
            return value;
        }
        return LLVMNativePointer.createNull();
    }

    @CompilerDirectives.TruffleBoundary
    public void setThreadLocalStorage(Object value) {
        this.tls.put(Thread.currentThread(), value);
    }

    @CompilerDirectives.TruffleBoundary
    public LLVMFunctionDescriptor getFunctionDescriptor(LLVMNativePointer handle) {
        return this.functionPointerRegistry.getDescriptor(handle);
    }

    @CompilerDirectives.TruffleBoundary
    public LLVMFunctionDescriptor createFunctionDescriptor(String name, FunctionType type, LLVMFunctionDescriptor.Function function, ExternalLibrary library) {
        return this.functionPointerRegistry.create(name, type, function, library);
    }

    @CompilerDirectives.TruffleBoundary
    public void registerFunctionPointer(LLVMNativePointer address, LLVMFunctionDescriptor descriptor) {
        this.functionPointerRegistry.register(address, descriptor);
    }

    public LLVMNativePointer getSigDfl() {
        return this.sigDfl;
    }

    public LLVMNativePointer getSigIgn() {
        return this.sigIgn;
    }

    public LLVMNativePointer getSigErr() {
        return this.sigErr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    public boolean isHandle(LLVMNativePointer address) {
        Object object = this.handlesLock;
        synchronized (object) {
            return this.handleFromPointer.containsKey((Object)address);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    public Object getManagedObjectForHandle(LLVMNativePointer address) {
        Object object = this.handlesLock;
        synchronized (object) {
            Handle handle = (Handle)this.handleFromPointer.get((Object)address);
            if (handle == null) {
                throw new UnsupportedOperationException("Cannot resolve native handle: " + address);
            }
            return handle.managed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    public void releaseHandle(LLVMMemory memory, LLVMNativePointer address) {
        Object object = this.handlesLock;
        synchronized (object) {
            Handle handle = (Handle)this.handleFromPointer.get((Object)address);
            if (handle == null) {
                throw new UnsupportedOperationException("Cannot resolve native handle: " + address);
            }
            if (--handle.refcnt == 0) {
                this.handleFromPointer.removeKey((Object)address);
                this.handleFromManaged.removeKey(handle.managed);
                memory.free(address);
            }
        }
    }

    public LLVMNativePointer getHandleForManagedObject(LLVMMemory memory, Object object) {
        return this.getHandle(memory, object, false).copy();
    }

    public LLVMNativePointer getDerefHandleForManagedObject(LLVMMemory memory, Object object) {
        return this.getHandle(memory, object, true).copy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    private LLVMNativePointer getHandle(LLVMMemory memory, Object object, boolean autoDeref) {
        Object object2 = this.handlesLock;
        synchronized (object2) {
            Handle handle = (Handle)this.handleFromManaged.get(object);
            if (handle == null) {
                LLVMNativePointer allocatedMemory = LLVMNativePointer.create(memory.allocateHandle(autoDeref));
                handle = new Handle(allocatedMemory, object);
                this.handleFromManaged.put(object, (Object)handle);
                this.handleFromPointer.put((Object)allocatedMemory, (Object)handle);
            }
            handle.refcnt++;
            return handle.pointer;
        }
    }

    @CompilerDirectives.TruffleBoundary
    public void registerNativeCall(LLVMFunctionDescriptor descriptor) {
        if (this.nativeCallStatistics != null) {
            String name = descriptor.getName() + " " + descriptor.getType();
            if (this.nativeCallStatistics.containsKey(name)) {
                int count = this.nativeCallStatistics.get(name) + 1;
                this.nativeCallStatistics.put(name, count);
            } else {
                this.nativeCallStatistics.put(name, 1);
            }
        }
    }

    public List<LLVMNativePointer> getCaughtExceptionStack() {
        return this.caughtExceptionStack;
    }

    public LLVMThreadingStack getThreadingStack() {
        assert (this.threadingStack != null);
        return this.threadingStack;
    }

    public void registerDestructorFunctions(RootCallTarget destructor) {
        assert (destructor != null);
        assert (!this.destructorFunctions.contains(destructor));
        this.destructorFunctions.add(destructor);
    }

    @CompilerDirectives.TruffleBoundary
    public boolean isScopeLoaded(LLVMScope scope) {
        return this.dynamicLinkChain.containsScope(scope);
    }

    @CompilerDirectives.TruffleBoundary
    public void registerScope(LLVMScope scope) {
        this.dynamicLinkChain.addScope(scope);
    }

    public synchronized void registerThread(LLVMThread thread) {
        assert (!this.runningThreads.contains(thread));
        this.runningThreads.add(thread);
    }

    public synchronized void unregisterThread(LLVMThread thread) {
        this.runningThreads.remove(thread);
        assert (!this.runningThreads.contains(thread));
    }

    @CompilerDirectives.TruffleBoundary
    public synchronized void shutdownThreads() {
        for (LLVMThread node : new ArrayList<LLVMThread>(this.runningThreads)) {
            node.stop();
        }
    }

    @CompilerDirectives.TruffleBoundary
    public synchronized void awaitThreadTermination() {
        this.shutdownThreads();
        while (!this.runningThreads.isEmpty()) {
            LLVMThread node = this.runningThreads.get(0);
            node.awaitFinish();
            assert (!this.runningThreads.contains(node));
        }
    }

    public RootCallTarget[] getDestructorFunctions() {
        return this.destructorFunctions.toArray(new RootCallTarget[this.destructorFunctions.size()]);
    }

    public synchronized List<LLVMThread> getRunningThreads() {
        return Collections.unmodifiableList(this.runningThreads);
    }

    public LLVMSourceContext getSourceContext() {
        return this.sourceContext;
    }

    @CompilerDirectives.TruffleBoundary
    public LLVMGlobal findGlobal(LLVMPointer pointer) {
        return this.globalsReverseMap.get(pointer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    public void registerReadOnlyGlobals(LLVMPointer nonPointerStore, NodeFactory nodeFactory) {
        Object object = this.globalsStoreLock;
        synchronized (object) {
            this.initFreeGlobalBlocks(nodeFactory);
            this.globalsReadOnlyStore.add(nonPointerStore);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    public void registerGlobals(LLVMPointer nonPointerStore, NodeFactory nodeFactory) {
        Object object = this.globalsStoreLock;
        synchronized (object) {
            this.initFreeGlobalBlocks(nodeFactory);
            this.globalsNonPointerStore.add(nonPointerStore);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public void registerGlobalReverseMap(LLVMGlobal global, LLVMPointer target) {
        this.globalsReverseMap.put(target, global);
    }

    public void setCleanupNecessary(boolean value) {
        this.cleanupNecessary = value;
    }

    @CompilerDirectives.TruffleBoundary
    public LLVMInteropType getInteropType(LLVMSourceType sourceType) {
        return this.interopTypeRegistry.get(sourceType);
    }

    private void printNativeCallStatistic() {
        if (this.nativeCallStatistics != null) {
            LinkedHashMap sorted = this.nativeCallStatistics.entrySet().stream().sorted(Map.Entry.comparingByValue()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
            for (String s : sorted.keySet()) {
                System.err.println(String.format("Function %s \t count: %d", s, sorted.get(s)));
            }
        }
    }

    public LLVMPThreadContext getpThreadContext() {
        return this.pThreadContext;
    }

    private void cacheTrace() {
        if (this.traceLoaderStream == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.traceLoaderStream = SulongEngineOption.getStream((String)this.getEnv().getOptions().get(SulongEngineOption.LD_DEBUG));
            this.traceLoaderEnabled = SulongEngineOption.isTrue((String)this.getEnv().getOptions().get(SulongEngineOption.LD_DEBUG));
            assert (this.traceLoaderStream != null);
        }
    }

    boolean ldDebugEnabled() {
        this.cacheTrace();
        return this.traceLoaderEnabled;
    }

    PrintStream ldDebugStream() {
        this.cacheTrace();
        return this.traceLoaderStream;
    }

    private static class DynamicLinkChain {
        private final ArrayList<LLVMScope> scopes = new ArrayList();

        DynamicLinkChain() {
        }

        private void addScope(LLVMScope newScope) {
            assert (!this.scopes.contains(newScope));
            this.scopes.add(newScope);
        }

        private boolean containsScope(LLVMScope scope) {
            return this.scopes.contains(scope);
        }
    }

    public static class ExternalLibrary {
        private final String name;
        private final Path path;
        private final TruffleFile file;
        @CompilerDirectives.CompilationFinal
        private boolean isNative;
        private final boolean isInternal;

        public static ExternalLibrary external(String name, boolean isNative) {
            return new ExternalLibrary(name, isNative, false);
        }

        public static ExternalLibrary internal(String name, boolean isNative) {
            return new ExternalLibrary(name, isNative, true);
        }

        public static ExternalLibrary external(Path path, boolean isNative) {
            return new ExternalLibrary(path, isNative, false);
        }

        public static ExternalLibrary internal(Path path, boolean isNative) {
            return new ExternalLibrary(path, isNative, true);
        }

        public static ExternalLibrary external(TruffleFile file, boolean isNative) {
            return new ExternalLibrary(file, isNative, false);
        }

        public ExternalLibrary(String name, boolean isNative, boolean isInternal) {
            this(name, null, isNative, isInternal);
        }

        public ExternalLibrary(Path path, boolean isNative, boolean isInternal) {
            this(ExternalLibrary.extractName(path), path, isNative, isInternal);
        }

        private static TruffleFile getCanonicalFile(TruffleFile file) {
            try {
                return file.getCanonicalFile(new LinkOption[0]);
            }
            catch (IOException e) {
                return file;
            }
        }

        public ExternalLibrary(TruffleFile file, boolean isNative, boolean isInternal) {
            this.path = Paths.get(file.getPath(), new String[0]);
            this.name = ExternalLibrary.extractName(this.path);
            this.isNative = isNative;
            this.isInternal = isInternal;
            this.file = ExternalLibrary.getCanonicalFile(file);
        }

        private ExternalLibrary(String name, Path path, boolean isNative, boolean isInternal) {
            this.name = name;
            this.path = path;
            this.isNative = isNative;
            this.isInternal = isInternal;
            this.file = null;
        }

        public boolean hasFile() {
            return this.file != null;
        }

        public TruffleFile getFile() {
            return this.file;
        }

        public Path getPath() {
            return this.path;
        }

        public boolean isNative() {
            return this.isNative;
        }

        public boolean isInternal() {
            return this.isInternal;
        }

        public void setIsNative(boolean isNative) {
            this.isNative = isNative;
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof ExternalLibrary) {
                ExternalLibrary other = (ExternalLibrary)obj;
                if (this.file != null) {
                    return this.file.equals((Object)other.file);
                }
                return this.name.equals(other.name) && Objects.equals(this.path, other.path);
            }
            return false;
        }

        public int hashCode() {
            return this.name.hashCode() ^ Objects.hashCode(this.path);
        }

        private static String extractName(Path path) {
            Path filename = path.getFileName();
            if (filename == null) {
                throw new IllegalArgumentException("Path " + path + " is empty");
            }
            String nameWithExt = filename.toString();
            int lengthWithoutExt = nameWithExt.lastIndexOf(".");
            if (lengthWithoutExt > 0) {
                return nameWithExt.substring(0, lengthWithoutExt);
            }
            return nameWithExt;
        }

        public String toString() {
            return this.path == null ? this.name : this.name + " (" + this.path + ")";
        }
    }

    private static final class InitializeContextNode
    extends LLVMStatementNode {
        @CompilerDirectives.CompilationFinal
        private TruffleLanguage.ContextReference<LLVMContext> ctxRef;
        private final FrameSlot stackPointer;
        @Node.Child
        DirectCallNode initContext;

        InitializeContextNode(LLVMContext ctx, FrameDescriptor rootFrame) {
            this.stackPointer = rootFrame.findFrameSlot((Object)"<stackpointer>");
            LLVMFunctionDescriptor initContextDescriptor = ctx.globalScope.getFunction("__sulong_init_context");
            RootCallTarget initContextFunction = initContextDescriptor.getLLVMIRFunctionSlowPath();
            this.initContext = DirectCallNode.create((CallTarget)initContextFunction);
        }

        @Override
        public void execute(VirtualFrame frame) {
            LLVMContext ctx;
            if (this.ctxRef == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.ctxRef = this.lookupContextReference(LLVMLanguage.class);
            }
            if (!(ctx = (LLVMContext)this.ctxRef.get()).initialized) {
                assert (!ctx.cleanupNecessary);
                ctx.initialized = true;
                ctx.cleanupNecessary = true;
                try (LLVMStack.StackPointer sp = ((LLVMStack.StackPointer)FrameUtil.getObjectSafe((Frame)frame, (FrameSlot)this.stackPointer)).newFrame();){
                    Object[] args = new Object[]{sp, ctx.getApplicationArguments(), ctx.getEnvironmentVariables(), LLVMContext.getRandomValues()};
                    this.initContext.call(args);
                }
            }
        }
    }

    private final class LLVMFunctionPointerRegistry {
        private int currentFunctionIndex = 1;
        private final HashMap<LLVMNativePointer, LLVMFunctionDescriptor> functionDescriptors = new HashMap();

        private LLVMFunctionPointerRegistry() {
        }

        synchronized LLVMFunctionDescriptor getDescriptor(LLVMNativePointer pointer) {
            return this.functionDescriptors.get(pointer);
        }

        synchronized void register(LLVMNativePointer pointer, LLVMFunctionDescriptor desc) {
            this.functionDescriptors.put(pointer, desc);
        }

        synchronized LLVMFunctionDescriptor create(String name, FunctionType type, LLVMFunctionDescriptor.Function function, ExternalLibrary library) {
            int functionId = this.currentFunctionIndex++;
            return new LLVMFunctionDescriptor(LLVMContext.this, name, type, functionId, function, library);
        }
    }

    private static final class Handle {
        private int refcnt = 0;
        private final LLVMNativePointer pointer;
        private final Object managed;

        private Handle(LLVMNativePointer pointer, Object managed) {
            this.pointer = pointer;
            this.managed = managed;
        }
    }
}

