/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime;

import com.oracle.truffle.api.TruffleFile;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;

public class LLVMFileDetector
implements TruffleFile.FileTypeDetector {
    private static final long BC_MAGIC_WORD = 3737142082L;
    private static final long WRAPPER_MAGIC_WORD = 186106078L;
    private static final long ELF_MAGIC_WORD = 1179403647L;

    public String findMimeType(TruffleFile file) throws IOException {
        long magicWord = LLVMFileDetector.readMagicWord(file);
        if (magicWord == 3737142082L || magicWord == 186106078L) {
            return "application/x-llvm-ir-bitcode";
        }
        if (magicWord == 1179403647L) {
            return "application/x-sharedlib";
        }
        return null;
    }

    public Charset findEncoding(TruffleFile file) throws IOException {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static long readMagicWord(TruffleFile file) {
        try (InputStream is = file.newInputStream(new OpenOption[]{StandardOpenOption.READ});){
            byte[] buffer = new byte[4];
            if (is.read(buffer) != buffer.length) {
                long l2 = 0L;
                return l2;
            }
            long l = Integer.toUnsignedLong(ByteBuffer.wrap(buffer).order(ByteOrder.nativeOrder()).getInt());
            return l;
        }
        catch (IOException | SecurityException e) {
            return 0L;
        }
    }
}

