/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMFunctionDescriptor;
import com.oracle.truffle.llvm.runtime.LLVMSymbol;
import com.oracle.truffle.llvm.runtime.global.LLVMGlobal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

@ExportLibrary(value=InteropLibrary.class)
public final class LLVMScope
implements TruffleObject {
    private final HashMap<String, LLVMSymbol> symbols = new HashMap();
    private final ArrayList<String> functionKeys = new ArrayList();

    @CompilerDirectives.TruffleBoundary
    public LLVMSymbol get(String name) {
        return this.symbols.get(name);
    }

    @CompilerDirectives.TruffleBoundary
    public String getKey(int idx) {
        return this.functionKeys.get(idx);
    }

    @CompilerDirectives.TruffleBoundary
    public LLVMFunctionDescriptor getFunction(String name) {
        LLVMSymbol symbol = this.get(name);
        if (symbol != null && symbol.isFunction()) {
            return symbol.asFunction();
        }
        throw new IllegalStateException("Unknown function: " + name);
    }

    @CompilerDirectives.TruffleBoundary
    public LLVMGlobal getGlobalVariable(String name) {
        LLVMSymbol symbol = this.get(name);
        if (symbol != null && symbol.isGlobalVariable()) {
            return symbol.asGlobalVariable();
        }
        throw new IllegalStateException("Unknown global: " + name);
    }

    @CompilerDirectives.TruffleBoundary
    public void register(LLVMSymbol symbol) {
        LLVMSymbol existing = this.symbols.get(symbol.getName());
        if (existing == null) {
            this.put(symbol.getName(), symbol);
        } else assert (existing == symbol);
    }

    @CompilerDirectives.TruffleBoundary
    public boolean contains(String name) {
        return this.symbols.containsKey(name);
    }

    @CompilerDirectives.TruffleBoundary
    public boolean exports(LLVMContext context, String name) {
        LLVMSymbol localSymbol = this.get(name);
        LLVMSymbol globalSymbol = context.getGlobalScope().get(name);
        return localSymbol != null && localSymbol == globalSymbol;
    }

    public boolean isEmpty() {
        return this.symbols.isEmpty();
    }

    @CompilerDirectives.TruffleBoundary
    public void addMissingEntries(LLVMScope other) {
        for (Map.Entry<String, LLVMSymbol> entry : other.symbols.entrySet()) {
            this.symbols.putIfAbsent(entry.getKey(), entry.getValue());
        }
    }

    @CompilerDirectives.TruffleBoundary
    public Collection<LLVMSymbol> values() {
        return this.symbols.values();
    }

    @CompilerDirectives.TruffleBoundary
    public void rename(String oldName, LLVMSymbol symbol) {
        this.remove(oldName);
        this.register(symbol);
    }

    public TruffleObject getKeys() {
        return new Keys(this);
    }

    private void put(String name, LLVMSymbol symbol) {
        assert (!this.symbols.containsKey(name));
        this.symbols.put(name, symbol);
        if (symbol.isFunction()) {
            assert (!this.functionKeys.contains(name));
            assert (this.functionKeys.size() < this.symbols.size());
            this.functionKeys.add(name);
        }
    }

    private void remove(String name) {
        assert (this.symbols.containsKey(name));
        LLVMSymbol removedSymbol = this.symbols.remove(name);
        if (removedSymbol.isFunction()) {
            boolean contained = this.functionKeys.remove(name);
            assert (contained);
        }
    }

    @ExportMessage
    boolean hasMembers() {
        return true;
    }

    @ExportMessage
    Object getMembers(boolean includeInternal) {
        return this.getKeys();
    }

    @ExportMessage
    boolean isMemberReadable(String name) {
        return this.contains(name);
    }

    @ExportMessage
    Object readMember(String globalName, @Cached BranchProfile exception) throws UnknownIdentifierException {
        if (this.contains(globalName)) {
            return this.get(globalName);
        }
        exception.enter();
        throw UnknownIdentifierException.create((String)globalName);
    }

    @ExportLibrary(value=InteropLibrary.class)
    static final class Keys
    implements TruffleObject {
        private final LLVMScope scope;

        private Keys(LLVMScope scope) {
            this.scope = scope;
        }

        @ExportMessage
        boolean hasArrayElements() {
            return true;
        }

        @ExportMessage
        long getArraySize() {
            return this.scope.functionKeys.size();
        }

        @ExportMessage
        boolean isArrayElementReadable(long index) {
            return 0L <= index && index < this.getArraySize();
        }

        @ExportMessage
        Object readArrayElement(long index, @Cached BranchProfile exception) throws InvalidArrayIndexException {
            if (this.isArrayElementReadable(index)) {
                return this.scope.getKey((int)index);
            }
            exception.enter();
            throw InvalidArrayIndexException.create((long)index);
        }
    }
}

