/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.debug;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMSourceLocation;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMSourceSymbol;
import com.oracle.truffle.llvm.runtime.debug.value.LLVMDebugObjectBuilder;
import com.oracle.truffle.llvm.runtime.debug.value.LLVMFrameValueAccess;
import java.util.HashMap;

public final class LLVMSourceContext {
    private final HashMap<LLVMSourceSymbol, LLVMDebugObjectBuilder> staticValues = new HashMap();
    private final HashMap<LLVMSourceSymbol, LLVMFrameValueAccess> frameValues = new HashMap();
    private final HashMap<String, LLVMSourceLocation> exportedScopes = new HashMap();

    @CompilerDirectives.TruffleBoundary
    public LLVMSourceContext() {
    }

    @CompilerDirectives.TruffleBoundary
    public void registerStatic(LLVMSourceSymbol symbol, LLVMDebugObjectBuilder value) {
        this.staticValues.put(symbol, value);
    }

    @CompilerDirectives.TruffleBoundary
    public LLVMDebugObjectBuilder getStatic(LLVMSourceSymbol symbol) {
        return this.staticValues.get(symbol);
    }

    @CompilerDirectives.TruffleBoundary
    public void registerFrameValue(LLVMSourceSymbol symbol, LLVMFrameValueAccess value) {
        this.frameValues.put(symbol, value);
    }

    @CompilerDirectives.TruffleBoundary
    public LLVMFrameValueAccess getFrameValue(LLVMSourceSymbol symbol) {
        return this.frameValues.get(symbol);
    }

    @CompilerDirectives.TruffleBoundary
    public LLVMSourceLocation getExportedScope(String name) {
        return this.exportedScopes.get(name);
    }

    @CompilerDirectives.TruffleBoundary
    public void exportScope(String name, LLVMSourceLocation scope) {
        this.exportedScopes.put(name, scope);
    }
}

