/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.debug.scope;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Scope;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.llvm.runtime.CommonNodeFactory;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMScope;
import com.oracle.truffle.llvm.runtime.LLVMSymbol;
import com.oracle.truffle.llvm.runtime.datalayout.DataLayout;
import com.oracle.truffle.llvm.runtime.debug.LLVMSourceContext;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMDebuggerScopeEntries;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMSourceLocation;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMSourceSymbol;
import com.oracle.truffle.llvm.runtime.debug.value.LLVMDebugObject;
import com.oracle.truffle.llvm.runtime.debug.value.LLVMDebugObjectBuilder;
import com.oracle.truffle.llvm.runtime.debug.value.LLVMFrameValueAccess;
import com.oracle.truffle.llvm.runtime.global.LLVMGlobal;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMInstrumentableNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.options.SulongEngineOption;
import com.oracle.truffle.llvm.runtime.types.PointerType;
import com.oracle.truffle.llvm.runtime.types.symbols.LLVMIdentifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;

public final class LLVMDebuggerScopeFactory {
    private static final String DEFAULT_NAME = "<scope>";
    private final LLVMContext context;
    private final LLVMSourceContext sourceContext;
    private final ArrayList<LLVMSourceSymbol> symbols;
    private final Node node;
    private String name;
    private static final String DEFAULT_RECEIVER_NAME = "this";
    private static final String DEFAULT_RECEIVER = "<none>";

    private static LLVMSourceLocation findSourceLocation(Node suspendedNode) {
        for (Node node = suspendedNode; node != null; node = node.getParent()) {
            if (node instanceof LLVMInstrumentableNode) {
                LLVMSourceLocation sourceLocation = ((LLVMInstrumentableNode)node).getSourceLocation();
                if (sourceLocation == null) continue;
                return sourceLocation;
            }
            if (!(node instanceof RootNode)) continue;
            return null;
        }
        return null;
    }

    @CompilerDirectives.TruffleBoundary
    private static LLVMDebuggerScopeEntries getIRLevelEntries(Frame frame, LLVMContext context, DataLayout dataLayout) {
        if (frame == null || frame.getFrameDescriptor().getSlots().isEmpty()) {
            return LLVMDebuggerScopeEntries.EMPTY_SCOPE;
        }
        LLVMDebuggerScopeEntries entries = new LLVMDebuggerScopeEntries();
        for (FrameSlot slot : frame.getFrameDescriptor().getSlots()) {
            String identifier = String.valueOf(slot.getIdentifier());
            Object slotValue = frame.getValue(slot);
            if (slotValue == null) {
                slotValue = "<unavailable>";
            }
            TruffleObject value = CommonNodeFactory.toGenericDebuggerValue(slot.getInfo(), slotValue, dataLayout);
            entries.add(LLVMDebuggerScopeFactory.convertIdentifier(identifier, context), value);
        }
        return entries;
    }

    @CompilerDirectives.TruffleBoundary
    private static LLVMDebuggerScopeEntries toDebuggerScope(LLVMScope scope, DataLayout dataLayout) {
        LLVMDebuggerScopeEntries entries = new LLVMDebuggerScopeEntries();
        for (LLVMSymbol symbol : scope.values()) {
            if (!symbol.isGlobalVariable()) continue;
            LLVMGlobal global = symbol.asGlobalVariable();
            TruffleObject value = CommonNodeFactory.toGenericDebuggerValue(global.getPointeeType(), global.getTarget(), dataLayout);
            entries.add(LLVMIdentifier.toGlobalIdentifier(global.getName()), value);
        }
        return entries;
    }

    @CompilerDirectives.TruffleBoundary
    private static LLVMDebuggerScopeEntries toDebuggerScope(LLVMSourceLocation.TextModule irScope, DataLayout dataLayout) {
        LLVMDebuggerScopeEntries entries = new LLVMDebuggerScopeEntries();
        for (LLVMGlobal global : irScope) {
            TruffleObject value = CommonNodeFactory.toGenericDebuggerValue(new PointerType(global.getPointeeType()), global.getTarget(), dataLayout);
            entries.add(LLVMIdentifier.toGlobalIdentifier(global.getName()), value);
        }
        return entries;
    }

    @CompilerDirectives.TruffleBoundary
    private static LLVMDebuggerScopeEntries getIRLevelEntries(Node node, LLVMContext context, DataLayout dataLayout) {
        for (LLVMSourceLocation location = LLVMDebuggerScopeFactory.findSourceLocation(node); location != null; location = location.getParent()) {
            if (!(location instanceof LLVMSourceLocation.TextModule)) continue;
            return LLVMDebuggerScopeFactory.toDebuggerScope((LLVMSourceLocation.TextModule)location, dataLayout);
        }
        return LLVMDebuggerScopeFactory.toDebuggerScope(context.getGlobalScope(), dataLayout);
    }

    @CompilerDirectives.TruffleBoundary
    public static Iterable<Scope> createIRLevelScope(Node node, Frame frame, LLVMContext context) {
        DataLayout dataLayout = ((LLVMNode)node).getDataLayout();
        Scope localScope = Scope.newBuilder((String)"function", (Object)LLVMDebuggerScopeFactory.getIRLevelEntries(frame, context, dataLayout)).node(node).build();
        Scope globalScope = Scope.newBuilder((String)"module", (Object)LLVMDebuggerScopeFactory.getIRLevelEntries(node, context, dataLayout)).build();
        return Arrays.asList(localScope, globalScope);
    }

    @CompilerDirectives.TruffleBoundary
    public static Iterable<Scope> createSourceLevelScope(Node node, Frame frame, LLVMContext context) {
        LLVMDebuggerScopeFactory next;
        LLVMSourceLocation scope;
        LLVMSourceContext sourceContext = context.getSourceContext();
        RootNode rootNode = node.getRootNode();
        if (rootNode == null || scope == null) {
            return Collections.singleton(new LLVMDebuggerScopeFactory(context, sourceContext, node).toScope(frame));
        }
        SourceSection sourceSection = scope.getSourceSection();
        LLVMDebuggerScopeFactory baseScope = new LLVMDebuggerScopeFactory(context, sourceContext, new ArrayList<LLVMSourceSymbol>(), (Node)rootNode);
        LLVMDebuggerScopeFactory staticScope = null;
        boolean isLocalScope = true;
        for (scope = LLVMDebuggerScopeFactory.findSourceLocation(node); isLocalScope && scope != null; scope = scope.getParent()) {
            next = LLVMDebuggerScopeFactory.toScope(context, scope, sourceContext, (Node)rootNode, sourceSection);
            LLVMDebuggerScopeFactory.copySymbols(next, baseScope);
            if (scope.getKind() != LLVMSourceLocation.Kind.FUNCTION) continue;
            baseScope.setName(next.getName());
            if (scope.getCompileUnit() != null) {
                staticScope = LLVMDebuggerScopeFactory.toScope(context, scope.getCompileUnit(), sourceContext, null, sourceSection);
            }
            isLocalScope = false;
        }
        ArrayList<Scope> scopeList = new ArrayList<Scope>();
        scopeList.add(baseScope.toScope(frame));
        while (scope != null) {
            next = LLVMDebuggerScopeFactory.toScope(context, scope, sourceContext, null, sourceSection);
            switch (scope.getKind()) {
                case NAMESPACE: 
                case FILE: 
                case BLOCK: {
                    if (!next.hasSymbols()) break;
                    scopeList.add(next.toScope(frame));
                    break;
                }
                case COMPILEUNIT: {
                    if (staticScope == null) {
                        staticScope = next;
                        break;
                    }
                    LLVMDebuggerScopeFactory.copySymbols(next, staticScope);
                }
            }
            scope = scope.getParent();
        }
        if (staticScope != null && super.hasSymbols()) {
            scopeList.add(staticScope.toScope(frame));
        }
        return Collections.unmodifiableList(scopeList);
    }

    private static void copySymbols(LLVMDebuggerScopeFactory source, LLVMDebuggerScopeFactory target) {
        if (!source.symbols.isEmpty()) {
            Set names = target.symbols.stream().map(LLVMSourceSymbol::getName).collect(Collectors.toSet());
            source.symbols.stream().filter(s -> !names.contains(s.getName())).forEach(target.symbols::add);
        }
    }

    private static LLVMDebuggerScopeFactory toScope(LLVMContext context, LLVMSourceLocation scope, LLVMSourceContext sourceContext, Node node, SourceSection sourceSection) {
        if (!scope.hasSymbols()) {
            LLVMDebuggerScopeFactory sourceScope = new LLVMDebuggerScopeFactory(context, sourceContext, node);
            sourceScope.setName(scope.getName());
            return sourceScope;
        }
        ArrayList<LLVMSourceSymbol> symbols = new ArrayList<LLVMSourceSymbol>();
        for (LLVMSourceSymbol symbol : scope.getSymbols()) {
            if (!symbol.isStatic() && !LLVMDebuggerScopeFactory.isDeclaredBefore(symbol, sourceSection)) continue;
            symbols.add(symbol);
        }
        LLVMDebuggerScopeFactory sourceScope = new LLVMDebuggerScopeFactory(context, sourceContext, symbols, node);
        sourceScope.setName(scope.getName());
        return sourceScope;
    }

    private static boolean isDeclaredBefore(LLVMSourceSymbol symbol, SourceSection useLoc) {
        if (useLoc == null) {
            return true;
        }
        LLVMSourceLocation symbolDecl = symbol.getLocation();
        if (symbolDecl == null) {
            return true;
        }
        SourceSection declLoc = symbolDecl.getSourceSection();
        if (declLoc == null) {
            return true;
        }
        if (declLoc.getSource().equals((Object)useLoc.getSource())) {
            return declLoc.getCharIndex() <= useLoc.getCharIndex();
        }
        return true;
    }

    private LLVMDebuggerScopeFactory(LLVMContext context, LLVMSourceContext sourceContext, Node node) {
        this(context, sourceContext, new ArrayList<LLVMSourceSymbol>(), node);
    }

    private LLVMDebuggerScopeFactory(LLVMContext context, LLVMSourceContext sourceContext, ArrayList<LLVMSourceSymbol> symbols, Node node) {
        this.context = context;
        this.sourceContext = sourceContext;
        this.symbols = symbols;
        this.node = node;
        this.name = DEFAULT_NAME;
    }

    private void setName(String name) {
        this.name = name;
    }

    private boolean hasSymbols() {
        return !this.symbols.isEmpty();
    }

    protected String getName() {
        return this.name;
    }

    private static String convertIdentifier(String identifier, LLVMContext context) {
        if (((Boolean)context.getEnv().getOptions().get(SulongEngineOption.LL_DEBUG)).booleanValue()) {
            return LLVMIdentifier.toLocalIdentifier(identifier);
        }
        try {
            Integer.parseInt(identifier);
            return LLVMIdentifier.toLocalIdentifier(identifier);
        }
        catch (NumberFormatException e) {
            return identifier;
        }
    }

    @CompilerDirectives.TruffleBoundary
    private LLVMDebuggerScopeEntries getVariables(Frame frame) {
        if (this.symbols.isEmpty()) {
            return LLVMDebuggerScopeEntries.EMPTY_SCOPE;
        }
        LLVMDebuggerScopeEntries vars = new LLVMDebuggerScopeEntries();
        if (frame != null) {
            for (FrameSlot slot : frame.getFrameDescriptor().getSlots()) {
                if (!(slot.getIdentifier() instanceof LLVMSourceSymbol) || !(frame.getValue(slot) instanceof LLVMDebugObjectBuilder)) continue;
                LLVMSourceSymbol symbol = (LLVMSourceSymbol)slot.getIdentifier();
                LLVMDebugObject value = ((LLVMDebugObjectBuilder)frame.getValue(slot)).getValue(symbol);
                if (!this.symbols.contains(symbol)) continue;
                vars.add(LLVMDebuggerScopeFactory.convertIdentifier(symbol.getName(), this.context), value);
            }
        }
        for (LLVMSourceSymbol symbol : this.symbols) {
            LLVMFrameValueAccess allocation;
            if (vars.contains(symbol.getName())) continue;
            LLVMDebugObjectBuilder dbgVal = this.sourceContext.getStatic(symbol);
            if (dbgVal == null && (allocation = this.sourceContext.getFrameValue(symbol)) != null && frame != null) {
                dbgVal = allocation.getValue(frame);
            }
            if (dbgVal == null) {
                dbgVal = LLVMDebugObjectBuilder.UNAVAILABLE;
            }
            vars.add(LLVMDebuggerScopeFactory.convertIdentifier(symbol.getName(), this.context), dbgVal.getValue(symbol));
        }
        return vars;
    }

    private Scope toScope(Frame frame) {
        LLVMDebuggerScopeEntries variables = this.getVariables(frame);
        Scope.Builder scopeBuilder = Scope.newBuilder((String)this.name, (Object)variables);
        if (variables.contains(DEFAULT_RECEIVER_NAME)) {
            scopeBuilder.receiver(DEFAULT_RECEIVER_NAME, variables.getElementForDebugger(DEFAULT_RECEIVER_NAME));
            variables.removeElement(DEFAULT_RECEIVER_NAME);
        } else {
            scopeBuilder.receiver(DEFAULT_RECEIVER_NAME, (Object)DEFAULT_RECEIVER);
        }
        scopeBuilder.node(this.node);
        return scopeBuilder.build();
    }
}

