/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.debug.scope;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMSourceSymbol;
import com.oracle.truffle.llvm.runtime.global.LLVMGlobal;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public abstract class LLVMSourceLocation {
    private static final int DEFAULT_SCOPE_CAPACITY = 2;
    private static final SourceSection UNAVAILABLE_SECTION;
    private static final List<LLVMSourceSymbol> NO_SYMBOLS;
    private final LLVMSourceLocation parent;
    private final Kind kind;
    private final String name;
    private final LazySourceSection lazySourceSection;
    private SourceSection sourceSection;

    private LLVMSourceLocation(LLVMSourceLocation parent, Kind kind, String name, LazySourceSection lazySourceSection) {
        this.parent = parent;
        this.kind = kind;
        this.name = name;
        this.lazySourceSection = lazySourceSection;
        this.sourceSection = null;
    }

    private LLVMSourceLocation(LLVMSourceLocation parent, Kind kind, String name, SourceSection sourceSection) {
        this.parent = parent;
        this.kind = kind;
        this.name = name;
        this.lazySourceSection = null;
        this.sourceSection = sourceSection;
    }

    public synchronized SourceSection getSourceSection() {
        CompilerAsserts.neverPartOfCompilation();
        if (this.sourceSection == null && this.lazySourceSection != null) {
            this.sourceSection = this.lazySourceSection.get();
        }
        return this.sourceSection != null ? this.sourceSection : UNAVAILABLE_SECTION;
    }

    private static String asFileName(String path) {
        CompilerAsserts.neverPartOfCompilation();
        if (path == null) {
            return UNAVAILABLE_SECTION.getSource().getName();
        }
        String name = path;
        try {
            Path asPath = Paths.get(name, new String[0]).getFileName();
            if (asPath != null) {
                name = asPath.toString();
            }
        }
        catch (InvalidPathException invalidPathException) {
            // empty catch block
        }
        return name;
    }

    public String describeFile() {
        CompilerAsserts.neverPartOfCompilation();
        if (this.lazySourceSection != null) {
            return LLVMSourceLocation.asFileName(this.lazySourceSection.getPath());
        }
        if (this.sourceSection != null) {
            return this.sourceSection.getSource().getName();
        }
        return UNAVAILABLE_SECTION.getSource().getName();
    }

    public int getLine() {
        CompilerAsserts.neverPartOfCompilation();
        if (this.lazySourceSection != null) {
            return this.lazySourceSection.getLine();
        }
        if (this.sourceSection != null) {
            return this.sourceSection.getStartLine();
        }
        return UNAVAILABLE_SECTION.getStartLine();
    }

    private int getColumn() {
        CompilerAsserts.neverPartOfCompilation();
        if (this.lazySourceSection != null) {
            return this.lazySourceSection.getColumn();
        }
        if (this.sourceSection != null) {
            return this.sourceSection.getStartColumn();
        }
        return UNAVAILABLE_SECTION.getStartColumn();
    }

    public String describeLocation() {
        CompilerAsserts.neverPartOfCompilation();
        String sourceName = this.describeFile();
        StringBuilder sb = new StringBuilder(sourceName);
        int line = this.getLine();
        if (line >= 0) {
            sb.append(':').append(line);
            int col = this.getColumn();
            if (col >= 0) {
                sb.append(':').append(col);
            }
        }
        return sb.toString();
    }

    public LLVMSourceLocation getParent() {
        return this.parent;
    }

    public Kind getKind() {
        return this.kind;
    }

    public void addSymbol(LLVMSourceSymbol symbol) {
    }

    public boolean hasSymbols() {
        return false;
    }

    public List<LLVMSourceSymbol> getSymbols() {
        return NO_SYMBOLS;
    }

    public LLVMSourceLocation getCompileUnit() {
        if (this.kind == Kind.COMPILEUNIT) {
            return this;
        }
        if (this.parent != null) {
            return this.parent.getCompileUnit();
        }
        return null;
    }

    @CompilerDirectives.TruffleBoundary
    public String getName() {
        if (this.kind == Kind.FILE) {
            return String.format("<%s>", this.describeFile());
        }
        if (this.kind == Kind.LINE) {
            return String.format("<%s>", this.describeLocation());
        }
        if (this.kind == null || this.kind == Kind.UNKNOWN) {
            return Kind.UNKNOWN.anonymousDescription;
        }
        if (this.name != null) {
            String prefix = this.kind.namePrefix;
            return prefix != null ? prefix + this.name : this.name;
        }
        return this.kind.anonymousDescription;
    }

    @CompilerDirectives.TruffleBoundary
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof LLVMSourceLocation) {
            LLVMSourceLocation that = (LLVMSourceLocation)o;
            if (this.hasSymbols() != that.hasSymbols()) {
                return false;
            }
            if (this.getKind() != that.getKind()) {
                return false;
            }
            if (!Objects.equals(this.describeFile(), that.describeFile())) {
                return false;
            }
            if (this.getLine() != that.getLine() || this.getColumn() != that.getColumn()) {
                return false;
            }
            return Objects.equals(this.getParent(), that.getParent());
        }
        return false;
    }

    public int hashCode() {
        int result = this.getKind().hashCode();
        result = 31 * result + (this.getName() != null ? this.getName().hashCode() : 0);
        return result;
    }

    public String toString() {
        return this.describeLocation();
    }

    public static TextModule createLLModule(String name, SourceSection sourceSection) {
        return new TextModule(name, sourceSection);
    }

    public static LLVMSourceLocation createLLInstruction(LLVMSourceLocation parent, SourceSection sourceSection) {
        return new LineScope(parent, Kind.LINE, "<line>", sourceSection);
    }

    public static LLVMSourceLocation create(LLVMSourceLocation parent, Kind kind, String name, LazySourceSection lazySourceSection, LLVMSourceLocation compileUnit) {
        switch (kind) {
            case LINE: 
            case GLOBAL: 
            case LOCAL: {
                return new LineScope(parent, kind, name, lazySourceSection);
            }
            case FUNCTION: {
                if (compileUnit != null) {
                    return new FunctionScope(parent, kind, name, lazySourceSection, compileUnit);
                }
                return new DefaultScope(parent, kind, name, lazySourceSection);
            }
        }
        return new DefaultScope(parent, kind, name, lazySourceSection);
    }

    public static LLVMSourceLocation createBitcodeFunction(String name, SourceSection sourceSection) {
        return new DefaultScope(null, Kind.FUNCTION, name, sourceSection != null ? sourceSection : UNAVAILABLE_SECTION);
    }

    public static LLVMSourceLocation createUnknown(SourceSection sourceSection) {
        return new LineScope(null, Kind.UNKNOWN, "<unknown>", sourceSection != null ? sourceSection : UNAVAILABLE_SECTION);
    }

    static {
        Source source = Source.newBuilder((String)"llvm", (CharSequence)"Source unavailable!", (String)"<unavailable>").mimeType("text/plain").build();
        UNAVAILABLE_SECTION = source.createUnavailableSection();
        NO_SYMBOLS = Collections.emptyList();
    }

    public static final class TextModule
    extends DefaultScope
    implements Iterable<LLVMGlobal> {
        private final List<LLVMGlobal> globals = new ArrayList<LLVMGlobal>();

        TextModule(String name, SourceSection sourceSection) {
            super(null, Kind.IR_MODULE, name, sourceSection);
        }

        public void addGlobal(LLVMGlobal global) {
            this.globals.add(global);
        }

        @Override
        public Iterator<LLVMGlobal> iterator() {
            return this.globals.iterator();
        }
    }

    private static final class FunctionScope
    extends DefaultScope {
        private final LLVMSourceLocation compileUnit;

        FunctionScope(LLVMSourceLocation parent, Kind kind, String name, LazySourceSection lazySourceSection, LLVMSourceLocation compileUnit) {
            super(parent, kind, name, lazySourceSection);
            this.compileUnit = compileUnit;
        }

        @Override
        public String describeLocation() {
            return String.format("%s at %s", this.getName(), super.describeLocation());
        }

        @Override
        public LLVMSourceLocation getCompileUnit() {
            return this.compileUnit;
        }
    }

    private static class DefaultScope
    extends LineScope {
        @CompilerDirectives.CompilationFinal
        private List<LLVMSourceSymbol> symbols = null;

        DefaultScope(LLVMSourceLocation parent, Kind kind, String name, LazySourceSection lazySourceSection) {
            super(parent, kind, name, lazySourceSection);
        }

        DefaultScope(LLVMSourceLocation parent, Kind kind, String name, SourceSection sourceSection) {
            super(parent, kind, name, sourceSection);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void addSymbol(LLVMSourceSymbol symbol) {
            CompilerAsserts.neverPartOfCompilation((String)"Source-Scope may only grow when parsing!");
            if (this.symbols == null) {
                this.symbols = new ArrayList<LLVMSourceSymbol>(2);
            }
            this.symbols.add(symbol);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean hasSymbols() {
            return this.symbols != null && !this.symbols.isEmpty();
        }

        @Override
        public List<LLVMSourceSymbol> getSymbols() {
            return this.symbols != null ? this.symbols : NO_SYMBOLS;
        }
    }

    private static class LineScope
    extends LLVMSourceLocation {
        LineScope(LLVMSourceLocation parent, Kind kind, String name, LazySourceSection lazySourceSection) {
            super(parent, kind, name, lazySourceSection);
        }

        LineScope(LLVMSourceLocation parent, Kind kind, String name, SourceSection sourceSection) {
            super(parent, kind, name, sourceSection);
        }
    }

    public static enum Kind {
        TYPE("<type>"),
        LINE("<line>"),
        MODULE("<module>", "module "),
        COMMON_BLOCK("<common block>"),
        BLOCK("<block>"),
        FUNCTION("<function>"),
        NAMESPACE("<namespace>", "namespace "),
        COMPILEUNIT("<static>"),
        FILE("<file>"),
        GLOBAL("<global symbol>"),
        LOCAL("<local symbol>"),
        IR_MODULE("<module>", "module "),
        LABEL("<label>"),
        UNKNOWN("<scope>");

        private final String anonymousDescription;
        private final String namePrefix;

        private Kind(String anonymousDescription) {
            this(anonymousDescription, null);
        }

        private Kind(String anonymousDescription, String namePrefix) {
            this.anonymousDescription = anonymousDescription;
            this.namePrefix = namePrefix;
        }
    }

    public static abstract class LazySourceSection {
        public abstract SourceSection get();

        public abstract String getPath();

        public abstract int getLine();

        public abstract int getColumn();
    }
}

