/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.debug.type;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.llvm.runtime.debug.type.LLVMSourceType;
import java.util.Collections;
import java.util.List;

public final class LLVMSourceFunctionType
extends LLVMSourceType {
    private final List<LLVMSourceType> types;

    @CompilerDirectives.TruffleBoundary
    public LLVMSourceFunctionType(List<LLVMSourceType> types) {
        super(0L, 0L, 0L, null);
        assert (types != null);
        this.types = types;
        this.setName(() -> {
            CompilerDirectives.transferToInterpreter();
            StringBuilder nameBuilder = new StringBuilder(this.getReturnType().getName()).append("(");
            List<LLVMSourceType> params = this.getParameterTypes();
            if (params.size() > 0) {
                nameBuilder.append(params.get(0).getName());
            }
            for (int i = 1; i < params.size(); ++i) {
                nameBuilder.append(", ").append(params.get(i).getName());
            }
            if (!this.isVarArgs()) {
                nameBuilder.append(")");
            } else if (this.getParameterTypes().size() == 0) {
                nameBuilder.append("...)");
            } else {
                nameBuilder.append(", ...)");
            }
            return nameBuilder.toString();
        });
    }

    @CompilerDirectives.TruffleBoundary
    public LLVMSourceType getReturnType() {
        if (this.types.size() > 0) {
            return this.types.get(0);
        }
        return LLVMSourceType.VOID;
    }

    @CompilerDirectives.TruffleBoundary
    public List<LLVMSourceType> getParameterTypes() {
        if (this.types.size() <= 1) {
            return Collections.emptyList();
        }
        return this.types.subList(1, this.types.size() - (this.isVarArgs() ? 1 : 0));
    }

    @CompilerDirectives.TruffleBoundary
    public boolean isVarArgs() {
        return this.types.size() > 1 && this.types.get(this.types.size() - 1) == LLVMSourceType.VOID;
    }

    @Override
    public LLVMSourceType getOffset(long newOffset) {
        return this;
    }
}

