/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.global;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.global.LLVMGlobalContainer;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedReadLibrary;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedWriteLibrary;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMNativeLibrary;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMToNativeNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMToNativeNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMToPointerNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMToPointerNodeGen;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=LLVMGlobalContainer.class)
final class LLVMGlobalContainerGen {
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);
    private static final LibraryFactory<LLVMNativeLibrary> L_L_V_M_NATIVE_LIBRARY_ = LibraryFactory.resolve(LLVMNativeLibrary.class);

    private LLVMGlobalContainerGen() {
    }

    static {
        LibraryExport.register(LLVMGlobalContainer.class, (LibraryExport[])new LibraryExport[]{new InteropLibraryExports(), new LLVMManagedReadLibraryExports(), new LLVMManagedWriteLibraryExports()});
    }

    @GeneratedBy(value=LLVMGlobalContainer.class)
    private static final class LLVMManagedWriteLibraryExports
    extends LibraryExport<LLVMManagedWriteLibrary> {
        private LLVMManagedWriteLibraryExports() {
            super(LLVMManagedWriteLibrary.class, LLVMGlobalContainer.class, false);
        }

        protected LLVMManagedWriteLibrary createUncached(Object receiver) {
            assert (receiver instanceof LLVMGlobalContainer);
            return new Uncached();
        }

        protected LLVMManagedWriteLibrary createCached(Object receiver) {
            assert (receiver instanceof LLVMGlobalContainer);
            return new Cached(receiver);
        }

        @GeneratedBy(value=LLVMGlobalContainer.class)
        private static final class Uncached
        extends LLVMManagedWriteLibrary {
            private final TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference_ = this.lookupLanguageReference(LLVMLanguage.class);

            Uncached() {
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof LLVMGlobalContainer) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export 'com.oracle.truffle.llvm.runtime.global.LLVMGlobalContainer'. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof LLVMGlobalContainer;
            }

            public boolean isAdoptable() {
                return false;
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void writeI8(Object arg0Value_, long arg1Value, byte arg2Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMGlobalContainer arg0Value = (LLVMGlobalContainer)arg0Value_;
                if (arg0Value.isPointer()) {
                    LLVMGlobalContainer.WriteI8.writeNative(arg0Value, arg1Value, arg2Value, (LLVMLanguage)this.lLVMLanguageReference_.get());
                    return;
                }
                if (!arg0Value.isPointer()) {
                    LLVMGlobalContainer.WriteI8.writeManaged(arg0Value, arg1Value, arg2Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached((Object)arg0Value), this);
                    return;
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null, null}, new Object[]{arg0Value, arg1Value, arg2Value});
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void writeI16(Object arg0Value_, long arg1Value, short arg2Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMGlobalContainer arg0Value = (LLVMGlobalContainer)arg0Value_;
                if (arg0Value.isPointer()) {
                    LLVMGlobalContainer.WriteI16.writeNative(arg0Value, arg1Value, arg2Value, (LLVMLanguage)this.lLVMLanguageReference_.get());
                    return;
                }
                if (!arg0Value.isPointer()) {
                    LLVMGlobalContainer.WriteI16.writeManaged(arg0Value, arg1Value, arg2Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached((Object)arg0Value), this);
                    return;
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null, null}, new Object[]{arg0Value, arg1Value, arg2Value});
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void writeI32(Object arg0Value_, long arg1Value, int arg2Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMGlobalContainer arg0Value = (LLVMGlobalContainer)arg0Value_;
                if (arg0Value.isPointer()) {
                    LLVMGlobalContainer.WriteI32.writeNative(arg0Value, arg1Value, arg2Value, (LLVMLanguage)this.lLVMLanguageReference_.get());
                    return;
                }
                if (!arg0Value.isPointer()) {
                    LLVMGlobalContainer.WriteI32.writeManaged(arg0Value, arg1Value, arg2Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached((Object)arg0Value), this);
                    return;
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null, null}, new Object[]{arg0Value, arg1Value, arg2Value});
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void writeFloat(Object arg0Value_, long arg1Value, float arg2Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMGlobalContainer arg0Value = (LLVMGlobalContainer)arg0Value_;
                if (arg0Value.isPointer()) {
                    LLVMGlobalContainer.WriteFloat.writeNative(arg0Value, arg1Value, arg2Value, (LLVMLanguage)this.lLVMLanguageReference_.get());
                    return;
                }
                if (!arg0Value.isPointer()) {
                    LLVMGlobalContainer.WriteFloat.writeManaged(arg0Value, arg1Value, arg2Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached((Object)arg0Value), this);
                    return;
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null, null}, new Object[]{arg0Value, arg1Value, Float.valueOf(arg2Value)});
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void writeDouble(Object arg0Value_, long arg1Value, double arg2Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMGlobalContainer arg0Value = (LLVMGlobalContainer)arg0Value_;
                if (arg0Value.isPointer()) {
                    LLVMGlobalContainer.WriteDouble.writeNative(arg0Value, arg1Value, arg2Value, (LLVMLanguage)this.lLVMLanguageReference_.get());
                    return;
                }
                if (!arg0Value.isPointer()) {
                    LLVMGlobalContainer.WriteDouble.writeManaged(arg0Value, arg1Value, arg2Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached((Object)arg0Value), this);
                    return;
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null, null}, new Object[]{arg0Value, arg1Value, arg2Value});
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void writeI64(Object arg0Value_, long arg1Value, long arg2Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMGlobalContainer arg0Value = (LLVMGlobalContainer)arg0Value_;
                if (arg0Value.isPointer()) {
                    LLVMGlobalContainer.WriteI64.writeNative(arg0Value, arg1Value, arg2Value, (LLVMLanguage)this.lLVMLanguageReference_.get());
                    return;
                }
                if (!arg0Value.isPointer() && arg1Value == 0L) {
                    LLVMGlobalContainer.WriteI64.writeManaged(arg0Value, arg1Value, arg2Value);
                    return;
                }
                if (!arg0Value.isPointer() && arg1Value != 0L) {
                    LLVMGlobalContainer.WriteI64.writeFallback(arg0Value, arg1Value, arg2Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached((Object)arg0Value), this);
                    return;
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null, null}, new Object[]{arg0Value, arg1Value, arg2Value});
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void writeGenericI64(Object arg0Value_, long arg1Value, Object arg2Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMGlobalContainer arg0Value = (LLVMGlobalContainer)arg0Value_;
                if (arg0Value.isPointer()) {
                    LLVMGlobalContainer.WriteGenericI64.writeNative(arg0Value, arg1Value, arg2Value, (LLVMNativeLibrary)L_L_V_M_NATIVE_LIBRARY_.getUncached(arg2Value), (LLVMLanguage)this.lLVMLanguageReference_.get());
                    return;
                }
                if (!arg0Value.isPointer() && arg1Value == 0L) {
                    LLVMGlobalContainer.WriteGenericI64.writeManaged(arg0Value, arg1Value, arg2Value);
                    return;
                }
                if (!arg0Value.isPointer() && arg1Value != 0L) {
                    LLVMGlobalContainer.WriteGenericI64.writeFallback(arg0Value, arg1Value, arg2Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached((Object)arg0Value), this);
                    return;
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null, null}, new Object[]{arg0Value, arg1Value, arg2Value});
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isWritable(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMGlobalContainer)receiver).isAccessible();
            }
        }

        @GeneratedBy(value=LLVMGlobalContainer.class)
        private static final class Cached
        extends LLVMManagedWriteLibrary {
            @Node.Child
            private InteropLibrary receiverInteropLibrary;
            @CompilerDirectives.CompilationFinal
            private int state_;
            @CompilerDirectives.CompilationFinal
            private int exclude_;
            @CompilerDirectives.CompilationFinal
            private TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference_;
            @Node.Child
            private WriteGenericI64WriteNative0Data writeGenericI64_writeNative0_cache;

            Cached(Object receiver) {
                this.receiverInteropLibrary = (InteropLibrary)this.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.create(receiver)));
            }

            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof LLVMGlobalContainer) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export 'com.oracle.truffle.llvm.runtime.global.LLVMGlobalContainer'. Exported receiver with dynamic dispatch found but not expected.";
                if (!(receiver instanceof LLVMGlobalContainer)) {
                    return false;
                }
                return this.receiverInteropLibrary.accepts(receiver);
            }

            @Override
            public void writeI8(Object arg0Value_, long arg1Value, byte arg2Value) {
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMGlobalContainer arg0Value = (LLVMGlobalContainer)arg0Value_;
                int state = this.state_;
                if ((state & 3) != 0) {
                    if ((state & 1) != 0 && arg0Value.isPointer()) {
                        LLVMGlobalContainer.WriteI8.writeNative(arg0Value, arg1Value, arg2Value, (LLVMLanguage)this.lLVMLanguageReference_.get());
                        return;
                    }
                    if ((state & 2) != 0 && !arg0Value.isPointer()) {
                        LLVMGlobalContainer.WriteI8.writeManaged(arg0Value, arg1Value, arg2Value, this.receiverInteropLibrary, this);
                        return;
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.writeI8AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            private void writeI8AndSpecialize(LLVMGlobalContainer arg0Value, long arg1Value, byte arg2Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    if (arg0Value.isPointer()) {
                        TruffleLanguage.LanguageReference lLVMLanguageReference__ = this.lLVMLanguageReference_;
                        if (lLVMLanguageReference__ == null) {
                            this.lLVMLanguageReference_ = lLVMLanguageReference__ = super.lookupLanguageReference(LLVMLanguage.class);
                        }
                        this.state_ = state |= 1;
                        lock.unlock();
                        hasLock = false;
                        LLVMGlobalContainer.WriteI8.writeNative(arg0Value, arg1Value, arg2Value, (LLVMLanguage)lLVMLanguageReference__.get());
                        return;
                    }
                    if (!arg0Value.isPointer()) {
                        this.state_ = state |= 2;
                        lock.unlock();
                        hasLock = false;
                        LLVMGlobalContainer.WriteI8.writeManaged(arg0Value, arg1Value, arg2Value, this.receiverInteropLibrary, this);
                        return;
                    }
                    throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null, null}, new Object[]{arg0Value, arg1Value, arg2Value});
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public NodeCost getCost() {
                int state = this.state_;
                if ((state & 3) == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                if ((state & 3 & (state & 3) - 1) == 0) {
                    return NodeCost.MONOMORPHIC;
                }
                return NodeCost.POLYMORPHIC;
            }

            @Override
            public void writeI16(Object arg0Value_, long arg1Value, short arg2Value) {
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMGlobalContainer arg0Value = (LLVMGlobalContainer)arg0Value_;
                int state = this.state_;
                if ((state & 0xC) != 0) {
                    if ((state & 4) != 0 && arg0Value.isPointer()) {
                        LLVMGlobalContainer.WriteI16.writeNative(arg0Value, arg1Value, arg2Value, (LLVMLanguage)this.lLVMLanguageReference_.get());
                        return;
                    }
                    if ((state & 8) != 0 && !arg0Value.isPointer()) {
                        LLVMGlobalContainer.WriteI16.writeManaged(arg0Value, arg1Value, arg2Value, this.receiverInteropLibrary, this);
                        return;
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.writeI16AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            private void writeI16AndSpecialize(LLVMGlobalContainer arg0Value, long arg1Value, short arg2Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    if (arg0Value.isPointer()) {
                        TruffleLanguage.LanguageReference lLVMLanguageReference__ = this.lLVMLanguageReference_;
                        if (lLVMLanguageReference__ == null) {
                            this.lLVMLanguageReference_ = lLVMLanguageReference__ = super.lookupLanguageReference(LLVMLanguage.class);
                        }
                        this.state_ = state |= 4;
                        lock.unlock();
                        hasLock = false;
                        LLVMGlobalContainer.WriteI16.writeNative(arg0Value, arg1Value, arg2Value, (LLVMLanguage)lLVMLanguageReference__.get());
                        return;
                    }
                    if (!arg0Value.isPointer()) {
                        this.state_ = state |= 8;
                        lock.unlock();
                        hasLock = false;
                        LLVMGlobalContainer.WriteI16.writeManaged(arg0Value, arg1Value, arg2Value, this.receiverInteropLibrary, this);
                        return;
                    }
                    throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null, null}, new Object[]{arg0Value, arg1Value, arg2Value});
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public void writeI32(Object arg0Value_, long arg1Value, int arg2Value) {
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMGlobalContainer arg0Value = (LLVMGlobalContainer)arg0Value_;
                int state = this.state_;
                if ((state & 0x30) != 0) {
                    if ((state & 0x10) != 0 && arg0Value.isPointer()) {
                        LLVMGlobalContainer.WriteI32.writeNative(arg0Value, arg1Value, arg2Value, (LLVMLanguage)this.lLVMLanguageReference_.get());
                        return;
                    }
                    if ((state & 0x20) != 0 && !arg0Value.isPointer()) {
                        LLVMGlobalContainer.WriteI32.writeManaged(arg0Value, arg1Value, arg2Value, this.receiverInteropLibrary, this);
                        return;
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.writeI32AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            private void writeI32AndSpecialize(LLVMGlobalContainer arg0Value, long arg1Value, int arg2Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    if (arg0Value.isPointer()) {
                        TruffleLanguage.LanguageReference lLVMLanguageReference__ = this.lLVMLanguageReference_;
                        if (lLVMLanguageReference__ == null) {
                            this.lLVMLanguageReference_ = lLVMLanguageReference__ = super.lookupLanguageReference(LLVMLanguage.class);
                        }
                        this.state_ = state |= 0x10;
                        lock.unlock();
                        hasLock = false;
                        LLVMGlobalContainer.WriteI32.writeNative(arg0Value, arg1Value, arg2Value, (LLVMLanguage)lLVMLanguageReference__.get());
                        return;
                    }
                    if (!arg0Value.isPointer()) {
                        this.state_ = state |= 0x20;
                        lock.unlock();
                        hasLock = false;
                        LLVMGlobalContainer.WriteI32.writeManaged(arg0Value, arg1Value, arg2Value, this.receiverInteropLibrary, this);
                        return;
                    }
                    throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null, null}, new Object[]{arg0Value, arg1Value, arg2Value});
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public void writeFloat(Object arg0Value_, long arg1Value, float arg2Value) {
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMGlobalContainer arg0Value = (LLVMGlobalContainer)arg0Value_;
                int state = this.state_;
                if ((state & 0xC0) != 0) {
                    if ((state & 0x40) != 0 && arg0Value.isPointer()) {
                        LLVMGlobalContainer.WriteFloat.writeNative(arg0Value, arg1Value, arg2Value, (LLVMLanguage)this.lLVMLanguageReference_.get());
                        return;
                    }
                    if ((state & 0x80) != 0 && !arg0Value.isPointer()) {
                        LLVMGlobalContainer.WriteFloat.writeManaged(arg0Value, arg1Value, arg2Value, this.receiverInteropLibrary, this);
                        return;
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.writeFloatAndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            private void writeFloatAndSpecialize(LLVMGlobalContainer arg0Value, long arg1Value, float arg2Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    if (arg0Value.isPointer()) {
                        TruffleLanguage.LanguageReference lLVMLanguageReference__ = this.lLVMLanguageReference_;
                        if (lLVMLanguageReference__ == null) {
                            this.lLVMLanguageReference_ = lLVMLanguageReference__ = super.lookupLanguageReference(LLVMLanguage.class);
                        }
                        this.state_ = state |= 0x40;
                        lock.unlock();
                        hasLock = false;
                        LLVMGlobalContainer.WriteFloat.writeNative(arg0Value, arg1Value, arg2Value, (LLVMLanguage)lLVMLanguageReference__.get());
                        return;
                    }
                    if (!arg0Value.isPointer()) {
                        this.state_ = state |= 0x80;
                        lock.unlock();
                        hasLock = false;
                        LLVMGlobalContainer.WriteFloat.writeManaged(arg0Value, arg1Value, arg2Value, this.receiverInteropLibrary, this);
                        return;
                    }
                    throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null, null}, new Object[]{arg0Value, arg1Value, Float.valueOf(arg2Value)});
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public void writeDouble(Object arg0Value_, long arg1Value, double arg2Value) {
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMGlobalContainer arg0Value = (LLVMGlobalContainer)arg0Value_;
                int state = this.state_;
                if ((state & 0x300) != 0) {
                    if ((state & 0x100) != 0 && arg0Value.isPointer()) {
                        LLVMGlobalContainer.WriteDouble.writeNative(arg0Value, arg1Value, arg2Value, (LLVMLanguage)this.lLVMLanguageReference_.get());
                        return;
                    }
                    if ((state & 0x200) != 0 && !arg0Value.isPointer()) {
                        LLVMGlobalContainer.WriteDouble.writeManaged(arg0Value, arg1Value, arg2Value, this.receiverInteropLibrary, this);
                        return;
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.writeDoubleAndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            private void writeDoubleAndSpecialize(LLVMGlobalContainer arg0Value, long arg1Value, double arg2Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    if (arg0Value.isPointer()) {
                        TruffleLanguage.LanguageReference lLVMLanguageReference__ = this.lLVMLanguageReference_;
                        if (lLVMLanguageReference__ == null) {
                            this.lLVMLanguageReference_ = lLVMLanguageReference__ = super.lookupLanguageReference(LLVMLanguage.class);
                        }
                        this.state_ = state |= 0x100;
                        lock.unlock();
                        hasLock = false;
                        LLVMGlobalContainer.WriteDouble.writeNative(arg0Value, arg1Value, arg2Value, (LLVMLanguage)lLVMLanguageReference__.get());
                        return;
                    }
                    if (!arg0Value.isPointer()) {
                        this.state_ = state |= 0x200;
                        lock.unlock();
                        hasLock = false;
                        LLVMGlobalContainer.WriteDouble.writeManaged(arg0Value, arg1Value, arg2Value, this.receiverInteropLibrary, this);
                        return;
                    }
                    throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null, null}, new Object[]{arg0Value, arg1Value, arg2Value});
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public void writeI64(Object arg0Value_, long arg1Value, long arg2Value) {
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMGlobalContainer arg0Value = (LLVMGlobalContainer)arg0Value_;
                int state = this.state_;
                if ((state & 0x1C00) != 0) {
                    if ((state & 0x400) != 0 && arg0Value.isPointer()) {
                        LLVMGlobalContainer.WriteI64.writeNative(arg0Value, arg1Value, arg2Value, (LLVMLanguage)this.lLVMLanguageReference_.get());
                        return;
                    }
                    if ((state & 0x800) != 0 && !arg0Value.isPointer() && arg1Value == 0L) {
                        LLVMGlobalContainer.WriteI64.writeManaged(arg0Value, arg1Value, arg2Value);
                        return;
                    }
                    if ((state & 0x1000) != 0 && !arg0Value.isPointer() && arg1Value != 0L) {
                        LLVMGlobalContainer.WriteI64.writeFallback(arg0Value, arg1Value, arg2Value, this.receiverInteropLibrary, this);
                        return;
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.writeI64AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            private void writeI64AndSpecialize(LLVMGlobalContainer arg0Value, long arg1Value, long arg2Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    if (arg0Value.isPointer()) {
                        TruffleLanguage.LanguageReference lLVMLanguageReference__ = this.lLVMLanguageReference_;
                        if (lLVMLanguageReference__ == null) {
                            this.lLVMLanguageReference_ = lLVMLanguageReference__ = super.lookupLanguageReference(LLVMLanguage.class);
                        }
                        this.state_ = state |= 0x400;
                        lock.unlock();
                        hasLock = false;
                        LLVMGlobalContainer.WriteI64.writeNative(arg0Value, arg1Value, arg2Value, (LLVMLanguage)lLVMLanguageReference__.get());
                        return;
                    }
                    if (!arg0Value.isPointer() && arg1Value == 0L) {
                        this.state_ = state |= 0x800;
                        lock.unlock();
                        hasLock = false;
                        LLVMGlobalContainer.WriteI64.writeManaged(arg0Value, arg1Value, arg2Value);
                        return;
                    }
                    if (!arg0Value.isPointer() && arg1Value != 0L) {
                        this.state_ = state |= 0x1000;
                        lock.unlock();
                        hasLock = false;
                        LLVMGlobalContainer.WriteI64.writeFallback(arg0Value, arg1Value, arg2Value, this.receiverInteropLibrary, this);
                        return;
                    }
                    throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null, null}, new Object[]{arg0Value, arg1Value, arg2Value});
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
            public void writeGenericI64(Object arg0Value_, long arg1Value, Object arg2Value) {
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMGlobalContainer arg0Value = (LLVMGlobalContainer)arg0Value_;
                int state = this.state_;
                if ((state & 0x1E000) != 0) {
                    if ((state & 0x2000) != 0) {
                        WriteGenericI64WriteNative0Data s1_ = this.writeGenericI64_writeNative0_cache;
                        while (s1_ != null) {
                            if (s1_.toNative_.accepts(arg2Value) && arg0Value.isPointer()) {
                                LLVMGlobalContainer.WriteGenericI64.writeNative(arg0Value, arg1Value, arg2Value, s1_.toNative_, (LLVMLanguage)this.lLVMLanguageReference_.get());
                                return;
                            }
                            s1_ = s1_.next_;
                        }
                    }
                    if ((state & 0x4000) != 0 && arg0Value.isPointer()) {
                        this.writeNative1Boundary(state, arg0Value, arg1Value, arg2Value);
                        return;
                    }
                    if ((state & 0x8000) != 0 && !arg0Value.isPointer() && arg1Value == 0L) {
                        LLVMGlobalContainer.WriteGenericI64.writeManaged(arg0Value, arg1Value, arg2Value);
                        return;
                    }
                    if ((state & 0x10000) != 0 && !arg0Value.isPointer() && arg1Value != 0L) {
                        LLVMGlobalContainer.WriteGenericI64.writeFallback(arg0Value, arg1Value, arg2Value, this.receiverInteropLibrary, this);
                        return;
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.writeGenericI64AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @CompilerDirectives.TruffleBoundary
            private void writeNative1Boundary(int state, LLVMGlobalContainer arg0Value, long arg1Value, Object arg2Value) {
                Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
                try {
                    LLVMGlobalContainer.WriteGenericI64.writeNative(arg0Value, arg1Value, arg2Value, (LLVMNativeLibrary)L_L_V_M_NATIVE_LIBRARY_.getUncached(arg2Value), (LLVMLanguage)this.lLVMLanguageReference_.get());
                    return;
                }
                finally {
                    NodeUtil.popEncapsulatingNode((Node)prev_);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void writeGenericI64AndSpecialize(LLVMGlobalContainer arg0Value, long arg1Value, Object arg2Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                int exclude = this.exclude_;
                try {
                    if (exclude == 0) {
                        int count1_ = 0;
                        WriteGenericI64WriteNative0Data s1_ = this.writeGenericI64_writeNative0_cache;
                        if ((state & 0x2000) != 0) {
                            while (!(s1_ == null || s1_.toNative_.accepts(arg2Value) && arg0Value.isPointer())) {
                                s1_ = s1_.next_;
                                ++count1_;
                            }
                        }
                        if (s1_ == null && arg0Value.isPointer() && count1_ < 3) {
                            s1_ = (WriteGenericI64WriteNative0Data)super.insert((Node)new WriteGenericI64WriteNative0Data(this.writeGenericI64_writeNative0_cache));
                            s1_.toNative_ = s1_.insertAccessor((LLVMNativeLibrary)L_L_V_M_NATIVE_LIBRARY_.create(arg2Value));
                            TruffleLanguage.LanguageReference lLVMLanguageReference__ = this.lLVMLanguageReference_;
                            if (lLVMLanguageReference__ == null) {
                                this.lLVMLanguageReference_ = lLVMLanguageReference__ = super.lookupLanguageReference(LLVMLanguage.class);
                            }
                            this.writeGenericI64_writeNative0_cache = s1_;
                            this.state_ = state |= 0x2000;
                        }
                        if (s1_ != null) {
                            lock.unlock();
                            hasLock = false;
                            LLVMGlobalContainer.WriteGenericI64.writeNative(arg0Value, arg1Value, arg2Value, s1_.toNative_, (LLVMLanguage)this.lLVMLanguageReference_.get());
                            return;
                        }
                    }
                    Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
                    try {
                        if (arg0Value.isPointer()) {
                            TruffleLanguage.LanguageReference lLVMLanguageReference__ = this.lLVMLanguageReference_;
                            if (lLVMLanguageReference__ == null) {
                                this.lLVMLanguageReference_ = lLVMLanguageReference__ = super.lookupLanguageReference(LLVMLanguage.class);
                            }
                            this.exclude_ = exclude |= 1;
                            this.writeGenericI64_writeNative0_cache = null;
                            state &= 0xFFFFDFFF;
                            this.state_ = state |= 0x4000;
                            lock.unlock();
                            hasLock = false;
                            LLVMGlobalContainer.WriteGenericI64.writeNative(arg0Value, arg1Value, arg2Value, (LLVMNativeLibrary)L_L_V_M_NATIVE_LIBRARY_.getUncached(arg2Value), (LLVMLanguage)lLVMLanguageReference__.get());
                            return;
                        }
                    }
                    finally {
                        NodeUtil.popEncapsulatingNode((Node)prev_);
                    }
                    if (!arg0Value.isPointer() && arg1Value == 0L) {
                        this.state_ = state |= 0x8000;
                        lock.unlock();
                        hasLock = false;
                        LLVMGlobalContainer.WriteGenericI64.writeManaged(arg0Value, arg1Value, arg2Value);
                        return;
                    }
                    if (!arg0Value.isPointer() && arg1Value != 0L) {
                        this.state_ = state |= 0x10000;
                        lock.unlock();
                        hasLock = false;
                        LLVMGlobalContainer.WriteGenericI64.writeFallback(arg0Value, arg1Value, arg2Value, this.receiverInteropLibrary, this);
                        return;
                    }
                    throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null, null}, new Object[]{arg0Value, arg1Value, arg2Value});
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean isWritable(Object receiver) {
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMGlobalContainer)receiver).isAccessible();
            }

            @GeneratedBy(value=LLVMGlobalContainer.class)
            private static final class WriteGenericI64WriteNative0Data
            extends Node {
                @Node.Child
                WriteGenericI64WriteNative0Data next_;
                @Node.Child
                LLVMNativeLibrary toNative_;

                WriteGenericI64WriteNative0Data(WriteGenericI64WriteNative0Data next_) {
                    this.next_ = next_;
                }

                public NodeCost getCost() {
                    return NodeCost.NONE;
                }

                <T extends Node> T insertAccessor(T node) {
                    return (T)super.insert(node);
                }
            }
        }
    }

    @GeneratedBy(value=LLVMGlobalContainer.class)
    private static final class LLVMManagedReadLibraryExports
    extends LibraryExport<LLVMManagedReadLibrary> {
        private LLVMManagedReadLibraryExports() {
            super(LLVMManagedReadLibrary.class, LLVMGlobalContainer.class, false);
        }

        protected LLVMManagedReadLibrary createUncached(Object receiver) {
            assert (receiver instanceof LLVMGlobalContainer);
            return new Uncached();
        }

        protected LLVMManagedReadLibrary createCached(Object receiver) {
            assert (receiver instanceof LLVMGlobalContainer);
            return new Cached(receiver);
        }

        @GeneratedBy(value=LLVMGlobalContainer.class)
        private static final class Uncached
        extends LLVMManagedReadLibrary {
            private final TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference_ = this.lookupLanguageReference(LLVMLanguage.class);

            Uncached() {
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof LLVMGlobalContainer) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export 'com.oracle.truffle.llvm.runtime.global.LLVMGlobalContainer'. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof LLVMGlobalContainer;
            }

            public boolean isAdoptable() {
                return false;
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public byte readI8(Object arg0Value_, long arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMGlobalContainer arg0Value = (LLVMGlobalContainer)arg0Value_;
                if (arg0Value.isPointer()) {
                    return LLVMGlobalContainer.ReadI8.readNative(arg0Value, arg1Value, (LLVMLanguage)this.lLVMLanguageReference_.get());
                }
                if (!arg0Value.isPointer()) {
                    return LLVMGlobalContainer.ReadI8.readManaged(arg0Value, arg1Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached((Object)arg0Value), this);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public short readI16(Object arg0Value_, long arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMGlobalContainer arg0Value = (LLVMGlobalContainer)arg0Value_;
                if (arg0Value.isPointer()) {
                    return LLVMGlobalContainer.ReadI16.readNative(arg0Value, arg1Value, (LLVMLanguage)this.lLVMLanguageReference_.get());
                }
                if (!arg0Value.isPointer()) {
                    return LLVMGlobalContainer.ReadI16.readManaged(arg0Value, arg1Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached((Object)arg0Value), this);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int readI32(Object arg0Value_, long arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMGlobalContainer arg0Value = (LLVMGlobalContainer)arg0Value_;
                if (arg0Value.isPointer()) {
                    return LLVMGlobalContainer.ReadI32.readNative(arg0Value, arg1Value, (LLVMLanguage)this.lLVMLanguageReference_.get());
                }
                if (!arg0Value.isPointer()) {
                    return LLVMGlobalContainer.ReadI32.readManaged(arg0Value, arg1Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached((Object)arg0Value), this);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public float readFloat(Object arg0Value_, long arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMGlobalContainer arg0Value = (LLVMGlobalContainer)arg0Value_;
                if (arg0Value.isPointer()) {
                    return LLVMGlobalContainer.ReadFloat.readNative(arg0Value, arg1Value, (LLVMLanguage)this.lLVMLanguageReference_.get());
                }
                if (!arg0Value.isPointer()) {
                    return LLVMGlobalContainer.ReadFloat.readManaged(arg0Value, arg1Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached((Object)arg0Value), this);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public double readDouble(Object arg0Value_, long arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMGlobalContainer arg0Value = (LLVMGlobalContainer)arg0Value_;
                if (arg0Value.isPointer()) {
                    return LLVMGlobalContainer.ReadDouble.readNative(arg0Value, arg1Value, (LLVMLanguage)this.lLVMLanguageReference_.get());
                }
                if (!arg0Value.isPointer()) {
                    return LLVMGlobalContainer.ReadDouble.readManaged(arg0Value, arg1Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached((Object)arg0Value), this);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object readGenericI64(Object arg0Value_, long arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMGlobalContainer arg0Value = (LLVMGlobalContainer)arg0Value_;
                if (arg0Value.isPointer()) {
                    return LLVMGlobalContainer.ReadGenericI64.readNative(arg0Value, arg1Value, (LLVMLanguage)this.lLVMLanguageReference_.get());
                }
                if (!arg0Value.isPointer() && arg1Value == 0L) {
                    return LLVMGlobalContainer.ReadGenericI64.readManaged(arg0Value, arg1Value);
                }
                if (!arg0Value.isPointer() && arg1Value != 0L) {
                    return LLVMGlobalContainer.ReadGenericI64.readFallback(arg0Value, arg1Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached((Object)arg0Value), this);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public LLVMPointer readPointer(Object arg0Value_, long arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMGlobalContainer arg0Value = (LLVMGlobalContainer)arg0Value_;
                if (arg0Value.isPointer()) {
                    return LLVMGlobalContainer.ReadPointer.readNative(arg0Value, arg1Value, (LLVMLanguage)this.lLVMLanguageReference_.get());
                }
                if (!arg0Value.isPointer() && arg1Value == 0L) {
                    return LLVMGlobalContainer.ReadPointer.readManaged(arg0Value, arg1Value, LLVMToPointerNodeGen.getUncached());
                }
                if (!arg0Value.isPointer() && arg1Value != 0L) {
                    return LLVMGlobalContainer.ReadPointer.readFallback(arg0Value, arg1Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached((Object)arg0Value), this);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isReadable(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMGlobalContainer)receiver).isAccessible();
            }
        }

        @GeneratedBy(value=LLVMGlobalContainer.class)
        private static final class Cached
        extends LLVMManagedReadLibrary {
            @Node.Child
            private InteropLibrary receiverInteropLibrary;
            @CompilerDirectives.CompilationFinal
            private int state_;
            @CompilerDirectives.CompilationFinal
            private TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference_;
            @Node.Child
            private LLVMToPointerNode readPointer_readManaged_toPointer_;

            Cached(Object receiver) {
                this.receiverInteropLibrary = (InteropLibrary)this.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.create(receiver)));
            }

            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof LLVMGlobalContainer) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export 'com.oracle.truffle.llvm.runtime.global.LLVMGlobalContainer'. Exported receiver with dynamic dispatch found but not expected.";
                if (!(receiver instanceof LLVMGlobalContainer)) {
                    return false;
                }
                return this.receiverInteropLibrary.accepts(receiver);
            }

            @Override
            public byte readI8(Object arg0Value_, long arg1Value) {
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMGlobalContainer arg0Value = (LLVMGlobalContainer)arg0Value_;
                int state = this.state_;
                if ((state & 3) != 0) {
                    if ((state & 1) != 0 && arg0Value.isPointer()) {
                        return LLVMGlobalContainer.ReadI8.readNative(arg0Value, arg1Value, (LLVMLanguage)this.lLVMLanguageReference_.get());
                    }
                    if ((state & 2) != 0 && !arg0Value.isPointer()) {
                        return LLVMGlobalContainer.ReadI8.readManaged(arg0Value, arg1Value, this.receiverInteropLibrary, this);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.readI8AndSpecialize(arg0Value, arg1Value);
            }

            private byte readI8AndSpecialize(LLVMGlobalContainer arg0Value, long arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    if (arg0Value.isPointer()) {
                        TruffleLanguage.LanguageReference lLVMLanguageReference__ = this.lLVMLanguageReference_;
                        if (lLVMLanguageReference__ == null) {
                            this.lLVMLanguageReference_ = lLVMLanguageReference__ = super.lookupLanguageReference(LLVMLanguage.class);
                        }
                        this.state_ = state |= 1;
                        lock.unlock();
                        hasLock = false;
                        byte by = LLVMGlobalContainer.ReadI8.readNative(arg0Value, arg1Value, (LLVMLanguage)lLVMLanguageReference__.get());
                        return by;
                    }
                    if (!arg0Value.isPointer()) {
                        this.state_ = state |= 2;
                        lock.unlock();
                        hasLock = false;
                        byte by = LLVMGlobalContainer.ReadI8.readManaged(arg0Value, arg1Value, this.receiverInteropLibrary, this);
                        return by;
                    }
                    throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public NodeCost getCost() {
                int state = this.state_;
                if ((state & 3) == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                if ((state & 3 & (state & 3) - 1) == 0) {
                    return NodeCost.MONOMORPHIC;
                }
                return NodeCost.POLYMORPHIC;
            }

            @Override
            public short readI16(Object arg0Value_, long arg1Value) {
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMGlobalContainer arg0Value = (LLVMGlobalContainer)arg0Value_;
                int state = this.state_;
                if ((state & 0xC) != 0) {
                    if ((state & 4) != 0 && arg0Value.isPointer()) {
                        return LLVMGlobalContainer.ReadI16.readNative(arg0Value, arg1Value, (LLVMLanguage)this.lLVMLanguageReference_.get());
                    }
                    if ((state & 8) != 0 && !arg0Value.isPointer()) {
                        return LLVMGlobalContainer.ReadI16.readManaged(arg0Value, arg1Value, this.receiverInteropLibrary, this);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.readI16AndSpecialize(arg0Value, arg1Value);
            }

            private short readI16AndSpecialize(LLVMGlobalContainer arg0Value, long arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    if (arg0Value.isPointer()) {
                        TruffleLanguage.LanguageReference lLVMLanguageReference__ = this.lLVMLanguageReference_;
                        if (lLVMLanguageReference__ == null) {
                            this.lLVMLanguageReference_ = lLVMLanguageReference__ = super.lookupLanguageReference(LLVMLanguage.class);
                        }
                        this.state_ = state |= 4;
                        lock.unlock();
                        hasLock = false;
                        short s = LLVMGlobalContainer.ReadI16.readNative(arg0Value, arg1Value, (LLVMLanguage)lLVMLanguageReference__.get());
                        return s;
                    }
                    if (!arg0Value.isPointer()) {
                        this.state_ = state |= 8;
                        lock.unlock();
                        hasLock = false;
                        short s = LLVMGlobalContainer.ReadI16.readManaged(arg0Value, arg1Value, this.receiverInteropLibrary, this);
                        return s;
                    }
                    throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public int readI32(Object arg0Value_, long arg1Value) {
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMGlobalContainer arg0Value = (LLVMGlobalContainer)arg0Value_;
                int state = this.state_;
                if ((state & 0x30) != 0) {
                    if ((state & 0x10) != 0 && arg0Value.isPointer()) {
                        return LLVMGlobalContainer.ReadI32.readNative(arg0Value, arg1Value, (LLVMLanguage)this.lLVMLanguageReference_.get());
                    }
                    if ((state & 0x20) != 0 && !arg0Value.isPointer()) {
                        return LLVMGlobalContainer.ReadI32.readManaged(arg0Value, arg1Value, this.receiverInteropLibrary, this);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.readI32AndSpecialize(arg0Value, arg1Value);
            }

            private int readI32AndSpecialize(LLVMGlobalContainer arg0Value, long arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    if (arg0Value.isPointer()) {
                        TruffleLanguage.LanguageReference lLVMLanguageReference__ = this.lLVMLanguageReference_;
                        if (lLVMLanguageReference__ == null) {
                            this.lLVMLanguageReference_ = lLVMLanguageReference__ = super.lookupLanguageReference(LLVMLanguage.class);
                        }
                        this.state_ = state |= 0x10;
                        lock.unlock();
                        hasLock = false;
                        int n = LLVMGlobalContainer.ReadI32.readNative(arg0Value, arg1Value, (LLVMLanguage)lLVMLanguageReference__.get());
                        return n;
                    }
                    if (!arg0Value.isPointer()) {
                        this.state_ = state |= 0x20;
                        lock.unlock();
                        hasLock = false;
                        int n = LLVMGlobalContainer.ReadI32.readManaged(arg0Value, arg1Value, this.receiverInteropLibrary, this);
                        return n;
                    }
                    throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public float readFloat(Object arg0Value_, long arg1Value) {
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMGlobalContainer arg0Value = (LLVMGlobalContainer)arg0Value_;
                int state = this.state_;
                if ((state & 0xC0) != 0) {
                    if ((state & 0x40) != 0 && arg0Value.isPointer()) {
                        return LLVMGlobalContainer.ReadFloat.readNative(arg0Value, arg1Value, (LLVMLanguage)this.lLVMLanguageReference_.get());
                    }
                    if ((state & 0x80) != 0 && !arg0Value.isPointer()) {
                        return LLVMGlobalContainer.ReadFloat.readManaged(arg0Value, arg1Value, this.receiverInteropLibrary, this);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.readFloatAndSpecialize(arg0Value, arg1Value);
            }

            private float readFloatAndSpecialize(LLVMGlobalContainer arg0Value, long arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    if (arg0Value.isPointer()) {
                        TruffleLanguage.LanguageReference lLVMLanguageReference__ = this.lLVMLanguageReference_;
                        if (lLVMLanguageReference__ == null) {
                            this.lLVMLanguageReference_ = lLVMLanguageReference__ = super.lookupLanguageReference(LLVMLanguage.class);
                        }
                        this.state_ = state |= 0x40;
                        lock.unlock();
                        hasLock = false;
                        float f = LLVMGlobalContainer.ReadFloat.readNative(arg0Value, arg1Value, (LLVMLanguage)lLVMLanguageReference__.get());
                        return f;
                    }
                    if (!arg0Value.isPointer()) {
                        this.state_ = state |= 0x80;
                        lock.unlock();
                        hasLock = false;
                        float f = LLVMGlobalContainer.ReadFloat.readManaged(arg0Value, arg1Value, this.receiverInteropLibrary, this);
                        return f;
                    }
                    throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public double readDouble(Object arg0Value_, long arg1Value) {
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMGlobalContainer arg0Value = (LLVMGlobalContainer)arg0Value_;
                int state = this.state_;
                if ((state & 0x300) != 0) {
                    if ((state & 0x100) != 0 && arg0Value.isPointer()) {
                        return LLVMGlobalContainer.ReadDouble.readNative(arg0Value, arg1Value, (LLVMLanguage)this.lLVMLanguageReference_.get());
                    }
                    if ((state & 0x200) != 0 && !arg0Value.isPointer()) {
                        return LLVMGlobalContainer.ReadDouble.readManaged(arg0Value, arg1Value, this.receiverInteropLibrary, this);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.readDoubleAndSpecialize(arg0Value, arg1Value);
            }

            private double readDoubleAndSpecialize(LLVMGlobalContainer arg0Value, long arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    if (arg0Value.isPointer()) {
                        TruffleLanguage.LanguageReference lLVMLanguageReference__ = this.lLVMLanguageReference_;
                        if (lLVMLanguageReference__ == null) {
                            this.lLVMLanguageReference_ = lLVMLanguageReference__ = super.lookupLanguageReference(LLVMLanguage.class);
                        }
                        this.state_ = state |= 0x100;
                        lock.unlock();
                        hasLock = false;
                        double d = LLVMGlobalContainer.ReadDouble.readNative(arg0Value, arg1Value, (LLVMLanguage)lLVMLanguageReference__.get());
                        return d;
                    }
                    if (!arg0Value.isPointer()) {
                        this.state_ = state |= 0x200;
                        lock.unlock();
                        hasLock = false;
                        double d = LLVMGlobalContainer.ReadDouble.readManaged(arg0Value, arg1Value, this.receiverInteropLibrary, this);
                        return d;
                    }
                    throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public Object readGenericI64(Object arg0Value_, long arg1Value) {
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMGlobalContainer arg0Value = (LLVMGlobalContainer)arg0Value_;
                int state = this.state_;
                if ((state & 0x1C00) != 0) {
                    if ((state & 0x400) != 0 && arg0Value.isPointer()) {
                        return LLVMGlobalContainer.ReadGenericI64.readNative(arg0Value, arg1Value, (LLVMLanguage)this.lLVMLanguageReference_.get());
                    }
                    if ((state & 0x800) != 0 && !arg0Value.isPointer() && arg1Value == 0L) {
                        return LLVMGlobalContainer.ReadGenericI64.readManaged(arg0Value, arg1Value);
                    }
                    if ((state & 0x1000) != 0 && !arg0Value.isPointer() && arg1Value != 0L) {
                        return LLVMGlobalContainer.ReadGenericI64.readFallback(arg0Value, arg1Value, this.receiverInteropLibrary, this);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.readGenericI64AndSpecialize(arg0Value, arg1Value);
            }

            private Object readGenericI64AndSpecialize(LLVMGlobalContainer arg0Value, long arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    if (arg0Value.isPointer()) {
                        TruffleLanguage.LanguageReference lLVMLanguageReference__ = this.lLVMLanguageReference_;
                        if (lLVMLanguageReference__ == null) {
                            this.lLVMLanguageReference_ = lLVMLanguageReference__ = super.lookupLanguageReference(LLVMLanguage.class);
                        }
                        this.state_ = state |= 0x400;
                        lock.unlock();
                        hasLock = false;
                        Long l = LLVMGlobalContainer.ReadGenericI64.readNative(arg0Value, arg1Value, (LLVMLanguage)lLVMLanguageReference__.get());
                        return l;
                    }
                    if (!arg0Value.isPointer() && arg1Value == 0L) {
                        this.state_ = state |= 0x800;
                        lock.unlock();
                        hasLock = false;
                        Object object = LLVMGlobalContainer.ReadGenericI64.readManaged(arg0Value, arg1Value);
                        return object;
                    }
                    if (!arg0Value.isPointer() && arg1Value != 0L) {
                        this.state_ = state |= 0x1000;
                        lock.unlock();
                        hasLock = false;
                        Object object = LLVMGlobalContainer.ReadGenericI64.readFallback(arg0Value, arg1Value, this.receiverInteropLibrary, this);
                        return object;
                    }
                    throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public LLVMPointer readPointer(Object arg0Value_, long arg1Value) {
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMGlobalContainer arg0Value = (LLVMGlobalContainer)arg0Value_;
                int state = this.state_;
                if ((state & 0xE000) != 0) {
                    if ((state & 0x2000) != 0 && arg0Value.isPointer()) {
                        return LLVMGlobalContainer.ReadPointer.readNative(arg0Value, arg1Value, (LLVMLanguage)this.lLVMLanguageReference_.get());
                    }
                    if ((state & 0x4000) != 0 && !arg0Value.isPointer() && arg1Value == 0L) {
                        return LLVMGlobalContainer.ReadPointer.readManaged(arg0Value, arg1Value, this.readPointer_readManaged_toPointer_);
                    }
                    if ((state & 0x8000) != 0 && !arg0Value.isPointer() && arg1Value != 0L) {
                        return LLVMGlobalContainer.ReadPointer.readFallback(arg0Value, arg1Value, this.receiverInteropLibrary, this);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.readPointerAndSpecialize(arg0Value, arg1Value);
            }

            private LLVMPointer readPointerAndSpecialize(LLVMGlobalContainer arg0Value, long arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    if (arg0Value.isPointer()) {
                        TruffleLanguage.LanguageReference lLVMLanguageReference__ = this.lLVMLanguageReference_;
                        if (lLVMLanguageReference__ == null) {
                            this.lLVMLanguageReference_ = lLVMLanguageReference__ = super.lookupLanguageReference(LLVMLanguage.class);
                        }
                        this.state_ = state |= 0x2000;
                        lock.unlock();
                        hasLock = false;
                        LLVMPointer lLVMPointer = LLVMGlobalContainer.ReadPointer.readNative(arg0Value, arg1Value, (LLVMLanguage)lLVMLanguageReference__.get());
                        return lLVMPointer;
                    }
                    if (!arg0Value.isPointer() && arg1Value == 0L) {
                        this.readPointer_readManaged_toPointer_ = (LLVMToPointerNode)super.insert((Node)LLVMToPointerNodeGen.create());
                        this.state_ = state |= 0x4000;
                        lock.unlock();
                        hasLock = false;
                        LLVMPointer lLVMPointer = LLVMGlobalContainer.ReadPointer.readManaged(arg0Value, arg1Value, this.readPointer_readManaged_toPointer_);
                        return lLVMPointer;
                    }
                    if (!arg0Value.isPointer() && arg1Value != 0L) {
                        this.state_ = state |= 0x8000;
                        lock.unlock();
                        hasLock = false;
                        LLVMPointer lLVMPointer = LLVMGlobalContainer.ReadPointer.readFallback(arg0Value, arg1Value, this.receiverInteropLibrary, this);
                        return lLVMPointer;
                    }
                    throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean isReadable(Object receiver) {
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMGlobalContainer)receiver).isAccessible();
            }
        }
    }

    @GeneratedBy(value=LLVMGlobalContainer.class)
    private static final class InteropLibraryExports
    extends LibraryExport<InteropLibrary> {
        private InteropLibraryExports() {
            super(InteropLibrary.class, LLVMGlobalContainer.class, false);
        }

        protected InteropLibrary createUncached(Object receiver) {
            assert (receiver instanceof LLVMGlobalContainer);
            return new Uncached();
        }

        protected InteropLibrary createCached(Object receiver) {
            assert (receiver instanceof LLVMGlobalContainer);
            return new Cached();
        }

        @GeneratedBy(value=LLVMGlobalContainer.class)
        private static final class Uncached
        extends InteropLibrary {
            Uncached() {
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof LLVMGlobalContainer) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export 'com.oracle.truffle.llvm.runtime.global.LLVMGlobalContainer'. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof LLVMGlobalContainer;
            }

            public boolean isAdoptable() {
                return false;
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isPointer(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMGlobalContainer)receiver).isPointer();
            }

            @CompilerDirectives.TruffleBoundary
            public long asPointer(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMGlobalContainer)receiver).asPointer();
            }

            @CompilerDirectives.TruffleBoundary
            public void toNative(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMGlobalContainer arg0Value = (LLVMGlobalContainer)arg0Value_;
                arg0Value.toNative(LLVMToNativeNodeGen.getUncached());
            }
        }

        @GeneratedBy(value=LLVMGlobalContainer.class)
        private static final class Cached
        extends InteropLibrary {
            @CompilerDirectives.CompilationFinal
            private int state_;
            @Node.Child
            private LLVMToNativeNode toNative_;

            Cached() {
            }

            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof LLVMGlobalContainer) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export 'com.oracle.truffle.llvm.runtime.global.LLVMGlobalContainer'. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof LLVMGlobalContainer;
            }

            public boolean isPointer(Object receiver) {
                assert (this.assertAdopted());
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMGlobalContainer)receiver).isPointer();
            }

            public long asPointer(Object receiver) throws UnsupportedMessageException {
                assert (this.assertAdopted());
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMGlobalContainer)receiver).asPointer();
            }

            public void toNative(Object arg0Value_) {
                assert (this.assertAdopted());
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMGlobalContainer arg0Value = (LLVMGlobalContainer)arg0Value_;
                int state = this.state_;
                if (state != 0) {
                    arg0Value.toNative(this.toNative_);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.executeAndSpecialize(arg0Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void executeAndSpecialize(LLVMGlobalContainer arg0Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    this.toNative_ = (LLVMToNativeNode)super.insert((Node)LLVMToNativeNodeGen.create());
                    this.state_ = state |= 1;
                    lock.unlock();
                    hasLock = false;
                    arg0Value.toNative(this.toNative_);
                    return;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public NodeCost getCost() {
                int state = this.state_;
                if (state == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                return NodeCost.MONOMORPHIC;
            }
        }
    }
}

