/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.interop;

import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.llvm.runtime.except.LLVMPolyglotException;
import com.oracle.truffle.llvm.runtime.interop.LLVMAsForeignNodeGen;
import com.oracle.truffle.llvm.runtime.interop.LLVMTypedForeignObject;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;

@NodeChild(type=LLVMExpressionNode.class)
public abstract class LLVMAsForeignNode
extends LLVMNode {
    final boolean allowNonForeign;

    protected LLVMAsForeignNode(boolean allowNonForeign) {
        this.allowNonForeign = allowNonForeign;
    }

    public abstract Object execute(VirtualFrame var1);

    public abstract Object execute(LLVMManagedPointer var1);

    public static LLVMAsForeignNode create() {
        return LLVMAsForeignNodeGen.create(false, null);
    }

    public static LLVMAsForeignNode create(LLVMExpressionNode arg) {
        return LLVMAsForeignNodeGen.create(false, arg);
    }

    public static LLVMAsForeignNode createOptional() {
        return LLVMAsForeignNodeGen.create(true, null);
    }

    @Specialization(guards={"isForeign(pointer)"})
    Object doForeign(LLVMManagedPointer pointer) {
        Object foreign = pointer.getObject();
        if (foreign instanceof LLVMTypedForeignObject) {
            return ((LLVMTypedForeignObject)foreign).getForeign();
        }
        return foreign;
    }

    @Fallback
    Object doOther(Object pointer) {
        if (this.allowNonForeign) {
            return null;
        }
        throw new LLVMPolyglotException(this, "Pointer does not point to a polyglot value.");
    }

    protected static boolean isForeign(LLVMManagedPointer pointer) {
        return pointer.getOffset() == 0L && (pointer.getObject() instanceof LLVMTypedForeignObject || LLVMExpressionNode.notLLVM(pointer.getObject()));
    }
}

