/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.llvm.runtime.interop.LLVMDataEscapeNode;
import com.oracle.truffle.llvm.runtime.interop.LLVMTypedForeignObject;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMNativeLibrary;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=LLVMDataEscapeNode.class)
public final class LLVMDataEscapeNodeFactory {
    private static final LibraryFactory<LLVMNativeLibrary> L_L_V_M_NATIVE_LIBRARY_ = LibraryFactory.resolve(LLVMNativeLibrary.class);

    @GeneratedBy(value=LLVMDataEscapeNode.LLVMVoidDataEscapeNode.class)
    public static final class LLVMVoidDataEscapeNodeGen
    extends LLVMDataEscapeNode.LLVMVoidDataEscapeNode {
        private static final Uncached UNCACHED = new Uncached();

        private LLVMVoidDataEscapeNodeGen() {
        }

        @Override
        public Object executeWithType(Object arg0Value, LLVMInteropType.Structured arg1Value) {
            return this.doVoid(arg0Value, arg1Value);
        }

        public NodeCost getCost() {
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMDataEscapeNode.LLVMVoidDataEscapeNode create() {
            return new LLVMVoidDataEscapeNodeGen();
        }

        public static LLVMDataEscapeNode.LLVMVoidDataEscapeNode getUncached() {
            return UNCACHED;
        }

        @GeneratedBy(value=LLVMDataEscapeNode.LLVMVoidDataEscapeNode.class)
        private static final class Uncached
        extends LLVMDataEscapeNode.LLVMVoidDataEscapeNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object executeWithType(Object arg0Value, LLVMInteropType.Structured arg1Value) {
                return this.doVoid(arg0Value, arg1Value);
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            public boolean isAdoptable() {
                return false;
            }
        }
    }

    @GeneratedBy(value=LLVMDataEscapeNode.LLVMPointerDataEscapeNode.class)
    public static final class LLVMPointerDataEscapeNodeGen
    extends LLVMDataEscapeNode.LLVMPointerDataEscapeNode {
        private static final Uncached UNCACHED = new Uncached();
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMPointerDataEscapeNodeGen() {
        }

        @Override
        public Object executeWithType(Object arg0Value, LLVMInteropType.Structured arg1Value) {
            int state = this.state_;
            if (state != 0) {
                LLVMPointer arg0Value_;
                if ((state & 1) != 0 && arg0Value instanceof String) {
                    String arg0Value_2 = (String)arg0Value;
                    return LLVMDataEscapeNode.LLVMPointerDataEscapeNode.escapingString(arg0Value_2, arg1Value);
                }
                if ((state & 2) != 0 && arg0Value instanceof LLVMInteropType) {
                    LLVMInteropType arg0Value_3 = (LLVMInteropType)arg0Value;
                    return LLVMDataEscapeNode.LLVMPointerDataEscapeNode.escapingType(arg0Value_3, arg1Value);
                }
                if ((state & 4) != 0 && arg0Value instanceof LLVMTypedForeignObject) {
                    LLVMTypedForeignObject arg0Value_4 = (LLVMTypedForeignObject)arg0Value;
                    return LLVMDataEscapeNode.LLVMPointerDataEscapeNode.escapingForeign(arg0Value_4, arg1Value);
                }
                if ((state & 8) != 0 && LLVMTypes.isManagedPointer(arg0Value) && LLVMDataEscapeNode.LLVMPointerDataEscapeNode.isForeign(arg0Value_ = LLVMTypes.asManagedPointer(arg0Value))) {
                    return LLVMDataEscapeNode.LLVMPointerDataEscapeNode.escapingManaged(arg0Value_, arg1Value);
                }
                if ((state & 0x30) != 0 && LLVMTypes.isPointer(arg0Value)) {
                    arg0Value_ = LLVMTypes.asPointer(arg0Value);
                    if ((state & 0x10) != 0 && !LLVMDataEscapeNode.LLVMPointerDataEscapeNode.isForeign(arg0Value_) && arg1Value != null) {
                        return LLVMDataEscapeNode.LLVMPointerDataEscapeNode.escapingPointerOverrideType(arg0Value_, arg1Value);
                    }
                    if ((state & 0x20) != 0 && !LLVMDataEscapeNode.LLVMPointerDataEscapeNode.isForeign(arg0Value_) && arg1Value == null) {
                        return LLVMDataEscapeNode.LLVMPointerDataEscapeNode.escapingPointer(arg0Value_, arg1Value);
                    }
                }
                if ((state & 0x40) != 0 && arg0Value instanceof Long) {
                    long arg0Value_5 = (Long)arg0Value;
                    return LLVMDataEscapeNode.LLVMPointerDataEscapeNode.escapingPrimitive(arg0Value_5, arg1Value);
                }
                if ((state & 0x80) != 0 && arg0Value instanceof Double) {
                    double arg0Value_6 = (Double)arg0Value;
                    return LLVMDataEscapeNode.LLVMPointerDataEscapeNode.escapingPrimitive(arg0Value_6, arg1Value);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value, arg1Value);
        }

        private Object executeAndSpecialize(Object arg0Value, LLVMInteropType.Structured arg1Value) {
            LLVMPointer arg0Value_;
            int state = this.state_;
            if (arg0Value instanceof String) {
                String arg0Value_2 = (String)arg0Value;
                this.state_ = state |= 1;
                return LLVMDataEscapeNode.LLVMPointerDataEscapeNode.escapingString(arg0Value_2, arg1Value);
            }
            if (arg0Value instanceof LLVMInteropType) {
                LLVMInteropType arg0Value_3 = (LLVMInteropType)arg0Value;
                this.state_ = state |= 2;
                return LLVMDataEscapeNode.LLVMPointerDataEscapeNode.escapingType(arg0Value_3, arg1Value);
            }
            if (arg0Value instanceof LLVMTypedForeignObject) {
                LLVMTypedForeignObject arg0Value_4 = (LLVMTypedForeignObject)arg0Value;
                this.state_ = state |= 4;
                return LLVMDataEscapeNode.LLVMPointerDataEscapeNode.escapingForeign(arg0Value_4, arg1Value);
            }
            if (LLVMTypes.isManagedPointer(arg0Value) && LLVMDataEscapeNode.LLVMPointerDataEscapeNode.isForeign(arg0Value_ = LLVMTypes.asManagedPointer(arg0Value))) {
                this.state_ = state |= 8;
                return LLVMDataEscapeNode.LLVMPointerDataEscapeNode.escapingManaged(arg0Value_, arg1Value);
            }
            if (LLVMTypes.isPointer(arg0Value)) {
                arg0Value_ = LLVMTypes.asPointer(arg0Value);
                if (!LLVMDataEscapeNode.LLVMPointerDataEscapeNode.isForeign(arg0Value_) && arg1Value != null) {
                    this.state_ = state |= 0x10;
                    return LLVMDataEscapeNode.LLVMPointerDataEscapeNode.escapingPointerOverrideType(arg0Value_, arg1Value);
                }
                if (!LLVMDataEscapeNode.LLVMPointerDataEscapeNode.isForeign(arg0Value_) && arg1Value == null) {
                    this.state_ = state |= 0x20;
                    return LLVMDataEscapeNode.LLVMPointerDataEscapeNode.escapingPointer(arg0Value_, arg1Value);
                }
            }
            if (arg0Value instanceof Long) {
                long arg0Value_5 = (Long)arg0Value;
                this.state_ = state |= 0x40;
                return LLVMDataEscapeNode.LLVMPointerDataEscapeNode.escapingPrimitive(arg0Value_5, arg1Value);
            }
            if (arg0Value instanceof Double) {
                double arg0Value_6 = (Double)arg0Value;
                this.state_ = state |= 0x80;
                return LLVMDataEscapeNode.LLVMPointerDataEscapeNode.escapingPrimitive(arg0Value_6, arg1Value);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMDataEscapeNode.LLVMPointerDataEscapeNode create() {
            return new LLVMPointerDataEscapeNodeGen();
        }

        public static LLVMDataEscapeNode.LLVMPointerDataEscapeNode getUncached() {
            return UNCACHED;
        }

        @GeneratedBy(value=LLVMDataEscapeNode.LLVMPointerDataEscapeNode.class)
        private static final class Uncached
        extends LLVMDataEscapeNode.LLVMPointerDataEscapeNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object executeWithType(Object arg0Value, LLVMInteropType.Structured arg1Value) {
                LLVMPointer arg0Value_;
                if (arg0Value instanceof String) {
                    String arg0Value_2 = (String)arg0Value;
                    return LLVMDataEscapeNode.LLVMPointerDataEscapeNode.escapingString(arg0Value_2, arg1Value);
                }
                if (arg0Value instanceof LLVMInteropType) {
                    LLVMInteropType arg0Value_3 = (LLVMInteropType)arg0Value;
                    return LLVMDataEscapeNode.LLVMPointerDataEscapeNode.escapingType(arg0Value_3, arg1Value);
                }
                if (arg0Value instanceof LLVMTypedForeignObject) {
                    LLVMTypedForeignObject arg0Value_4 = (LLVMTypedForeignObject)arg0Value;
                    return LLVMDataEscapeNode.LLVMPointerDataEscapeNode.escapingForeign(arg0Value_4, arg1Value);
                }
                if (LLVMTypes.isManagedPointer(arg0Value) && LLVMDataEscapeNode.LLVMPointerDataEscapeNode.isForeign(arg0Value_ = LLVMTypes.asManagedPointer(arg0Value))) {
                    return LLVMDataEscapeNode.LLVMPointerDataEscapeNode.escapingManaged(arg0Value_, arg1Value);
                }
                if (LLVMTypes.isPointer(arg0Value)) {
                    arg0Value_ = LLVMTypes.asPointer(arg0Value);
                    if (!LLVMDataEscapeNode.LLVMPointerDataEscapeNode.isForeign(arg0Value_) && arg1Value != null) {
                        return LLVMDataEscapeNode.LLVMPointerDataEscapeNode.escapingPointerOverrideType(arg0Value_, arg1Value);
                    }
                    if (!LLVMDataEscapeNode.LLVMPointerDataEscapeNode.isForeign(arg0Value_) && arg1Value == null) {
                        return LLVMDataEscapeNode.LLVMPointerDataEscapeNode.escapingPointer(arg0Value_, arg1Value);
                    }
                }
                if (arg0Value instanceof Long) {
                    long arg0Value_5 = (Long)arg0Value;
                    return LLVMDataEscapeNode.LLVMPointerDataEscapeNode.escapingPrimitive(arg0Value_5, arg1Value);
                }
                if (arg0Value instanceof Double) {
                    double arg0Value_6 = (Double)arg0Value;
                    return LLVMDataEscapeNode.LLVMPointerDataEscapeNode.escapingPrimitive(arg0Value_6, arg1Value);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            public boolean isAdoptable() {
                return false;
            }
        }
    }

    @GeneratedBy(value=LLVMDataEscapeNode.LLVMDoubleDataEscapeNode.class)
    public static final class LLVMDoubleDataEscapeNodeGen
    extends LLVMDataEscapeNode.LLVMDoubleDataEscapeNode {
        private static final Uncached UNCACHED = new Uncached();
        @CompilerDirectives.CompilationFinal
        private int state_;
        @CompilerDirectives.CompilationFinal
        private int exclude_;
        @Node.Child
        private EscapingPointer0Data escapingPointer0_cache;

        private LLVMDoubleDataEscapeNodeGen() {
        }

        @Override
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        public Object executeWithType(Object arg0Value, LLVMInteropType.Structured arg1Value) {
            int state = this.state_;
            if (state != 0) {
                if ((state & 1) != 0 && arg0Value instanceof Double) {
                    double arg0Value_ = (Double)arg0Value;
                    return LLVMDataEscapeNode.LLVMDoubleDataEscapeNode.escapingPrimitive(arg0Value_, arg1Value);
                }
                if ((state & 2) != 0 && arg0Value instanceof Long) {
                    long arg0Value_ = (Long)arg0Value;
                    return LLVMDataEscapeNode.LLVMDoubleDataEscapeNode.escapingLong(arg0Value_, arg1Value);
                }
                if ((state & 0xC) != 0) {
                    if ((state & 4) != 0) {
                        EscapingPointer0Data s3_ = this.escapingPointer0_cache;
                        while (s3_ != null) {
                            if (s3_.library_.accepts(arg0Value)) {
                                return LLVMDataEscapeNode.LLVMDoubleDataEscapeNode.escapingPointer(arg0Value, arg1Value, s3_.library_);
                            }
                            s3_ = s3_.next_;
                        }
                    }
                    if ((state & 8) != 0) {
                        return this.escapingPointer1Boundary(state, arg0Value, arg1Value);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value, arg1Value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private Object escapingPointer1Boundary(int state, Object arg0Value, LLVMInteropType.Structured arg1Value) {
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
            try {
                Double d = LLVMDataEscapeNode.LLVMDoubleDataEscapeNode.escapingPointer(arg0Value, arg1Value, (LLVMNativeLibrary)L_L_V_M_NATIVE_LIBRARY_.getUncached(arg0Value));
                return d;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private double executeAndSpecialize(Object arg0Value, LLVMInteropType.Structured arg1Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            int exclude = this.exclude_;
            try {
                double d;
                if (arg0Value instanceof Double) {
                    double arg0Value_ = (Double)arg0Value;
                    this.state_ = state |= 1;
                    lock.unlock();
                    hasLock = false;
                    double d2 = LLVMDataEscapeNode.LLVMDoubleDataEscapeNode.escapingPrimitive(arg0Value_, arg1Value);
                    return d2;
                }
                if ((exclude & 1) == 0 && arg0Value instanceof Long) {
                    long arg0Value_ = (Long)arg0Value;
                    this.state_ = state |= 2;
                    lock.unlock();
                    hasLock = false;
                    double d3 = LLVMDataEscapeNode.LLVMDoubleDataEscapeNode.escapingLong(arg0Value_, arg1Value);
                    return d3;
                }
                if ((exclude & 2) == 0) {
                    int count3_ = 0;
                    EscapingPointer0Data s3_ = this.escapingPointer0_cache;
                    if ((state & 4) != 0) {
                        while (s3_ != null && !s3_.library_.accepts(arg0Value)) {
                            s3_ = s3_.next_;
                            ++count3_;
                        }
                    }
                    if (s3_ == null && count3_ < 3) {
                        s3_ = (EscapingPointer0Data)super.insert((Node)new EscapingPointer0Data(this.escapingPointer0_cache));
                        s3_.library_ = s3_.insertAccessor((LLVMNativeLibrary)L_L_V_M_NATIVE_LIBRARY_.create(arg0Value));
                        this.escapingPointer0_cache = s3_;
                        this.exclude_ = exclude |= 1;
                        state &= 0xFFFFFFFD;
                        this.state_ = state |= 4;
                    }
                    if (s3_ != null) {
                        lock.unlock();
                        hasLock = false;
                        double d4 = LLVMDataEscapeNode.LLVMDoubleDataEscapeNode.escapingPointer(arg0Value, arg1Value, s3_.library_);
                        return d4;
                    }
                }
                Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
                try {
                    this.exclude_ = exclude |= 3;
                    this.escapingPointer0_cache = null;
                    state &= 0xFFFFFFF9;
                    this.state_ = state |= 8;
                    lock.unlock();
                    hasLock = false;
                    d = LLVMDataEscapeNode.LLVMDoubleDataEscapeNode.escapingPointer(arg0Value, arg1Value, (LLVMNativeLibrary)L_L_V_M_NATIVE_LIBRARY_.getUncached(arg0Value));
                }
                catch (Throwable throwable) {
                    NodeUtil.popEncapsulatingNode((Node)prev_);
                    throw throwable;
                }
                NodeUtil.popEncapsulatingNode((Node)prev_);
                return d;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            EscapingPointer0Data s3_;
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0 && ((s3_ = this.escapingPointer0_cache) == null || s3_.next_ == null)) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMDataEscapeNode.LLVMDoubleDataEscapeNode create() {
            return new LLVMDoubleDataEscapeNodeGen();
        }

        public static LLVMDataEscapeNode.LLVMDoubleDataEscapeNode getUncached() {
            return UNCACHED;
        }

        @GeneratedBy(value=LLVMDataEscapeNode.LLVMDoubleDataEscapeNode.class)
        private static final class Uncached
        extends LLVMDataEscapeNode.LLVMDoubleDataEscapeNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object executeWithType(Object arg0Value, LLVMInteropType.Structured arg1Value) {
                if (arg0Value instanceof Double) {
                    double arg0Value_ = (Double)arg0Value;
                    return LLVMDataEscapeNode.LLVMDoubleDataEscapeNode.escapingPrimitive(arg0Value_, arg1Value);
                }
                return LLVMDataEscapeNode.LLVMDoubleDataEscapeNode.escapingPointer(arg0Value, arg1Value, (LLVMNativeLibrary)L_L_V_M_NATIVE_LIBRARY_.getUncached(arg0Value));
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            public boolean isAdoptable() {
                return false;
            }
        }

        @GeneratedBy(value=LLVMDataEscapeNode.LLVMDoubleDataEscapeNode.class)
        private static final class EscapingPointer0Data
        extends Node {
            @Node.Child
            EscapingPointer0Data next_;
            @Node.Child
            LLVMNativeLibrary library_;

            EscapingPointer0Data(EscapingPointer0Data next_) {
                this.next_ = next_;
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }
    }

    @GeneratedBy(value=LLVMDataEscapeNode.LLVMFloatDataEscapeNode.class)
    public static final class LLVMFloatDataEscapeNodeGen
    extends LLVMDataEscapeNode.LLVMFloatDataEscapeNode {
        private static final Uncached UNCACHED = new Uncached();
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMFloatDataEscapeNodeGen() {
        }

        @Override
        public Object executeWithType(Object arg0Value, LLVMInteropType.Structured arg1Value) {
            int state = this.state_;
            if (state != 0) {
                if ((state & 1) != 0 && arg0Value instanceof Float) {
                    float arg0Value_ = ((Float)arg0Value).floatValue();
                    return Float.valueOf(LLVMDataEscapeNode.LLVMFloatDataEscapeNode.escapingPrimitive(arg0Value_, arg1Value));
                }
                if ((state & 2) != 0 && arg0Value instanceof Integer) {
                    int arg0Value_ = (Integer)arg0Value;
                    return Float.valueOf(LLVMDataEscapeNode.LLVMFloatDataEscapeNode.escapingPrimitive(arg0Value_, arg1Value));
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return Float.valueOf(this.executeAndSpecialize(arg0Value, arg1Value));
        }

        private float executeAndSpecialize(Object arg0Value, LLVMInteropType.Structured arg1Value) {
            int state = this.state_;
            if (arg0Value instanceof Float) {
                float arg0Value_ = ((Float)arg0Value).floatValue();
                this.state_ = state |= 1;
                return LLVMDataEscapeNode.LLVMFloatDataEscapeNode.escapingPrimitive(arg0Value_, arg1Value);
            }
            if (arg0Value instanceof Integer) {
                int arg0Value_ = (Integer)arg0Value;
                this.state_ = state |= 2;
                return LLVMDataEscapeNode.LLVMFloatDataEscapeNode.escapingPrimitive(arg0Value_, arg1Value);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMDataEscapeNode.LLVMFloatDataEscapeNode create() {
            return new LLVMFloatDataEscapeNodeGen();
        }

        public static LLVMDataEscapeNode.LLVMFloatDataEscapeNode getUncached() {
            return UNCACHED;
        }

        @GeneratedBy(value=LLVMDataEscapeNode.LLVMFloatDataEscapeNode.class)
        private static final class Uncached
        extends LLVMDataEscapeNode.LLVMFloatDataEscapeNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object executeWithType(Object arg0Value, LLVMInteropType.Structured arg1Value) {
                if (arg0Value instanceof Float) {
                    float arg0Value_ = ((Float)arg0Value).floatValue();
                    return Float.valueOf(LLVMDataEscapeNode.LLVMFloatDataEscapeNode.escapingPrimitive(arg0Value_, arg1Value));
                }
                if (arg0Value instanceof Integer) {
                    int arg0Value_ = (Integer)arg0Value;
                    return Float.valueOf(LLVMDataEscapeNode.LLVMFloatDataEscapeNode.escapingPrimitive(arg0Value_, arg1Value));
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            public boolean isAdoptable() {
                return false;
            }
        }
    }

    @GeneratedBy(value=LLVMDataEscapeNode.LLVMI64DataEscapeNode.class)
    public static final class LLVMI64DataEscapeNodeGen
    extends LLVMDataEscapeNode.LLVMI64DataEscapeNode {
        private static final Uncached UNCACHED = new Uncached();
        @CompilerDirectives.CompilationFinal
        private int state_;
        @CompilerDirectives.CompilationFinal
        private int exclude_;
        @Node.Child
        private EscapingPointer0Data escapingPointer0_cache;

        private LLVMI64DataEscapeNodeGen() {
        }

        @Override
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        public Object executeWithType(Object arg0Value, LLVMInteropType.Structured arg1Value) {
            int state = this.state_;
            if (state != 0) {
                if ((state & 1) != 0 && arg0Value instanceof Long) {
                    long arg0Value_ = (Long)arg0Value;
                    return LLVMDataEscapeNode.LLVMI64DataEscapeNode.escapingPrimitive(arg0Value_, arg1Value);
                }
                if ((state & 2) != 0 && arg0Value instanceof Double) {
                    double arg0Value_ = (Double)arg0Value;
                    return LLVMDataEscapeNode.LLVMI64DataEscapeNode.escapingPrimitive(arg0Value_, arg1Value);
                }
                if ((state & 0xC) != 0) {
                    if ((state & 4) != 0) {
                        EscapingPointer0Data s3_ = this.escapingPointer0_cache;
                        while (s3_ != null) {
                            if (s3_.library_.accepts(arg0Value)) {
                                return LLVMDataEscapeNode.LLVMI64DataEscapeNode.escapingPointer(arg0Value, arg1Value, s3_.library_);
                            }
                            s3_ = s3_.next_;
                        }
                    }
                    if ((state & 8) != 0) {
                        return this.escapingPointer1Boundary(state, arg0Value, arg1Value);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value, arg1Value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private Object escapingPointer1Boundary(int state, Object arg0Value, LLVMInteropType.Structured arg1Value) {
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
            try {
                Long l = LLVMDataEscapeNode.LLVMI64DataEscapeNode.escapingPointer(arg0Value, arg1Value, (LLVMNativeLibrary)L_L_V_M_NATIVE_LIBRARY_.getUncached(arg0Value));
                return l;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private long executeAndSpecialize(Object arg0Value, LLVMInteropType.Structured arg1Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            int exclude = this.exclude_;
            try {
                long l;
                if ((exclude & 1) == 0 && arg0Value instanceof Long) {
                    long arg0Value_ = (Long)arg0Value;
                    this.state_ = state |= 1;
                    lock.unlock();
                    hasLock = false;
                    long l2 = LLVMDataEscapeNode.LLVMI64DataEscapeNode.escapingPrimitive(arg0Value_, arg1Value);
                    return l2;
                }
                if ((exclude & 2) == 0 && arg0Value instanceof Double) {
                    double arg0Value_ = (Double)arg0Value;
                    this.state_ = state |= 2;
                    lock.unlock();
                    hasLock = false;
                    long l3 = LLVMDataEscapeNode.LLVMI64DataEscapeNode.escapingPrimitive(arg0Value_, arg1Value);
                    return l3;
                }
                if ((exclude & 4) == 0) {
                    int count3_ = 0;
                    EscapingPointer0Data s3_ = this.escapingPointer0_cache;
                    if ((state & 4) != 0) {
                        while (s3_ != null && !s3_.library_.accepts(arg0Value)) {
                            s3_ = s3_.next_;
                            ++count3_;
                        }
                    }
                    if (s3_ == null && count3_ < 3) {
                        s3_ = (EscapingPointer0Data)super.insert((Node)new EscapingPointer0Data(this.escapingPointer0_cache));
                        s3_.library_ = s3_.insertAccessor((LLVMNativeLibrary)L_L_V_M_NATIVE_LIBRARY_.create(arg0Value));
                        this.escapingPointer0_cache = s3_;
                        this.exclude_ = exclude |= 3;
                        state &= 0xFFFFFFFC;
                        this.state_ = state |= 4;
                    }
                    if (s3_ != null) {
                        lock.unlock();
                        hasLock = false;
                        long l4 = LLVMDataEscapeNode.LLVMI64DataEscapeNode.escapingPointer(arg0Value, arg1Value, s3_.library_);
                        return l4;
                    }
                }
                Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
                try {
                    this.exclude_ = exclude |= 7;
                    this.escapingPointer0_cache = null;
                    state &= 0xFFFFFFF8;
                    this.state_ = state |= 8;
                    lock.unlock();
                    hasLock = false;
                    l = LLVMDataEscapeNode.LLVMI64DataEscapeNode.escapingPointer(arg0Value, arg1Value, (LLVMNativeLibrary)L_L_V_M_NATIVE_LIBRARY_.getUncached(arg0Value));
                }
                catch (Throwable throwable) {
                    NodeUtil.popEncapsulatingNode((Node)prev_);
                    throw throwable;
                }
                NodeUtil.popEncapsulatingNode((Node)prev_);
                return l;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            EscapingPointer0Data s3_;
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0 && ((s3_ = this.escapingPointer0_cache) == null || s3_.next_ == null)) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMDataEscapeNode.LLVMI64DataEscapeNode create() {
            return new LLVMI64DataEscapeNodeGen();
        }

        public static LLVMDataEscapeNode.LLVMI64DataEscapeNode getUncached() {
            return UNCACHED;
        }

        @GeneratedBy(value=LLVMDataEscapeNode.LLVMI64DataEscapeNode.class)
        private static final class Uncached
        extends LLVMDataEscapeNode.LLVMI64DataEscapeNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object executeWithType(Object arg0Value, LLVMInteropType.Structured arg1Value) {
                return LLVMDataEscapeNode.LLVMI64DataEscapeNode.escapingPointer(arg0Value, arg1Value, (LLVMNativeLibrary)L_L_V_M_NATIVE_LIBRARY_.getUncached(arg0Value));
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            public boolean isAdoptable() {
                return false;
            }
        }

        @GeneratedBy(value=LLVMDataEscapeNode.LLVMI64DataEscapeNode.class)
        private static final class EscapingPointer0Data
        extends Node {
            @Node.Child
            EscapingPointer0Data next_;
            @Node.Child
            LLVMNativeLibrary library_;

            EscapingPointer0Data(EscapingPointer0Data next_) {
                this.next_ = next_;
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }
    }

    @GeneratedBy(value=LLVMDataEscapeNode.LLVMI32DataEscapeNode.class)
    public static final class LLVMI32DataEscapeNodeGen
    extends LLVMDataEscapeNode.LLVMI32DataEscapeNode {
        private static final Uncached UNCACHED = new Uncached();
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMI32DataEscapeNodeGen() {
        }

        @Override
        public Object executeWithType(Object arg0Value, LLVMInteropType.Structured arg1Value) {
            int state = this.state_;
            if (state != 0) {
                if ((state & 1) != 0 && arg0Value instanceof Integer) {
                    int arg0Value_ = (Integer)arg0Value;
                    return LLVMDataEscapeNode.LLVMI32DataEscapeNode.escapingPrimitive(arg0Value_, arg1Value);
                }
                if ((state & 2) != 0 && arg0Value instanceof Float) {
                    float arg0Value_ = ((Float)arg0Value).floatValue();
                    return LLVMDataEscapeNode.LLVMI32DataEscapeNode.escapingPrimitive(arg0Value_, arg1Value);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value, arg1Value);
        }

        private int executeAndSpecialize(Object arg0Value, LLVMInteropType.Structured arg1Value) {
            int state = this.state_;
            if (arg0Value instanceof Integer) {
                int arg0Value_ = (Integer)arg0Value;
                this.state_ = state |= 1;
                return LLVMDataEscapeNode.LLVMI32DataEscapeNode.escapingPrimitive(arg0Value_, arg1Value);
            }
            if (arg0Value instanceof Float) {
                float arg0Value_ = ((Float)arg0Value).floatValue();
                this.state_ = state |= 2;
                return LLVMDataEscapeNode.LLVMI32DataEscapeNode.escapingPrimitive(arg0Value_, arg1Value);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMDataEscapeNode.LLVMI32DataEscapeNode create() {
            return new LLVMI32DataEscapeNodeGen();
        }

        public static LLVMDataEscapeNode.LLVMI32DataEscapeNode getUncached() {
            return UNCACHED;
        }

        @GeneratedBy(value=LLVMDataEscapeNode.LLVMI32DataEscapeNode.class)
        private static final class Uncached
        extends LLVMDataEscapeNode.LLVMI32DataEscapeNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object executeWithType(Object arg0Value, LLVMInteropType.Structured arg1Value) {
                if (arg0Value instanceof Integer) {
                    int arg0Value_ = (Integer)arg0Value;
                    return LLVMDataEscapeNode.LLVMI32DataEscapeNode.escapingPrimitive(arg0Value_, arg1Value);
                }
                if (arg0Value instanceof Float) {
                    float arg0Value_ = ((Float)arg0Value).floatValue();
                    return LLVMDataEscapeNode.LLVMI32DataEscapeNode.escapingPrimitive(arg0Value_, arg1Value);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            public boolean isAdoptable() {
                return false;
            }
        }
    }

    @GeneratedBy(value=LLVMDataEscapeNode.LLVMI16DataEscapeNode.class)
    public static final class LLVMI16DataEscapeNodeGen
    extends LLVMDataEscapeNode.LLVMI16DataEscapeNode {
        private static final Uncached UNCACHED = new Uncached();
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMI16DataEscapeNodeGen() {
        }

        @Override
        public Object executeWithType(Object arg0Value, LLVMInteropType.Structured arg1Value) {
            int state = this.state_;
            if (state != 0 && arg0Value instanceof Short) {
                short arg0Value_ = (Short)arg0Value;
                return LLVMDataEscapeNode.LLVMI16DataEscapeNode.escapingPrimitive(arg0Value_, arg1Value);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value, arg1Value);
        }

        private short executeAndSpecialize(Object arg0Value, LLVMInteropType.Structured arg1Value) {
            int state = this.state_;
            if (arg0Value instanceof Short) {
                short arg0Value_ = (Short)arg0Value;
                this.state_ = state |= 1;
                return LLVMDataEscapeNode.LLVMI16DataEscapeNode.escapingPrimitive(arg0Value_, arg1Value);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMDataEscapeNode.LLVMI16DataEscapeNode create() {
            return new LLVMI16DataEscapeNodeGen();
        }

        public static LLVMDataEscapeNode.LLVMI16DataEscapeNode getUncached() {
            return UNCACHED;
        }

        @GeneratedBy(value=LLVMDataEscapeNode.LLVMI16DataEscapeNode.class)
        private static final class Uncached
        extends LLVMDataEscapeNode.LLVMI16DataEscapeNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object executeWithType(Object arg0Value, LLVMInteropType.Structured arg1Value) {
                if (arg0Value instanceof Short) {
                    short arg0Value_ = (Short)arg0Value;
                    return LLVMDataEscapeNode.LLVMI16DataEscapeNode.escapingPrimitive(arg0Value_, arg1Value);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            public boolean isAdoptable() {
                return false;
            }
        }
    }

    @GeneratedBy(value=LLVMDataEscapeNode.LLVMI8DataEscapeNode.class)
    public static final class LLVMI8DataEscapeNodeGen
    extends LLVMDataEscapeNode.LLVMI8DataEscapeNode {
        private static final Uncached UNCACHED = new Uncached();
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMI8DataEscapeNodeGen() {
        }

        @Override
        public Object executeWithType(Object arg0Value, LLVMInteropType.Structured arg1Value) {
            int state = this.state_;
            if (state != 0 && arg0Value instanceof Byte) {
                byte arg0Value_ = (Byte)arg0Value;
                return LLVMDataEscapeNode.LLVMI8DataEscapeNode.escapingPrimitive(arg0Value_, arg1Value);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value, arg1Value);
        }

        private byte executeAndSpecialize(Object arg0Value, LLVMInteropType.Structured arg1Value) {
            int state = this.state_;
            if (arg0Value instanceof Byte) {
                byte arg0Value_ = (Byte)arg0Value;
                this.state_ = state |= 1;
                return LLVMDataEscapeNode.LLVMI8DataEscapeNode.escapingPrimitive(arg0Value_, arg1Value);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMDataEscapeNode.LLVMI8DataEscapeNode create() {
            return new LLVMI8DataEscapeNodeGen();
        }

        public static LLVMDataEscapeNode.LLVMI8DataEscapeNode getUncached() {
            return UNCACHED;
        }

        @GeneratedBy(value=LLVMDataEscapeNode.LLVMI8DataEscapeNode.class)
        private static final class Uncached
        extends LLVMDataEscapeNode.LLVMI8DataEscapeNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object executeWithType(Object arg0Value, LLVMInteropType.Structured arg1Value) {
                if (arg0Value instanceof Byte) {
                    byte arg0Value_ = (Byte)arg0Value;
                    return LLVMDataEscapeNode.LLVMI8DataEscapeNode.escapingPrimitive(arg0Value_, arg1Value);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            public boolean isAdoptable() {
                return false;
            }
        }
    }

    @GeneratedBy(value=LLVMDataEscapeNode.LLVMI1DataEscapeNode.class)
    public static final class LLVMI1DataEscapeNodeGen
    extends LLVMDataEscapeNode.LLVMI1DataEscapeNode {
        private static final Uncached UNCACHED = new Uncached();
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMI1DataEscapeNodeGen() {
        }

        @Override
        public Object executeWithType(Object arg0Value, LLVMInteropType.Structured arg1Value) {
            int state = this.state_;
            if (state != 0 && arg0Value instanceof Boolean) {
                boolean arg0Value_ = (Boolean)arg0Value;
                return LLVMDataEscapeNode.LLVMI1DataEscapeNode.escapingPrimitive(arg0Value_, arg1Value);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value, arg1Value);
        }

        private boolean executeAndSpecialize(Object arg0Value, LLVMInteropType.Structured arg1Value) {
            int state = this.state_;
            if (arg0Value instanceof Boolean) {
                boolean arg0Value_ = (Boolean)arg0Value;
                this.state_ = state |= 1;
                return LLVMDataEscapeNode.LLVMI1DataEscapeNode.escapingPrimitive(arg0Value_, arg1Value);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMDataEscapeNode.LLVMI1DataEscapeNode create() {
            return new LLVMI1DataEscapeNodeGen();
        }

        public static LLVMDataEscapeNode.LLVMI1DataEscapeNode getUncached() {
            return UNCACHED;
        }

        @GeneratedBy(value=LLVMDataEscapeNode.LLVMI1DataEscapeNode.class)
        private static final class Uncached
        extends LLVMDataEscapeNode.LLVMI1DataEscapeNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object executeWithType(Object arg0Value, LLVMInteropType.Structured arg1Value) {
                if (arg0Value instanceof Boolean) {
                    boolean arg0Value_ = (Boolean)arg0Value;
                    return LLVMDataEscapeNode.LLVMI1DataEscapeNode.escapingPrimitive(arg0Value_, arg1Value);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            public boolean isAdoptable() {
                return false;
            }
        }
    }
}

