/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.interop;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.llvm.runtime.CommonNodeFactory;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMFunctionDescriptor;
import com.oracle.truffle.llvm.runtime.LLVMGetStackNode;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.interop.LLVMDataEscapeNode;
import com.oracle.truffle.llvm.runtime.interop.LLVMForeignCallNodeFactory;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType;
import com.oracle.truffle.llvm.runtime.interop.convert.ForeignToLLVM;
import com.oracle.truffle.llvm.runtime.memory.LLVMStack;
import com.oracle.truffle.llvm.runtime.memory.LLVMThreadingStack;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.types.Type;

public class LLVMForeignCallNode
extends RootNode {
    @CompilerDirectives.CompilationFinal
    private TruffleLanguage.ContextReference<LLVMContext> ctxRef;
    private final LLVMInteropType.Structured returnBaseType;
    @Node.Child
    LLVMGetStackNode getStack;
    @Node.Child
    DirectCallNode callNode;
    @Node.Child
    LLVMDataEscapeNode prepareValueForEscape;
    @Node.Child
    PackForeignArgumentsNode packArguments;

    public LLVMForeignCallNode(LLVMLanguage language, LLVMFunctionDescriptor function, LLVMInteropType interopType) {
        super((TruffleLanguage)language);
        this.returnBaseType = LLVMForeignCallNode.getReturnBaseType(interopType);
        this.getStack = LLVMGetStackNode.create();
        this.callNode = DirectCallNode.create((CallTarget)LLVMForeignCallNode.getCallTarget(function));
        this.callNode.forceInlining();
        this.prepareValueForEscape = LLVMDataEscapeNode.create(function.getType().getReturnType());
        this.packArguments = LLVMForeignCallNodeFactory.PackForeignArgumentsNodeGen.create(function.getType().getArgumentTypes(), interopType);
    }

    public boolean isInternal() {
        return true;
    }

    public Object execute(VirtualFrame frame) {
        Object result;
        if (this.ctxRef == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.ctxRef = this.lookupContextReference(LLVMLanguage.class);
        }
        LLVMThreadingStack threadingStack = ((LLVMContext)this.ctxRef.get()).getThreadingStack();
        LLVMStack stack = this.getStack.executeWithTarget(threadingStack, Thread.currentThread());
        try (LLVMStack.StackPointer stackPointer = stack.newFrame();){
            result = this.callNode.call(this.packArguments.execute(frame.getArguments(), stackPointer));
        }
        catch (ArityException ex) {
            throw LLVMForeignCallNode.silenceException(RuntimeException.class, (Exception)((Object)ex));
        }
        return this.prepareValueForEscape.executeWithType(result, this.returnBaseType);
    }

    private static LLVMInteropType.Structured getReturnBaseType(LLVMInteropType functionType) {
        LLVMInteropType returnType;
        if (functionType instanceof LLVMInteropType.Function && (returnType = ((LLVMInteropType.Function)functionType).getReturnType()) instanceof LLVMInteropType.Value) {
            return ((LLVMInteropType.Value)returnType).getBaseType();
        }
        return null;
    }

    static CallTarget getCallTarget(LLVMFunctionDescriptor function) {
        if (function.isLLVMIRFunction()) {
            return function.getLLVMIRFunctionSlowPath();
        }
        if (function.isIntrinsicFunctionSlowPath()) {
            return function.getIntrinsicSlowPath().cachedCallTarget(function.getType());
        }
        CompilerDirectives.transferToInterpreter();
        throw new AssertionError((Object)("native function not supported at this point: " + function.getFunction()));
    }

    private static <E extends Exception> RuntimeException silenceException(Class<E> type, Exception ex) throws E {
        throw ex;
    }

    static abstract class PackForeignArgumentsNode
    extends LLVMNode {
        @Node.Children
        final ForeignToLLVM[] toLLVM;

        abstract Object[] execute(Object[] var1, LLVMStack.StackPointer var2) throws ArityException;

        PackForeignArgumentsNode(Type[] parameterTypes, LLVMInteropType interopType) {
            this.toLLVM = new ForeignToLLVM[parameterTypes.length];
            if (interopType instanceof LLVMInteropType.Function) {
                LLVMInteropType.Function interopFunctionType = (LLVMInteropType.Function)interopType;
                assert (interopFunctionType.getParameterLength() == parameterTypes.length);
                for (int i = 0; i < parameterTypes.length; ++i) {
                    LLVMInteropType interopParameterType = interopFunctionType.getParameter(i);
                    this.toLLVM[i] = interopParameterType instanceof LLVMInteropType.Value ? CommonNodeFactory.createForeignToLLVM((LLVMInteropType.Value)interopParameterType) : CommonNodeFactory.createForeignToLLVM(ForeignToLLVM.convert(parameterTypes[i]));
                }
            } else {
                for (int i = 0; i < parameterTypes.length; ++i) {
                    this.toLLVM[i] = CommonNodeFactory.createForeignToLLVM(ForeignToLLVM.convert(parameterTypes[i]));
                }
            }
        }

        @ExplodeLoop
        @Specialization(guards={"arguments.length == toLLVM.length"})
        Object[] packNonVarargs(Object[] arguments, LLVMStack.StackPointer stackPointer) {
            assert (arguments.length >= this.toLLVM.length);
            Object[] packedArguments = new Object[1 + arguments.length];
            packedArguments[0] = stackPointer;
            for (int i = 0; i < this.toLLVM.length; ++i) {
                packedArguments[i + 1] = this.toLLVM[i].executeWithTarget(arguments[i]);
            }
            return packedArguments;
        }

        ForeignToLLVM[] createVarargsToLLVM(int argCount) {
            int count = argCount - this.toLLVM.length;
            if (count > 0) {
                ForeignToLLVM[] ret = new ForeignToLLVM[count];
                for (int i = 0; i < count; ++i) {
                    ret[i] = CommonNodeFactory.createForeignToLLVM(ForeignToLLVM.ForeignToLLVMType.ANY);
                }
                return ret;
            }
            return new ForeignToLLVM[0];
        }

        boolean checkLength(int argCount, ForeignToLLVM[] varargsToLLVM) {
            return argCount == this.toLLVM.length + varargsToLLVM.length;
        }

        @ExplodeLoop
        @Specialization(guards={"checkLength(arguments.length, varargsToLLVM)"}, replaces={"packNonVarargs"})
        Object[] packCachedArgCount(Object[] arguments, LLVMStack.StackPointer stackPointer, @Cached(value="createVarargsToLLVM(arguments.length)") ForeignToLLVM[] varargsToLLVM) {
            assert (arguments.length >= this.toLLVM.length);
            Object[] packedArguments = this.packNonVarargs(arguments, stackPointer);
            int i = this.toLLVM.length;
            for (int j = 0; j < varargsToLLVM.length; ++j) {
                packedArguments[i + 1] = varargsToLLVM[j].executeWithTarget(arguments[i]);
                ++i;
            }
            return packedArguments;
        }

        ForeignToLLVM createVarargsToLLVM() {
            return CommonNodeFactory.createForeignToLLVM(ForeignToLLVM.ForeignToLLVMType.ANY);
        }

        @Specialization(guards={"arguments.length >= toLLVM.length"}, replaces={"packCachedArgCount"})
        Object[] packGeneric(Object[] arguments, LLVMStack.StackPointer stackPointer, @Cached(value="createVarargsToLLVM()") ForeignToLLVM varargsToLLVM) {
            Object[] args = this.packNonVarargs(arguments, stackPointer);
            for (int i = this.toLLVM.length; i < arguments.length; ++i) {
                args[i + 1] = varargsToLLVM.executeWithTarget(arguments[i]);
            }
            return args;
        }

        @Specialization(guards={"arguments.length < toLLVM.length"})
        Object[] error(Object[] arguments, LLVMStack.StackPointer stackPointer) throws ArityException {
            CompilerDirectives.transferToInterpreter();
            throw ArityException.create((int)this.toLLVM.length, (int)arguments.length);
        }
    }
}

