/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.interop.access;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.llvm.runtime.interop.LLVMDataEscapeNode;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropAccessNode;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropAccessNodeGen;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropWriteNode;
import com.oracle.truffle.llvm.runtime.interop.convert.ForeignToLLVM;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=LLVMInteropWriteNode.class)
public final class LLVMInteropWriteNodeGen
extends LLVMInteropWriteNode {
    private static final Uncached UNCACHED = new Uncached();
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);
    @CompilerDirectives.CompilationFinal
    private int state_;
    @CompilerDirectives.CompilationFinal
    private int exclude_;
    @Node.Child
    private KnownTypeData knownType_cache;
    @Node.Child
    private UnknownType0Data unknownType0_cache;
    @Node.Child
    private LLVMInteropWriteNode.ConvertOutgoingNode unknownType1_convertOutgoing_;
    @CompilerDirectives.CompilationFinal
    private BranchProfile unknownType1_exception_;

    private LLVMInteropWriteNodeGen() {
    }

    @Override
    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
    public void execute(LLVMInteropType.Structured arg0Value, Object arg1Value, long arg2Value, Object arg3Value, ForeignToLLVM.ForeignToLLVMType arg4Value) {
        int state = this.state_;
        if (state != 0) {
            KnownTypeData s1_;
            if ((state & 1) != 0 && (s1_ = this.knownType_cache) != null && arg0Value != null) {
                this.doKnownType(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, s1_.access_, s1_.interop_, s1_.convertOutgoing_, s1_.exception_);
                return;
            }
            if ((state & 2) != 0) {
                UnknownType0Data s2_ = this.unknownType0_cache;
                while (s2_ != null) {
                    if (s2_.interop_.accepts(arg1Value) && arg0Value == null) {
                        this.doUnknownType(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, s2_.interop_, s2_.convertOutgoing_, s2_.exception_);
                        return;
                    }
                    s2_ = s2_.next_;
                }
            }
            if ((state & 4) != 0 && arg0Value == null) {
                this.unknownType1Boundary(state, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
                return;
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        this.executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    private void unknownType1Boundary(int state, LLVMInteropType.Structured arg0Value, Object arg1Value, long arg2Value, Object arg3Value, ForeignToLLVM.ForeignToLLVMType arg4Value) {
        Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
        try {
            this.doUnknownType(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg1Value), this.unknownType1_convertOutgoing_, this.unknownType1_exception_);
            return;
        }
        finally {
            NodeUtil.popEncapsulatingNode((Node)prev_);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeAndSpecialize(LLVMInteropType.Structured arg0Value, Object arg1Value, long arg2Value, Object arg3Value, ForeignToLLVM.ForeignToLLVMType arg4Value) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        int exclude = this.exclude_;
        try {
            if (arg0Value != null) {
                KnownTypeData s1_ = (KnownTypeData)super.insert((Node)new KnownTypeData());
                s1_.access_ = s1_.insertAccessor(LLVMInteropAccessNode.create());
                s1_.interop_ = s1_.insertAccessor((InteropLibrary)INTEROP_LIBRARY_.createDispatched(3));
                s1_.convertOutgoing_ = s1_.insertAccessor(ConvertOutgoingNodeGen.create());
                s1_.exception_ = BranchProfile.create();
                this.knownType_cache = s1_;
                this.state_ = state |= 1;
                lock.unlock();
                hasLock = false;
                this.doKnownType(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, s1_.access_, s1_.interop_, s1_.convertOutgoing_, s1_.exception_);
                return;
            }
            if (exclude == 0) {
                int count2_ = 0;
                UnknownType0Data s2_ = this.unknownType0_cache;
                if ((state & 2) != 0) {
                    while (!(s2_ == null || s2_.interop_.accepts(arg1Value) && arg0Value == null)) {
                        s2_ = s2_.next_;
                        ++count2_;
                    }
                }
                if (s2_ == null && arg0Value == null && count2_ < 3) {
                    s2_ = (UnknownType0Data)super.insert((Node)new UnknownType0Data(this.unknownType0_cache));
                    s2_.interop_ = s2_.insertAccessor((InteropLibrary)INTEROP_LIBRARY_.create(arg1Value));
                    s2_.convertOutgoing_ = s2_.insertAccessor(ConvertOutgoingNodeGen.create());
                    s2_.exception_ = BranchProfile.create();
                    this.unknownType0_cache = s2_;
                    this.state_ = state |= 2;
                }
                if (s2_ != null) {
                    lock.unlock();
                    hasLock = false;
                    this.doUnknownType(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, s2_.interop_, s2_.convertOutgoing_, s2_.exception_);
                    return;
                }
            }
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
            try {
                if (arg0Value == null) {
                    this.unknownType1_convertOutgoing_ = (LLVMInteropWriteNode.ConvertOutgoingNode)super.insert((Node)ConvertOutgoingNodeGen.create());
                    this.unknownType1_exception_ = BranchProfile.create();
                    this.exclude_ = exclude |= 1;
                    this.unknownType0_cache = null;
                    state &= 0xFFFFFFFD;
                    this.state_ = state |= 4;
                    lock.unlock();
                    hasLock = false;
                    this.doUnknownType(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg1Value), this.unknownType1_convertOutgoing_, this.unknownType1_exception_);
                    return;
                }
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null, null, null, null}, new Object[]{arg0Value, arg1Value, arg2Value, arg3Value, arg4Value});
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        UnknownType0Data s2_;
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & state - 1) == 0 && ((s2_ = this.unknownType0_cache) == null || s2_.next_ == null)) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public static LLVMInteropWriteNode create() {
        return new LLVMInteropWriteNodeGen();
    }

    public static LLVMInteropWriteNode getUncached() {
        return UNCACHED;
    }

    @GeneratedBy(value=LLVMInteropWriteNode.ConvertOutgoingNode.class)
    static final class ConvertOutgoingNodeGen
    extends LLVMInteropWriteNode.ConvertOutgoingNode {
        private static final Uncached UNCACHED = new Uncached();
        @CompilerDirectives.CompilationFinal
        private int state_;
        @Node.Child
        private KnownTypeData knownType_cache;
        @Node.Child
        private UnknownTypeData unknownType_cache;

        private ConvertOutgoingNodeGen() {
        }

        @Override
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        Object execute(Object arg0Value, LLVMInteropType.Value arg1Value, ForeignToLLVM.ForeignToLLVMType arg2Value) {
            int state = this.state_;
            if (state != 0) {
                if ((state & 1) != 0 && arg1Value != null) {
                    KnownTypeData s1_ = this.knownType_cache;
                    while (s1_ != null) {
                        if (s1_.cachedOutgoingType_ == arg1Value.kind.foreignToLLVMType && arg2Value.getSizeInBytes() == s1_.cachedOutgoingType_.getSizeInBytes()) {
                            return this.doKnownType(arg0Value, arg1Value, arg2Value, s1_.cachedOutgoingType_, s1_.dataEscape_);
                        }
                        s1_ = s1_.next_;
                    }
                }
                if ((state & 2) != 0) {
                    UnknownTypeData s2_ = this.unknownType_cache;
                    while (s2_ != null) {
                        if (LLVMInteropWriteNode.ConvertOutgoingNode.typeMismatch(arg1Value, s2_.cachedType_) && s2_.cachedType_ == arg2Value) {
                            return this.doUnknownType(arg0Value, arg1Value, arg2Value, s2_.cachedType_, s2_.dataEscape_);
                        }
                        s2_ = s2_.next_;
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value);
        }

        private Object executeAndSpecialize(Object arg0Value, LLVMInteropType.Value arg1Value, ForeignToLLVM.ForeignToLLVMType arg2Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                ForeignToLLVM.ForeignToLLVMType cachedType__;
                if (arg1Value != null) {
                    Object cachedOutgoingType__;
                    int count1_ = 0;
                    KnownTypeData s1_ = this.knownType_cache;
                    if ((state & 1) != 0) {
                        while (s1_ != null && (s1_.cachedOutgoingType_ != arg1Value.kind.foreignToLLVMType || arg2Value.getSizeInBytes() != s1_.cachedOutgoingType_.getSizeInBytes())) {
                            s1_ = s1_.next_;
                            ++count1_;
                        }
                    }
                    if (s1_ == null) {
                        cachedOutgoingType__ = arg1Value.kind.foreignToLLVMType;
                        if (arg2Value.getSizeInBytes() == cachedOutgoingType__.getSizeInBytes() && count1_ < 3) {
                            s1_ = (KnownTypeData)super.insert((Node)new KnownTypeData(this.knownType_cache));
                            s1_.cachedOutgoingType_ = cachedOutgoingType__;
                            s1_.dataEscape_ = s1_.insertAccessor(LLVMDataEscapeNode.create(cachedOutgoingType__));
                            this.knownType_cache = s1_;
                            this.state_ = state |= 1;
                        }
                    }
                    if (s1_ != null) {
                        lock.unlock();
                        hasLock = false;
                        cachedOutgoingType__ = this.doKnownType(arg0Value, arg1Value, arg2Value, s1_.cachedOutgoingType_, s1_.dataEscape_);
                        return cachedOutgoingType__;
                    }
                }
                int count2_ = 0;
                UnknownTypeData s2_ = this.unknownType_cache;
                if ((state & 2) != 0) {
                    while (!(s2_ == null || LLVMInteropWriteNode.ConvertOutgoingNode.typeMismatch(arg1Value, s2_.cachedType_) && s2_.cachedType_ == arg2Value)) {
                        s2_ = s2_.next_;
                        ++count2_;
                    }
                }
                if (s2_ == null && LLVMInteropWriteNode.ConvertOutgoingNode.typeMismatch(arg1Value, cachedType__ = arg2Value) && count2_ < 3) {
                    s2_ = (UnknownTypeData)super.insert((Node)new UnknownTypeData(this.unknownType_cache));
                    s2_.cachedType_ = cachedType__;
                    s2_.dataEscape_ = s2_.insertAccessor(LLVMDataEscapeNode.create(arg2Value));
                    this.unknownType_cache = s2_;
                    this.state_ = state |= 2;
                }
                if (s2_ != null) {
                    lock.unlock();
                    hasLock = false;
                    Object object = this.doUnknownType(arg0Value, arg1Value, arg2Value, s2_.cachedType_, s2_.dataEscape_);
                    return object;
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null, null}, new Object[]{arg0Value, arg1Value, arg2Value});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                KnownTypeData s1_ = this.knownType_cache;
                UnknownTypeData s2_ = this.unknownType_cache;
                if (!(s1_ != null && s1_.next_ != null || s2_ != null && s2_.next_ != null)) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMInteropWriteNode.ConvertOutgoingNode create() {
            return new ConvertOutgoingNodeGen();
        }

        public static LLVMInteropWriteNode.ConvertOutgoingNode getUncached() {
            return UNCACHED;
        }

        @GeneratedBy(value=LLVMInteropWriteNode.ConvertOutgoingNode.class)
        private static final class Uncached
        extends LLVMInteropWriteNode.ConvertOutgoingNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            Object execute(Object arg0Value, LLVMInteropType.Value arg1Value, ForeignToLLVM.ForeignToLLVMType arg2Value) {
                if (arg1Value != null && arg2Value.getSizeInBytes() == arg1Value.kind.foreignToLLVMType.getSizeInBytes()) {
                    return this.doKnownType(arg0Value, arg1Value, arg2Value, arg1Value.kind.foreignToLLVMType, LLVMDataEscapeNode.getUncached(arg1Value.kind.foreignToLLVMType));
                }
                if (LLVMInteropWriteNode.ConvertOutgoingNode.typeMismatch(arg1Value, arg2Value)) {
                    return this.doUnknownType(arg0Value, arg1Value, arg2Value, arg2Value, LLVMDataEscapeNode.getUncached(arg2Value));
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null, null}, new Object[]{arg0Value, arg1Value, arg2Value});
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            public boolean isAdoptable() {
                return false;
            }
        }

        @GeneratedBy(value=LLVMInteropWriteNode.ConvertOutgoingNode.class)
        private static final class UnknownTypeData
        extends Node {
            @Node.Child
            UnknownTypeData next_;
            @CompilerDirectives.CompilationFinal
            ForeignToLLVM.ForeignToLLVMType cachedType_;
            @Node.Child
            LLVMDataEscapeNode dataEscape_;

            UnknownTypeData(UnknownTypeData next_) {
                this.next_ = next_;
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }

        @GeneratedBy(value=LLVMInteropWriteNode.ConvertOutgoingNode.class)
        private static final class KnownTypeData
        extends Node {
            @Node.Child
            KnownTypeData next_;
            @CompilerDirectives.CompilationFinal
            ForeignToLLVM.ForeignToLLVMType cachedOutgoingType_;
            @Node.Child
            LLVMDataEscapeNode dataEscape_;

            KnownTypeData(KnownTypeData next_) {
                this.next_ = next_;
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }
    }

    @GeneratedBy(value=LLVMInteropWriteNode.class)
    private static final class Uncached
    extends LLVMInteropWriteNode {
        private Uncached() {
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void execute(LLVMInteropType.Structured arg0Value, Object arg1Value, long arg2Value, Object arg3Value, ForeignToLLVM.ForeignToLLVMType arg4Value) {
            if (arg0Value != null) {
                this.doKnownType(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, LLVMInteropAccessNodeGen.getUncached(), (InteropLibrary)INTEROP_LIBRARY_.getUncached(), ConvertOutgoingNodeGen.getUncached(), BranchProfile.getUncached());
                return;
            }
            if (arg0Value == null) {
                this.doUnknownType(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg1Value), ConvertOutgoingNodeGen.getUncached(), BranchProfile.getUncached());
                return;
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null, null, null, null}, new Object[]{arg0Value, arg1Value, arg2Value, arg3Value, arg4Value});
        }

        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        public boolean isAdoptable() {
            return false;
        }
    }

    @GeneratedBy(value=LLVMInteropWriteNode.class)
    private static final class UnknownType0Data
    extends Node {
        @Node.Child
        UnknownType0Data next_;
        @Node.Child
        InteropLibrary interop_;
        @Node.Child
        LLVMInteropWriteNode.ConvertOutgoingNode convertOutgoing_;
        @CompilerDirectives.CompilationFinal
        BranchProfile exception_;

        UnknownType0Data(UnknownType0Data next_) {
            this.next_ = next_;
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return (T)super.insert(node);
        }
    }

    @GeneratedBy(value=LLVMInteropWriteNode.class)
    private static final class KnownTypeData
    extends Node {
        @Node.Child
        LLVMInteropAccessNode access_;
        @Node.Child
        InteropLibrary interop_;
        @Node.Child
        LLVMInteropWriteNode.ConvertOutgoingNode convertOutgoing_;
        @CompilerDirectives.CompilationFinal
        BranchProfile exception_;

        KnownTypeData() {
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return (T)super.insert(node);
        }
    }
}

