/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.interop.convert;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.llvm.runtime.except.LLVMPolyglotException;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType;
import com.oracle.truffle.llvm.runtime.interop.convert.ToAnyLLVM;
import com.oracle.truffle.llvm.runtime.interop.convert.ToDouble;
import com.oracle.truffle.llvm.runtime.interop.convert.ToFloat;
import com.oracle.truffle.llvm.runtime.interop.convert.ToI1;
import com.oracle.truffle.llvm.runtime.interop.convert.ToI16;
import com.oracle.truffle.llvm.runtime.interop.convert.ToI32;
import com.oracle.truffle.llvm.runtime.interop.convert.ToI64;
import com.oracle.truffle.llvm.runtime.interop.convert.ToI8;
import com.oracle.truffle.llvm.runtime.interop.convert.ToPointer;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.types.ArrayType;
import com.oracle.truffle.llvm.runtime.types.PointerType;
import com.oracle.truffle.llvm.runtime.types.PrimitiveType;
import com.oracle.truffle.llvm.runtime.types.StructureType;
import com.oracle.truffle.llvm.runtime.types.Type;
import com.oracle.truffle.llvm.runtime.types.VectorType;
import com.oracle.truffle.llvm.runtime.types.VoidType;

public abstract class ForeignToLLVM
extends LLVMNode {
    public abstract Object executeWithTarget(Object var1);

    public abstract Object executeWithType(Object var1, LLVMInteropType.Structured var2);

    public abstract Object executeWithForeignToLLVMType(Object var1, LLVMInteropType.Structured var2, ForeignToLLVMType var3);

    protected static boolean notLLVM(Object value) {
        return LLVMExpressionNode.notLLVM(value);
    }

    protected char getSingleStringCharacter(String value) {
        if (value.length() == 1) {
            return value.charAt(0);
        }
        CompilerDirectives.transferToInterpreter();
        throw new LLVMPolyglotException(this, "Expected number but got string.");
    }

    public static ForeignToLLVMType convert(Type type) {
        if (type instanceof PrimitiveType) {
            switch (((PrimitiveType)type).getPrimitiveKind()) {
                case I1: {
                    return ForeignToLLVMType.I1;
                }
                case I8: {
                    return ForeignToLLVMType.I8;
                }
                case I16: {
                    return ForeignToLLVMType.I16;
                }
                case I32: {
                    return ForeignToLLVMType.I32;
                }
                case I64: {
                    return ForeignToLLVMType.I64;
                }
                case FLOAT: {
                    return ForeignToLLVMType.FLOAT;
                }
                case DOUBLE: {
                    return ForeignToLLVMType.DOUBLE;
                }
            }
            throw new IllegalStateException("unexpected primitive kind " + (Object)((Object)((PrimitiveType)type).getPrimitiveKind()));
        }
        if (type instanceof PointerType) {
            return ForeignToLLVMType.POINTER;
        }
        if (type instanceof VoidType) {
            return ForeignToLLVMType.VOID;
        }
        if (type instanceof VectorType) {
            return ForeignToLLVMType.VECTOR;
        }
        if (type instanceof ArrayType) {
            return ForeignToLLVMType.ARRAY;
        }
        if (type instanceof StructureType) {
            return ForeignToLLVMType.STRUCT;
        }
        throw new IllegalStateException("unexpected type " + type);
    }

    public static SlowPathForeignToLLVM getUncached() {
        return SlowPathForeignToLLVM.INSTANCE;
    }

    public static final class SlowPathForeignToLLVM
    extends ForeignToLLVM {
        private static final SlowPathForeignToLLVM INSTANCE = new SlowPathForeignToLLVM();

        @CompilerDirectives.TruffleBoundary
        public Object convert(Type type, Object value, LLVMInteropType.Structured interopType) throws UnsupportedTypeException {
            return this.convert(ForeignToLLVM.convert(type), value, interopType);
        }

        @CompilerDirectives.TruffleBoundary
        public Object convert(ForeignToLLVMType type, Object value, LLVMInteropType.Structured interopType) throws UnsupportedTypeException {
            if (type == ForeignToLLVMType.ANY) {
                return ToAnyLLVM.slowPathPrimitiveConvert(value);
            }
            if (type == ForeignToLLVMType.POINTER) {
                return ToPointer.slowPathPrimitiveConvert(value, interopType);
            }
            switch (type) {
                case DOUBLE: {
                    return ToDouble.slowPathPrimitiveConvert(this, value);
                }
                case FLOAT: {
                    return Float.valueOf(ToFloat.slowPathPrimitiveConvert(this, value));
                }
                case I1: {
                    return ToI1.slowPathPrimitiveConvert(this, value);
                }
                case I16: {
                    return ToI16.slowPathPrimitiveConvert(this, value);
                }
                case I32: {
                    return ToI32.slowPathPrimitiveConvert(this, value);
                }
                case I64: {
                    return ToI64.slowPathPrimitiveConvert(this, value);
                }
                case I8: {
                    return ToI8.slowPathPrimitiveConvert(this, value);
                }
            }
            throw new IllegalStateException(type.toString());
        }

        @Override
        public Object executeWithTarget(Object value) {
            CompilerDirectives.transferToInterpreter();
            throw new IllegalStateException("Use convert method.");
        }

        @Override
        public Object executeWithType(Object value, LLVMInteropType.Structured type) {
            CompilerDirectives.transferToInterpreter();
            throw new IllegalStateException("Use convert method.");
        }

        @Override
        public Object executeWithForeignToLLVMType(Object value, LLVMInteropType.Structured type, ForeignToLLVMType ftlType) {
            try {
                return this.convert(ftlType, value, type);
            }
            catch (UnsupportedTypeException ex) {
                CompilerDirectives.transferToInterpreter();
                throw new LLVMPolyglotException(this, "Unexpected foreign object type.");
            }
        }

        public boolean isAdoptable() {
            return false;
        }

        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }
    }

    public static final class ForeignToLLVMType
    extends Enum<ForeignToLLVMType> {
        public static final /* enum */ ForeignToLLVMType I1 = new ForeignToLLVMType(1);
        public static final /* enum */ ForeignToLLVMType I8 = new ForeignToLLVMType(1);
        public static final /* enum */ ForeignToLLVMType I16 = new ForeignToLLVMType(2);
        public static final /* enum */ ForeignToLLVMType I32 = new ForeignToLLVMType(4);
        public static final /* enum */ ForeignToLLVMType I64 = new ForeignToLLVMType(8);
        public static final /* enum */ ForeignToLLVMType FLOAT = new ForeignToLLVMType(4);
        public static final /* enum */ ForeignToLLVMType DOUBLE = new ForeignToLLVMType(8);
        public static final /* enum */ ForeignToLLVMType POINTER = new ForeignToLLVMType(8);
        public static final /* enum */ ForeignToLLVMType VECTOR = new ForeignToLLVMType(-1);
        public static final /* enum */ ForeignToLLVMType ARRAY = new ForeignToLLVMType(-1);
        public static final /* enum */ ForeignToLLVMType STRUCT = new ForeignToLLVMType(-1);
        public static final /* enum */ ForeignToLLVMType ANY = new ForeignToLLVMType(-1);
        public static final /* enum */ ForeignToLLVMType VOID = new ForeignToLLVMType(-1);
        private final int size;
        private static final /* synthetic */ ForeignToLLVMType[] $VALUES;

        public static ForeignToLLVMType[] values() {
            return (ForeignToLLVMType[])$VALUES.clone();
        }

        public static ForeignToLLVMType valueOf(String name) {
            return Enum.valueOf(ForeignToLLVMType.class, name);
        }

        private ForeignToLLVMType(int size) {
            this.size = size;
        }

        public static ForeignToLLVMType getIntegerType(int bitWidth) {
            switch (bitWidth) {
                case 1: {
                    return I1;
                }
                case 8: {
                    return I8;
                }
                case 16: {
                    return I16;
                }
                case 32: {
                    return I32;
                }
                case 64: {
                    return I64;
                }
            }
            CompilerDirectives.transferToInterpreter();
            throw new IllegalStateException("There is no integer type with " + bitWidth + " bits defined");
        }

        public int getSizeInBytes() {
            assert (this.size > 0);
            return this.size;
        }

        public boolean isI1() {
            return this == I1;
        }

        public boolean isI8() {
            return this == I8;
        }

        public boolean isI16() {
            return this == I16;
        }

        public boolean isI32() {
            return this == I32;
        }

        public boolean isI64() {
            return this == I64;
        }

        public boolean isFloat() {
            return this == FLOAT;
        }

        public boolean isDouble() {
            return this == DOUBLE;
        }

        public boolean isPointer() {
            return this == POINTER;
        }

        public static Object getDefaultValue(ForeignToLLVMType type) {
            switch (type) {
                case I1: {
                    return false;
                }
                case I8: {
                    return (byte)0;
                }
                case I16: {
                    return (short)0;
                }
                case I32: {
                    return 0;
                }
                case I64: 
                case POINTER: {
                    return 0L;
                }
                case FLOAT: {
                    return Float.valueOf(0.0f);
                }
                case DOUBLE: {
                    return 0.0;
                }
            }
            CompilerDirectives.transferToInterpreter();
            throw new IllegalStateException("Unexpected value: " + (Object)((Object)type));
        }

        static {
            $VALUES = new ForeignToLLVMType[]{I1, I8, I16, I32, I64, FLOAT, DOUBLE, POINTER, VECTOR, ARRAY, STRUCT, ANY, VOID};
        }
    }
}

