/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.interop.convert;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.llvm.runtime.except.LLVMPolyglotException;
import com.oracle.truffle.llvm.runtime.interop.convert.ForeignToLLVM;

public abstract class ToI32
extends ForeignToLLVM {
    @Specialization
    protected int fromInt(int value) {
        return value;
    }

    @Specialization
    protected int fromChar(char value) {
        return value;
    }

    @Specialization
    protected int fromShort(short value) {
        return value;
    }

    @Specialization
    protected int fromLong(long value) {
        return (int)value;
    }

    @Specialization
    protected int fromByte(byte value) {
        return value;
    }

    @Specialization
    protected int fromFloat(float value) {
        return (int)value;
    }

    @Specialization
    protected int fromDouble(double value) {
        return (int)value;
    }

    @Specialization
    protected int fromBoolean(boolean value) {
        return value ? 1 : 0;
    }

    @Specialization
    protected int fromString(String value) {
        return this.getSingleStringCharacter(value);
    }

    @Specialization(limit="5", guards={"notLLVM(obj)", "interop.isNumber(obj)"})
    protected int fromForeign(Object obj, @CachedLibrary(value="obj") InteropLibrary interop, @Cached BranchProfile exception) {
        try {
            return interop.asInt(obj);
        }
        catch (UnsupportedMessageException ex) {
            exception.enter();
            throw new LLVMPolyglotException(this, "Polyglot number can't be converted to int.");
        }
    }

    @CompilerDirectives.TruffleBoundary
    static int slowPathPrimitiveConvert(ForeignToLLVM thiz, Object value) throws UnsupportedTypeException {
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? 1 : 0;
        }
        if (value instanceof Character) {
            return ((Character)value).charValue();
        }
        if (value instanceof String) {
            return thiz.getSingleStringCharacter((String)value);
        }
        try {
            return ((InteropLibrary)InteropLibrary.getFactory().getUncached()).asInt(value);
        }
        catch (UnsupportedMessageException ex) {
            throw UnsupportedTypeException.create((Object[])new Object[]{value});
        }
    }
}

