/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.interop.convert;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.llvm.runtime.interop.LLVMInternalTruffleObject;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType;
import com.oracle.truffle.llvm.runtime.interop.convert.ForeignToLLVM;
import com.oracle.truffle.llvm.runtime.interop.convert.ToPointer;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

@GeneratedBy(value=ToPointer.class)
public final class ToPointerNodeGen
extends ToPointer {
    @Node.Child
    private ToPointer.Dummy child0_;
    @Node.Child
    private ToPointer.InteropTypeNode child1_;
    @CompilerDirectives.CompilationFinal
    private int state_;

    private ToPointerNodeGen(ToPointer.Dummy child0, ToPointer.InteropTypeNode child1) {
        this.child0_ = child0;
        this.child1_ = child1;
    }

    @Override
    public Object executeWithForeignToLLVMType(Object child0Value, LLVMInteropType.Structured child1Value, ForeignToLLVM.ForeignToLLVMType ftlType) {
        int state = this.state_;
        if (state != 0) {
            if ((state & 1) != 0 && child0Value instanceof Integer) {
                int child0Value_ = (Integer)child0Value;
                return this.fromInt(child0Value_, child1Value);
            }
            if ((state & 2) != 0 && child0Value instanceof Character) {
                char child0Value_ = ((Character)child0Value).charValue();
                return this.fromChar(child0Value_, child1Value);
            }
            if ((state & 4) != 0 && child0Value instanceof Long) {
                long child0Value_ = (Long)child0Value;
                return this.fromLong(child0Value_, child1Value);
            }
            if ((state & 8) != 0 && child0Value instanceof Byte) {
                byte child0Value_ = (Byte)child0Value;
                return this.fromByte(child0Value_, child1Value);
            }
            if ((state & 0x10) != 0 && child0Value instanceof Short) {
                short child0Value_ = (Short)child0Value;
                return this.fromShort(child0Value_, child1Value);
            }
            if ((state & 0x20) != 0 && child0Value instanceof Float) {
                float child0Value_ = ((Float)child0Value).floatValue();
                return this.fromFloat(child0Value_, child1Value);
            }
            if ((state & 0x40) != 0 && child0Value instanceof Double) {
                double child0Value_ = (Double)child0Value;
                return this.fromDouble(child0Value_, child1Value);
            }
            if ((state & 0x80) != 0 && child0Value instanceof Boolean) {
                boolean child0Value_ = (Boolean)child0Value;
                return this.fromBoolean(child0Value_, child1Value);
            }
            if ((state & 0x100) != 0 && child0Value instanceof String) {
                String child0Value_ = (String)child0Value;
                return this.fromString(child0Value_, child1Value);
            }
            if ((state & 0x200) != 0 && LLVMTypes.isPointer(child0Value)) {
                LLVMPointer child0Value_ = LLVMTypes.asPointer(child0Value);
                return this.fromPointer(child0Value_, child1Value);
            }
            if ((state & 0x400) != 0 && ForeignToLLVM.notLLVM(child0Value)) {
                return this.fromTruffleObject(child0Value, child1Value);
            }
            if ((state & 0x800) != 0 && child0Value instanceof LLVMInternalTruffleObject) {
                LLVMInternalTruffleObject child0Value_ = (LLVMInternalTruffleObject)child0Value;
                return this.fromInternal(child0Value_, child1Value);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(child0Value, child1Value);
    }

    @Override
    public Object executeWithType(Object child0Value, LLVMInteropType.Structured child1Value) {
        int state = this.state_;
        if (state != 0) {
            if ((state & 1) != 0 && child0Value instanceof Integer) {
                int child0Value_ = (Integer)child0Value;
                return this.fromInt(child0Value_, child1Value);
            }
            if ((state & 2) != 0 && child0Value instanceof Character) {
                char child0Value_ = ((Character)child0Value).charValue();
                return this.fromChar(child0Value_, child1Value);
            }
            if ((state & 4) != 0 && child0Value instanceof Long) {
                long child0Value_ = (Long)child0Value;
                return this.fromLong(child0Value_, child1Value);
            }
            if ((state & 8) != 0 && child0Value instanceof Byte) {
                byte child0Value_ = (Byte)child0Value;
                return this.fromByte(child0Value_, child1Value);
            }
            if ((state & 0x10) != 0 && child0Value instanceof Short) {
                short child0Value_ = (Short)child0Value;
                return this.fromShort(child0Value_, child1Value);
            }
            if ((state & 0x20) != 0 && child0Value instanceof Float) {
                float child0Value_ = ((Float)child0Value).floatValue();
                return this.fromFloat(child0Value_, child1Value);
            }
            if ((state & 0x40) != 0 && child0Value instanceof Double) {
                double child0Value_ = (Double)child0Value;
                return this.fromDouble(child0Value_, child1Value);
            }
            if ((state & 0x80) != 0 && child0Value instanceof Boolean) {
                boolean child0Value_ = (Boolean)child0Value;
                return this.fromBoolean(child0Value_, child1Value);
            }
            if ((state & 0x100) != 0 && child0Value instanceof String) {
                String child0Value_ = (String)child0Value;
                return this.fromString(child0Value_, child1Value);
            }
            if ((state & 0x200) != 0 && LLVMTypes.isPointer(child0Value)) {
                LLVMPointer child0Value_ = LLVMTypes.asPointer(child0Value);
                return this.fromPointer(child0Value_, child1Value);
            }
            if ((state & 0x400) != 0 && ForeignToLLVM.notLLVM(child0Value)) {
                return this.fromTruffleObject(child0Value, child1Value);
            }
            if ((state & 0x800) != 0 && child0Value instanceof LLVMInternalTruffleObject) {
                LLVMInternalTruffleObject child0Value_ = (LLVMInternalTruffleObject)child0Value;
                return this.fromInternal(child0Value_, child1Value);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(child0Value, child1Value);
    }

    @Override
    public Object executeWithTarget(Object child0Value) {
        int state = this.state_;
        LLVMInteropType.Structured child1Value_ = this.child1_.execute();
        if (state != 0) {
            if ((state & 1) != 0 && child0Value instanceof Integer) {
                int child0Value_ = (Integer)child0Value;
                return this.fromInt(child0Value_, child1Value_);
            }
            if ((state & 2) != 0 && child0Value instanceof Character) {
                char child0Value_ = ((Character)child0Value).charValue();
                return this.fromChar(child0Value_, child1Value_);
            }
            if ((state & 4) != 0 && child0Value instanceof Long) {
                long child0Value_ = (Long)child0Value;
                return this.fromLong(child0Value_, child1Value_);
            }
            if ((state & 8) != 0 && child0Value instanceof Byte) {
                byte child0Value_ = (Byte)child0Value;
                return this.fromByte(child0Value_, child1Value_);
            }
            if ((state & 0x10) != 0 && child0Value instanceof Short) {
                short child0Value_ = (Short)child0Value;
                return this.fromShort(child0Value_, child1Value_);
            }
            if ((state & 0x20) != 0 && child0Value instanceof Float) {
                float child0Value_ = ((Float)child0Value).floatValue();
                return this.fromFloat(child0Value_, child1Value_);
            }
            if ((state & 0x40) != 0 && child0Value instanceof Double) {
                double child0Value_ = (Double)child0Value;
                return this.fromDouble(child0Value_, child1Value_);
            }
            if ((state & 0x80) != 0 && child0Value instanceof Boolean) {
                boolean child0Value_ = (Boolean)child0Value;
                return this.fromBoolean(child0Value_, child1Value_);
            }
            if ((state & 0x100) != 0 && child0Value instanceof String) {
                String child0Value_ = (String)child0Value;
                return this.fromString(child0Value_, child1Value_);
            }
            if ((state & 0x200) != 0 && LLVMTypes.isPointer(child0Value)) {
                LLVMPointer child0Value_ = LLVMTypes.asPointer(child0Value);
                return this.fromPointer(child0Value_, child1Value_);
            }
            if ((state & 0x400) != 0 && ForeignToLLVM.notLLVM(child0Value)) {
                return this.fromTruffleObject(child0Value, child1Value_);
            }
            if ((state & 0x800) != 0 && child0Value instanceof LLVMInternalTruffleObject) {
                LLVMInternalTruffleObject child0Value_ = (LLVMInternalTruffleObject)child0Value;
                return this.fromInternal(child0Value_, child1Value_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(child0Value, child1Value_);
    }

    private Object executeAndSpecialize(Object child0Value, LLVMInteropType.Structured child1Value) {
        int state = this.state_;
        if (child0Value instanceof Integer) {
            int child0Value_ = (Integer)child0Value;
            this.state_ = state |= 1;
            return this.fromInt(child0Value_, child1Value);
        }
        if (child0Value instanceof Character) {
            char child0Value_ = ((Character)child0Value).charValue();
            this.state_ = state |= 2;
            return this.fromChar(child0Value_, child1Value);
        }
        if (child0Value instanceof Long) {
            long child0Value_ = (Long)child0Value;
            this.state_ = state |= 4;
            return this.fromLong(child0Value_, child1Value);
        }
        if (child0Value instanceof Byte) {
            byte child0Value_ = (Byte)child0Value;
            this.state_ = state |= 8;
            return this.fromByte(child0Value_, child1Value);
        }
        if (child0Value instanceof Short) {
            short child0Value_ = (Short)child0Value;
            this.state_ = state |= 0x10;
            return this.fromShort(child0Value_, child1Value);
        }
        if (child0Value instanceof Float) {
            float child0Value_ = ((Float)child0Value).floatValue();
            this.state_ = state |= 0x20;
            return this.fromFloat(child0Value_, child1Value);
        }
        if (child0Value instanceof Double) {
            double child0Value_ = (Double)child0Value;
            this.state_ = state |= 0x40;
            return this.fromDouble(child0Value_, child1Value);
        }
        if (child0Value instanceof Boolean) {
            boolean child0Value_ = (Boolean)child0Value;
            this.state_ = state |= 0x80;
            return this.fromBoolean(child0Value_, child1Value);
        }
        if (child0Value instanceof String) {
            String child0Value_ = (String)child0Value;
            this.state_ = state |= 0x100;
            return this.fromString(child0Value_, child1Value);
        }
        if (LLVMTypes.isPointer(child0Value)) {
            LLVMPointer child0Value_ = LLVMTypes.asPointer(child0Value);
            this.state_ = state |= 0x200;
            return this.fromPointer(child0Value_, child1Value);
        }
        if (ForeignToLLVM.notLLVM(child0Value)) {
            this.state_ = state |= 0x400;
            return this.fromTruffleObject(child0Value, child1Value);
        }
        if (child0Value instanceof LLVMInternalTruffleObject) {
            LLVMInternalTruffleObject child0Value_ = (LLVMInternalTruffleObject)child0Value;
            this.state_ = state |= 0x800;
            return this.fromInternal(child0Value_, child1Value);
        }
        throw new UnsupportedSpecializationException((Node)this, new Node[]{this.child0_, this.child1_}, new Object[]{child0Value, child1Value});
    }

    public NodeCost getCost() {
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & state - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public static ToPointer create(ToPointer.Dummy child0, ToPointer.InteropTypeNode child1) {
        return new ToPointerNodeGen(child0, child1);
    }
}

