/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.library.internal;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedAccessDefaults;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedReadLibrary;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMObjectAccess;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMToPointerNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMToPointerNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.factories.LLVMObjectAccessFactory;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=LLVMManagedAccessDefaults.FallbackRead.class)
final class FallbackReadGen {
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);

    private FallbackReadGen() {
    }

    static {
        LibraryExport.register(LLVMManagedAccessDefaults.FallbackRead.class, (LibraryExport[])new LibraryExport[]{new LLVMManagedReadLibraryExports()});
    }

    @GeneratedBy(value=LLVMManagedAccessDefaults.FallbackRead.class)
    private static final class LLVMManagedReadLibraryExports
    extends LibraryExport<LLVMManagedReadLibrary> {
        private LLVMManagedReadLibraryExports() {
            super(LLVMManagedReadLibrary.class, Object.class, true);
        }

        protected LLVMManagedReadLibrary createUncached(Object receiver) {
            return new Uncached(receiver);
        }

        protected LLVMManagedReadLibrary createCached(Object receiver) {
            return new Cached(receiver);
        }

        @GeneratedBy(value=LLVMManagedAccessDefaults.FallbackRead.class)
        private static final class Uncached
        extends LLVMManagedReadLibrary {
            @Node.Child
            private DynamicDispatchLibrary dynamicDispatch_;
            private final Class<?> dynamicDispatchTarget_;

            Uncached(Object receiver) {
                this.dynamicDispatch_ = (DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver);
                this.dynamicDispatchTarget_ = this.dynamicDispatch_.dispatch(receiver);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                return this.dynamicDispatch_.accepts(receiver) && this.dynamicDispatch_.dispatch(receiver) == this.dynamicDispatchTarget_;
            }

            public boolean isAdoptable() {
                return false;
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isReadable(Object arg0Value) {
                return LLVMManagedAccessDefaults.FallbackRead.isReadable(arg0Value, LLVMObjectAccessFactory.createRead());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public byte readI8(Object arg0Value, long arg1Value) {
                return LLVMManagedAccessDefaults.FallbackRead.readI8(arg0Value, arg1Value, LLVMObjectAccessFactory.createRead());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public short readI16(Object arg0Value, long arg1Value) {
                return LLVMManagedAccessDefaults.FallbackRead.readI16(arg0Value, arg1Value, LLVMObjectAccessFactory.createRead());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int readI32(Object arg0Value, long arg1Value) {
                return LLVMManagedAccessDefaults.FallbackRead.readI32(arg0Value, arg1Value, LLVMObjectAccessFactory.createRead());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object readGenericI64(Object arg0Value, long arg1Value) {
                return LLVMManagedAccessDefaults.FallbackRead.readGenericI64(arg0Value, arg1Value, LLVMObjectAccessFactory.createRead());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public float readFloat(Object arg0Value, long arg1Value) {
                return LLVMManagedAccessDefaults.FallbackRead.readFloat(arg0Value, arg1Value, LLVMObjectAccessFactory.createRead());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public double readDouble(Object arg0Value, long arg1Value) {
                return LLVMManagedAccessDefaults.FallbackRead.readDouble(arg0Value, arg1Value, LLVMObjectAccessFactory.createRead());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public LLVMPointer readPointer(Object arg0Value, long arg1Value) {
                return LLVMManagedAccessDefaults.FallbackRead.readPointer(arg0Value, arg1Value, LLVMToPointerNodeGen.getUncached(), LLVMObjectAccessFactory.createRead());
            }
        }

        @GeneratedBy(value=LLVMManagedAccessDefaults.FallbackRead.class)
        private static final class Cached
        extends LLVMManagedReadLibrary {
            @Node.Child
            private DynamicDispatchLibrary dynamicDispatch_;
            private final Class<?> dynamicDispatchTarget_;
            @CompilerDirectives.CompilationFinal
            private int state_;
            @Node.Child
            private LLVMObjectAccess.LLVMObjectReadNode read;
            @Node.Child
            private LLVMToPointerNode readPointerNode__toPointer_;

            Cached(Object receiver) {
                this.dynamicDispatch_ = (DynamicDispatchLibrary)this.insert((Node)((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.create(receiver)));
                this.dynamicDispatchTarget_ = ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver)).dispatch(receiver);
            }

            public boolean accepts(Object receiver) {
                return this.dynamicDispatch_.accepts(receiver) && this.dynamicDispatch_.dispatch(receiver) == this.dynamicDispatchTarget_;
            }

            @Override
            public boolean isReadable(Object arg0Value) {
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                int state = this.state_;
                if ((state & 1) != 0) {
                    return LLVMManagedAccessDefaults.FallbackRead.isReadable(arg0Value, this.read);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isReadableNode_AndSpecialize(arg0Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean isReadableNode_AndSpecialize(Object arg0Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    LLVMObjectAccess.LLVMObjectReadNode isReadableNode__read___ = LLVMObjectAccessFactory.createRead();
                    if (isReadableNode__read___ instanceof Node) {
                        super.insert((Node)isReadableNode__read___);
                    }
                    if (this.read == null) {
                        this.read = isReadableNode__read___;
                    }
                    this.state_ = state |= 1;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = LLVMManagedAccessDefaults.FallbackRead.isReadable(arg0Value, this.read);
                    return bl;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public NodeCost getCost() {
                int state = this.state_;
                if ((state & 1) == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public byte readI8(Object arg0Value, long arg1Value) {
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                int state = this.state_;
                if ((state & 2) != 0) {
                    return LLVMManagedAccessDefaults.FallbackRead.readI8(arg0Value, arg1Value, this.read);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.readI8Node_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private byte readI8Node_AndSpecialize(Object arg0Value, long arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    LLVMObjectAccess.LLVMObjectReadNode readI8Node__read___ = LLVMObjectAccessFactory.createRead();
                    if (readI8Node__read___ instanceof Node) {
                        super.insert((Node)readI8Node__read___);
                    }
                    if (this.read == null) {
                        this.read = readI8Node__read___;
                    }
                    this.state_ = state |= 2;
                    lock.unlock();
                    hasLock = false;
                    byte by = LLVMManagedAccessDefaults.FallbackRead.readI8(arg0Value, arg1Value, this.read);
                    return by;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public short readI16(Object arg0Value, long arg1Value) {
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                int state = this.state_;
                if ((state & 4) != 0) {
                    return LLVMManagedAccessDefaults.FallbackRead.readI16(arg0Value, arg1Value, this.read);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.readI16Node_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private short readI16Node_AndSpecialize(Object arg0Value, long arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    LLVMObjectAccess.LLVMObjectReadNode readI16Node__read___ = LLVMObjectAccessFactory.createRead();
                    if (readI16Node__read___ instanceof Node) {
                        super.insert((Node)readI16Node__read___);
                    }
                    if (this.read == null) {
                        this.read = readI16Node__read___;
                    }
                    this.state_ = state |= 4;
                    lock.unlock();
                    hasLock = false;
                    short s = LLVMManagedAccessDefaults.FallbackRead.readI16(arg0Value, arg1Value, this.read);
                    return s;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public int readI32(Object arg0Value, long arg1Value) {
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                int state = this.state_;
                if ((state & 8) != 0) {
                    return LLVMManagedAccessDefaults.FallbackRead.readI32(arg0Value, arg1Value, this.read);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.readI32Node_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private int readI32Node_AndSpecialize(Object arg0Value, long arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    LLVMObjectAccess.LLVMObjectReadNode readI32Node__read___ = LLVMObjectAccessFactory.createRead();
                    if (readI32Node__read___ instanceof Node) {
                        super.insert((Node)readI32Node__read___);
                    }
                    if (this.read == null) {
                        this.read = readI32Node__read___;
                    }
                    this.state_ = state |= 8;
                    lock.unlock();
                    hasLock = false;
                    int n = LLVMManagedAccessDefaults.FallbackRead.readI32(arg0Value, arg1Value, this.read);
                    return n;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public Object readGenericI64(Object arg0Value, long arg1Value) {
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                int state = this.state_;
                if ((state & 0x10) != 0) {
                    return LLVMManagedAccessDefaults.FallbackRead.readGenericI64(arg0Value, arg1Value, this.read);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.readGenericI64Node_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Object readGenericI64Node_AndSpecialize(Object arg0Value, long arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    LLVMObjectAccess.LLVMObjectReadNode readGenericI64Node__read___ = LLVMObjectAccessFactory.createRead();
                    if (readGenericI64Node__read___ instanceof Node) {
                        super.insert((Node)readGenericI64Node__read___);
                    }
                    if (this.read == null) {
                        this.read = readGenericI64Node__read___;
                    }
                    this.state_ = state |= 0x10;
                    lock.unlock();
                    hasLock = false;
                    Object object = LLVMManagedAccessDefaults.FallbackRead.readGenericI64(arg0Value, arg1Value, this.read);
                    return object;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public float readFloat(Object arg0Value, long arg1Value) {
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                int state = this.state_;
                if ((state & 0x20) != 0) {
                    return LLVMManagedAccessDefaults.FallbackRead.readFloat(arg0Value, arg1Value, this.read);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.readFloatNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private float readFloatNode_AndSpecialize(Object arg0Value, long arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    LLVMObjectAccess.LLVMObjectReadNode readFloatNode__read___ = LLVMObjectAccessFactory.createRead();
                    if (readFloatNode__read___ instanceof Node) {
                        super.insert((Node)readFloatNode__read___);
                    }
                    if (this.read == null) {
                        this.read = readFloatNode__read___;
                    }
                    this.state_ = state |= 0x20;
                    lock.unlock();
                    hasLock = false;
                    float f = LLVMManagedAccessDefaults.FallbackRead.readFloat(arg0Value, arg1Value, this.read);
                    return f;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public double readDouble(Object arg0Value, long arg1Value) {
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                int state = this.state_;
                if ((state & 0x40) != 0) {
                    return LLVMManagedAccessDefaults.FallbackRead.readDouble(arg0Value, arg1Value, this.read);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.readDoubleNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private double readDoubleNode_AndSpecialize(Object arg0Value, long arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    LLVMObjectAccess.LLVMObjectReadNode readDoubleNode__read___ = LLVMObjectAccessFactory.createRead();
                    if (readDoubleNode__read___ instanceof Node) {
                        super.insert((Node)readDoubleNode__read___);
                    }
                    if (this.read == null) {
                        this.read = readDoubleNode__read___;
                    }
                    this.state_ = state |= 0x40;
                    lock.unlock();
                    hasLock = false;
                    double d = LLVMManagedAccessDefaults.FallbackRead.readDouble(arg0Value, arg1Value, this.read);
                    return d;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public LLVMPointer readPointer(Object arg0Value, long arg1Value) {
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                int state = this.state_;
                if ((state & 0x80) != 0) {
                    return LLVMManagedAccessDefaults.FallbackRead.readPointer(arg0Value, arg1Value, this.readPointerNode__toPointer_, this.read);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.readPointerNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private LLVMPointer readPointerNode_AndSpecialize(Object arg0Value, long arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    this.readPointerNode__toPointer_ = (LLVMToPointerNode)super.insert((Node)LLVMToPointerNodeGen.create());
                    LLVMObjectAccess.LLVMObjectReadNode readPointerNode__read___ = LLVMObjectAccessFactory.createRead();
                    if (readPointerNode__read___ instanceof Node) {
                        super.insert((Node)readPointerNode__read___);
                    }
                    if (this.read == null) {
                        this.read = readPointerNode__read___;
                    }
                    this.state_ = state |= 0x80;
                    lock.unlock();
                    hasLock = false;
                    LLVMPointer lLVMPointer = LLVMManagedAccessDefaults.FallbackRead.readPointer(arg0Value, arg1Value, this.readPointerNode__toPointer_, this.read);
                    return lLVMPointer;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }
        }
    }
}

