/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.library.internal;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.library.Library;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.library.Message;
import com.oracle.truffle.api.library.ReflectionLibrary;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedAccessDefaults;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedReadLibrary;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=LLVMManagedReadLibrary.class)
final class LLVMManagedReadLibraryGen
extends LibraryFactory<LLVMManagedReadLibrary> {
    private static final Class<LLVMManagedReadLibrary> LIBRARY_CLASS = LLVMManagedReadLibraryGen.lazyLibraryClass();
    private static final Message IS_READABLE = new MessageImpl("isReadable", 0, Boolean.TYPE, Object.class);
    private static final Message READ_I8 = new MessageImpl("readI8", 1, Byte.TYPE, Object.class, Long.TYPE);
    private static final Message READ_I16 = new MessageImpl("readI16", 2, Short.TYPE, Object.class, Long.TYPE);
    private static final Message READ_I32 = new MessageImpl("readI32", 3, Integer.TYPE, Object.class, Long.TYPE);
    private static final Message READ_FLOAT = new MessageImpl("readFloat", 4, Float.TYPE, Object.class, Long.TYPE);
    private static final Message READ_I64 = new MessageImpl("readI64", 5, Long.TYPE, Object.class, Long.TYPE);
    private static final Message READ_DOUBLE = new MessageImpl("readDouble", 6, Double.TYPE, Object.class, Long.TYPE);
    private static final Message READ_POINTER = new MessageImpl("readPointer", 7, LLVMPointer.class, Object.class, Long.TYPE);
    private static final Message READ_GENERIC_I64 = new MessageImpl("readGenericI64", 8, Object.class, Object.class, Long.TYPE);
    private static final LLVMManagedReadLibraryGen INSTANCE = new LLVMManagedReadLibraryGen();

    private LLVMManagedReadLibraryGen() {
        super(LIBRARY_CLASS, Collections.unmodifiableList(Arrays.asList(IS_READABLE, READ_I8, READ_I16, READ_I32, READ_FLOAT, READ_I64, READ_DOUBLE, READ_POINTER, READ_GENERIC_I64)));
    }

    protected Class<?> getDefaultClass(Object receiver) {
        if (receiver instanceof int[]) {
            return LLVMManagedAccessDefaults.VirtualAlloc.class;
        }
        return LLVMManagedAccessDefaults.FallbackRead.class;
    }

    protected LLVMManagedReadLibrary createProxy(ReflectionLibrary library) {
        return new Proxy(library);
    }

    protected Object genericDispatch(Library originalLib, Object receiver, Message message, Object[] args, int offset) throws Exception {
        LLVMManagedReadLibrary lib = (LLVMManagedReadLibrary)originalLib;
        MessageImpl messageImpl = (MessageImpl)message;
        if (messageImpl.getParameterCount() - 1 != args.length - offset) {
            CompilerDirectives.transferToInterpreter();
            throw new IllegalArgumentException("Invalid number of arguments.");
        }
        switch (messageImpl.index) {
            case 0: {
                return lib.isReadable(receiver);
            }
            case 1: {
                return lib.readI8(receiver, (Long)args[offset]);
            }
            case 2: {
                return lib.readI16(receiver, (Long)args[offset]);
            }
            case 3: {
                return lib.readI32(receiver, (Long)args[offset]);
            }
            case 4: {
                return Float.valueOf(lib.readFloat(receiver, (Long)args[offset]));
            }
            case 5: {
                return lib.readI64(receiver, (Long)args[offset]);
            }
            case 6: {
                return lib.readDouble(receiver, (Long)args[offset]);
            }
            case 7: {
                return lib.readPointer(receiver, (Long)args[offset]);
            }
            case 8: {
                return lib.readGenericI64(receiver, (Long)args[offset]);
            }
        }
        CompilerDirectives.transferToInterpreter();
        throw new AbstractMethodError(message.toString());
    }

    protected LLVMManagedReadLibrary createDispatchImpl(int limit) {
        return new CachedDispatchFirst(null, null, limit);
    }

    protected LLVMManagedReadLibrary createUncachedDispatch() {
        return new UncachedDispatch();
    }

    private static Class<LLVMManagedReadLibrary> lazyLibraryClass() {
        try {
            return Class.forName("com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedReadLibrary", false, LLVMManagedReadLibraryGen.class.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new AssertionError((Object)e);
        }
    }

    static {
        LibraryFactory.register(LIBRARY_CLASS, (LibraryFactory)INSTANCE);
    }

    @GeneratedBy(value=LLVMManagedReadLibrary.class)
    private static abstract class CachedDispatch
    extends LLVMManagedReadLibrary {
        @Node.Child
        LLVMManagedReadLibrary library;
        @Node.Child
        CachedDispatch next;

        CachedDispatch(LLVMManagedReadLibrary library, CachedDispatch next) {
            this.library = library;
            this.next = next;
        }

        abstract int getLimit();

        @Override
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        public boolean isReadable(Object receiver_) {
            while (true) {
                CachedDispatch current = this;
                do {
                    LLVMManagedReadLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.isReadable(receiver_);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        public byte readI8(Object receiver_, long offset) {
            while (true) {
                CachedDispatch current = this;
                do {
                    LLVMManagedReadLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.readI8(receiver_, offset);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        public short readI16(Object receiver_, long offset) {
            while (true) {
                CachedDispatch current = this;
                do {
                    LLVMManagedReadLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.readI16(receiver_, offset);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        public int readI32(Object receiver_, long offset) {
            while (true) {
                CachedDispatch current = this;
                do {
                    LLVMManagedReadLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.readI32(receiver_, offset);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        public float readFloat(Object receiver_, long offset) {
            while (true) {
                CachedDispatch current = this;
                do {
                    LLVMManagedReadLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.readFloat(receiver_, offset);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        public long readI64(Object receiver_, long offset) throws UnexpectedResultException {
            while (true) {
                CachedDispatch current = this;
                do {
                    LLVMManagedReadLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.readI64(receiver_, offset);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        public double readDouble(Object receiver_, long offset) {
            while (true) {
                CachedDispatch current = this;
                do {
                    LLVMManagedReadLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.readDouble(receiver_, offset);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        public LLVMPointer readPointer(Object receiver_, long offset) {
            while (true) {
                CachedDispatch current = this;
                do {
                    LLVMManagedReadLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.readPointer(receiver_, offset);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        public Object readGenericI64(Object receiver_, long offset) {
            while (true) {
                CachedDispatch current = this;
                do {
                    LLVMManagedReadLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.readGenericI64(receiver_, offset);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        public boolean accepts(Object receiver_) {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void specialize(Object receiver_) {
            CachedDispatch current = this;
            LLVMManagedReadLibrary thisLibrary = current.library;
            if (thisLibrary == null) {
                this.library = (LLVMManagedReadLibrary)this.insert((Node)((LLVMManagedReadLibrary)INSTANCE.create(receiver_)));
            } else {
                Lock lock = this.getLock();
                lock.lock();
                try {
                    int count = 0;
                    do {
                        LLVMManagedReadLibrary currentLibrary;
                        if ((currentLibrary = current.library) != null && currentLibrary.accepts(receiver_)) {
                            return;
                        }
                        ++count;
                    } while ((current = current.next) != null);
                    if (count >= this.getLimit()) {
                        this.library = (LLVMManagedReadLibrary)this.insert((Node)new CachedToUncachedDispatch());
                        this.next = null;
                    } else {
                        this.next = (CachedDispatch)this.insert((Node)new CachedDispatchNext((LLVMManagedReadLibrary)INSTANCE.create(receiver_), this.next));
                    }
                }
                finally {
                    lock.unlock();
                }
            }
        }
    }

    @GeneratedBy(value=LLVMManagedReadLibrary.class)
    private static final class CachedDispatchFirst
    extends CachedDispatch {
        private final int limit_;

        CachedDispatchFirst(LLVMManagedReadLibrary library, CachedDispatch next, int limit_) {
            super(library, next);
            this.limit_ = limit_;
        }

        @Override
        int getLimit() {
            return this.limit_;
        }

        public NodeCost getCost() {
            if (this.library instanceof CachedToUncachedDispatch) {
                return NodeCost.MEGAMORPHIC;
            }
            CachedDispatch current = this;
            int count = 0;
            do {
                if (current.library == null) continue;
                ++count;
            } while ((current = current.next) != null);
            return NodeCost.fromCount((int)count);
        }
    }

    @GeneratedBy(value=LLVMManagedReadLibrary.class)
    private static final class CachedDispatchNext
    extends CachedDispatch {
        CachedDispatchNext(LLVMManagedReadLibrary library, CachedDispatch next) {
            super(library, next);
        }

        @Override
        int getLimit() {
            throw new AssertionError();
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }
    }

    @GeneratedBy(value=LLVMManagedReadLibrary.class)
    private static final class UncachedDispatch
    extends LLVMManagedReadLibrary {
        private UncachedDispatch() {
        }

        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean isReadable(Object receiver_) {
            return ((LLVMManagedReadLibrary)INSTANCE.getUncached(receiver_)).isReadable(receiver_);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public byte readI8(Object receiver_, long offset) {
            return ((LLVMManagedReadLibrary)INSTANCE.getUncached(receiver_)).readI8(receiver_, offset);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public short readI16(Object receiver_, long offset) {
            return ((LLVMManagedReadLibrary)INSTANCE.getUncached(receiver_)).readI16(receiver_, offset);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public int readI32(Object receiver_, long offset) {
            return ((LLVMManagedReadLibrary)INSTANCE.getUncached(receiver_)).readI32(receiver_, offset);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public float readFloat(Object receiver_, long offset) {
            return ((LLVMManagedReadLibrary)INSTANCE.getUncached(receiver_)).readFloat(receiver_, offset);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public long readI64(Object receiver_, long offset) throws UnexpectedResultException {
            return ((LLVMManagedReadLibrary)INSTANCE.getUncached(receiver_)).readI64(receiver_, offset);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public double readDouble(Object receiver_, long offset) {
            return ((LLVMManagedReadLibrary)INSTANCE.getUncached(receiver_)).readDouble(receiver_, offset);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public LLVMPointer readPointer(Object receiver_, long offset) {
            return ((LLVMManagedReadLibrary)INSTANCE.getUncached(receiver_)).readPointer(receiver_, offset);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public Object readGenericI64(Object receiver_, long offset) {
            return ((LLVMManagedReadLibrary)INSTANCE.getUncached(receiver_)).readGenericI64(receiver_, offset);
        }

        @CompilerDirectives.TruffleBoundary
        public boolean accepts(Object receiver_) {
            return true;
        }

        public boolean isAdoptable() {
            return false;
        }
    }

    @GeneratedBy(value=LLVMManagedReadLibrary.class)
    private static final class CachedToUncachedDispatch
    extends LLVMManagedReadLibrary {
        private CachedToUncachedDispatch() {
        }

        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean isReadable(Object receiver_) {
            assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this.getParent());
            try {
                boolean bl = ((LLVMManagedReadLibrary)INSTANCE.getUncached(receiver_)).isReadable(receiver_);
                return bl;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public byte readI8(Object receiver_, long offset) {
            assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this.getParent());
            try {
                byte by = ((LLVMManagedReadLibrary)INSTANCE.getUncached(receiver_)).readI8(receiver_, offset);
                return by;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public short readI16(Object receiver_, long offset) {
            assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this.getParent());
            try {
                short s = ((LLVMManagedReadLibrary)INSTANCE.getUncached(receiver_)).readI16(receiver_, offset);
                return s;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public int readI32(Object receiver_, long offset) {
            assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this.getParent());
            try {
                int n = ((LLVMManagedReadLibrary)INSTANCE.getUncached(receiver_)).readI32(receiver_, offset);
                return n;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public float readFloat(Object receiver_, long offset) {
            assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this.getParent());
            try {
                float f = ((LLVMManagedReadLibrary)INSTANCE.getUncached(receiver_)).readFloat(receiver_, offset);
                return f;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public long readI64(Object receiver_, long offset) throws UnexpectedResultException {
            assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this.getParent());
            try {
                long l = ((LLVMManagedReadLibrary)INSTANCE.getUncached(receiver_)).readI64(receiver_, offset);
                return l;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public double readDouble(Object receiver_, long offset) {
            assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this.getParent());
            try {
                double d = ((LLVMManagedReadLibrary)INSTANCE.getUncached(receiver_)).readDouble(receiver_, offset);
                return d;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public LLVMPointer readPointer(Object receiver_, long offset) {
            assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this.getParent());
            try {
                LLVMPointer lLVMPointer = ((LLVMManagedReadLibrary)INSTANCE.getUncached(receiver_)).readPointer(receiver_, offset);
                return lLVMPointer;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public Object readGenericI64(Object receiver_, long offset) {
            assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this.getParent());
            try {
                Object object = ((LLVMManagedReadLibrary)INSTANCE.getUncached(receiver_)).readGenericI64(receiver_, offset);
                return object;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        public boolean accepts(Object receiver_) {
            return true;
        }
    }

    @GeneratedBy(value=LLVMManagedReadLibrary.class)
    private static final class Proxy
    extends LLVMManagedReadLibrary {
        @Node.Child
        private ReflectionLibrary lib;

        Proxy(ReflectionLibrary lib) {
            this.lib = lib;
        }

        @Override
        public boolean isReadable(Object receiver_) {
            try {
                return (Boolean)this.lib.send(receiver_, IS_READABLE, new Object[0]);
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                CompilerDirectives.transferToInterpreter();
                throw new AssertionError((Object)e_);
            }
        }

        @Override
        public byte readI8(Object receiver_, long offset) {
            try {
                return (Byte)this.lib.send(receiver_, READ_I8, new Object[]{offset});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                CompilerDirectives.transferToInterpreter();
                throw new AssertionError((Object)e_);
            }
        }

        @Override
        public short readI16(Object receiver_, long offset) {
            try {
                return (Short)this.lib.send(receiver_, READ_I16, new Object[]{offset});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                CompilerDirectives.transferToInterpreter();
                throw new AssertionError((Object)e_);
            }
        }

        @Override
        public int readI32(Object receiver_, long offset) {
            try {
                return (Integer)this.lib.send(receiver_, READ_I32, new Object[]{offset});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                CompilerDirectives.transferToInterpreter();
                throw new AssertionError((Object)e_);
            }
        }

        @Override
        public float readFloat(Object receiver_, long offset) {
            try {
                return ((Float)this.lib.send(receiver_, READ_FLOAT, new Object[]{offset})).floatValue();
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                CompilerDirectives.transferToInterpreter();
                throw new AssertionError((Object)e_);
            }
        }

        @Override
        public long readI64(Object receiver_, long offset) throws UnexpectedResultException {
            try {
                return (Long)this.lib.send(receiver_, READ_I64, new Object[]{offset});
            }
            catch (UnexpectedResultException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                CompilerDirectives.transferToInterpreter();
                throw new AssertionError((Object)e_);
            }
        }

        @Override
        public double readDouble(Object receiver_, long offset) {
            try {
                return (Double)this.lib.send(receiver_, READ_DOUBLE, new Object[]{offset});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                CompilerDirectives.transferToInterpreter();
                throw new AssertionError((Object)e_);
            }
        }

        @Override
        public LLVMPointer readPointer(Object receiver_, long offset) {
            try {
                return (LLVMPointer)this.lib.send(receiver_, READ_POINTER, new Object[]{offset});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                CompilerDirectives.transferToInterpreter();
                throw new AssertionError((Object)e_);
            }
        }

        @Override
        public Object readGenericI64(Object receiver_, long offset) {
            try {
                return this.lib.send(receiver_, READ_GENERIC_I64, new Object[]{offset});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                CompilerDirectives.transferToInterpreter();
                throw new AssertionError((Object)e_);
            }
        }

        public boolean accepts(Object receiver_) {
            return this.lib.accepts(receiver_);
        }
    }

    @GeneratedBy(value=LLVMManagedReadLibrary.class)
    private static class MessageImpl
    extends Message {
        final int index;

        MessageImpl(String name, int index, Class<?> returnType, Class<?> ... parameters) {
            super(LIBRARY_CLASS, name, returnType, (Class[])parameters);
            this.index = index;
        }
    }
}

