/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.memory;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.llvm.runtime.LLVMIVarBit;
import com.oracle.truffle.llvm.runtime.floating.LLVM80BitFloat;
import com.oracle.truffle.llvm.runtime.memory.LLVMMemory;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import java.lang.reflect.Field;
import java.util.function.IntBinaryOperator;
import java.util.function.LongBinaryOperator;
import sun.misc.Unsafe;

public final class LLVMNativeMemory
extends LLVMMemory {
    private static final long DEREF_HANDLE_OBJECT_SIZE = 0x100000L;
    private static final long DEREF_HANDLE_SPACE_START = Long.MIN_VALUE;
    public static final long DEREF_HANDLE_SPACE_END = -4611686018427387904L;
    private static final long HANDLE_SPACE_START = -4611686018427387904L;
    private static final long HANDLE_SPACE_END = -3458764513820540928L;
    private static final Unsafe unsafe = LLVMNativeMemory.getUnsafe();
    private final HandleContainer derefHandleContainer = new DerefHandleContainer(Long.MIN_VALUE, -4611686018427387904L, 0x100000L);
    private final HandleContainer handleContainer = new CommonHandleContainer(-4611686018427387904L, -3458764513820540928L, 8L);
    private final Assumption noDerefHandleAssumption = Truffle.getRuntime().createAssumption("no deref handle assumption");
    private static final LLVMNativeMemory INSTANCE = new LLVMNativeMemory();

    private static Unsafe getUnsafe() {
        CompilerAsserts.neverPartOfCompilation();
        try {
            Field theUnsafe = Unsafe.class.getDeclaredField("theUnsafe");
            theUnsafe.setAccessible(true);
            return (Unsafe)theUnsafe.get(null);
        }
        catch (Exception e) {
            throw new AssertionError();
        }
    }

    @Deprecated
    public static LLVMNativeMemory getInstance() {
        return INSTANCE;
    }

    private LLVMNativeMemory() {
    }

    private static boolean checkPointer(long ptr) {
        assert (ptr > 0x100000L) : "trying to access invalid address: " + ptr + " 0x" + Long.toHexString(ptr);
        return true;
    }

    @Override
    @Deprecated
    public void memset(LLVMNativePointer address, long size, byte value) {
        assert (size == 0L || LLVMNativeMemory.checkPointer(address.asNative()));
        try {
            unsafe.setMemory(address.asNative(), size, value);
        }
        catch (Throwable e) {
            CompilerDirectives.transferToInterpreter();
            throw e;
        }
    }

    @Override
    @Deprecated
    public void copyMemory(long sourceAddress, long targetAddress, long length) {
        assert (length == 0L || LLVMNativeMemory.checkPointer(sourceAddress) && LLVMNativeMemory.checkPointer(targetAddress));
        unsafe.copyMemory(sourceAddress, targetAddress, length);
    }

    @Override
    public void free(long address) {
        if (!this.noDerefHandleAssumption.isValid() && this.derefHandleContainer.accept(address)) {
            this.derefHandleContainer.free(address);
        } else if (this.handleContainer.accept(address)) {
            this.handleContainer.free(address);
        } else {
            try {
                unsafe.freeMemory(address);
            }
            catch (Throwable e) {
                CompilerDirectives.transferToInterpreter();
                throw e;
            }
        }
    }

    @Override
    public LLVMNativePointer allocateMemory(long size) {
        try {
            return LLVMNativePointer.create(unsafe.allocateMemory(size));
        }
        catch (Throwable e) {
            CompilerDirectives.transferToInterpreter();
            throw e;
        }
    }

    @Override
    @Deprecated
    public LLVMNativePointer reallocateMemory(LLVMNativePointer addr, long size) {
        try {
            return LLVMNativePointer.create(unsafe.reallocateMemory(addr.asNative(), size));
        }
        catch (Throwable e) {
            CompilerDirectives.transferToInterpreter();
            throw e;
        }
    }

    @Override
    public long allocateHandle(boolean autoDeref) {
        if (autoDeref) {
            this.noDerefHandleAssumption.invalidate();
            return this.derefHandleContainer.allocate();
        }
        return this.handleContainer.allocate();
    }

    @Override
    public boolean getI1(long ptr) {
        assert (LLVMNativeMemory.checkPointer(ptr));
        return unsafe.getByte(ptr) != 0;
    }

    @Override
    public byte getI8(long ptr) {
        assert (LLVMNativeMemory.checkPointer(ptr));
        return unsafe.getByte(ptr);
    }

    @Override
    public short getI16(long ptr) {
        assert (LLVMNativeMemory.checkPointer(ptr));
        return unsafe.getShort(ptr);
    }

    @Override
    public int getI32(long ptr) {
        assert (LLVMNativeMemory.checkPointer(ptr));
        return unsafe.getInt(ptr);
    }

    @Override
    public LLVMIVarBit getIVarBit(LLVMNativePointer addr, int bitWidth) {
        if (bitWidth % 8 != 0) {
            CompilerDirectives.transferToInterpreter();
            throw new AssertionError();
        }
        int bytes = bitWidth / 8;
        byte[] loadedBytes = new byte[bytes];
        long currentAddressPtr = addr.asNative();
        for (int i = loadedBytes.length - 1; i >= 0; --i) {
            loadedBytes[i] = this.getI8(currentAddressPtr);
            ++currentAddressPtr;
        }
        return LLVMIVarBit.create(bitWidth, loadedBytes, bitWidth, false);
    }

    @Override
    public long getI64(long ptr) {
        assert (LLVMNativeMemory.checkPointer(ptr));
        return unsafe.getLong(ptr);
    }

    @Override
    public float getFloat(long ptr) {
        assert (LLVMNativeMemory.checkPointer(ptr));
        return unsafe.getFloat(ptr);
    }

    @Override
    public double getDouble(long ptr) {
        assert (LLVMNativeMemory.checkPointer(ptr));
        return unsafe.getDouble(ptr);
    }

    @Override
    public LLVM80BitFloat get80BitFloat(LLVMNativePointer addr) {
        byte[] bytes = new byte[10];
        long currentPtr = addr.asNative();
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = this.getI8(currentPtr);
            ++currentPtr;
        }
        return LLVM80BitFloat.fromBytes(bytes);
    }

    @Override
    public LLVMNativePointer getPointer(long ptr) {
        assert (LLVMNativeMemory.checkPointer(ptr));
        return LLVMNativePointer.create(unsafe.getAddress(ptr));
    }

    @Override
    public void putI1(long ptr, boolean value) {
        assert (LLVMNativeMemory.checkPointer(ptr));
        unsafe.putByte(ptr, (byte)(value ? 1 : 0));
    }

    @Override
    public void putI8(long ptr, byte value) {
        assert (LLVMNativeMemory.checkPointer(ptr));
        unsafe.putByte(ptr, value);
    }

    @Override
    public void putI16(long ptr, short value) {
        assert (LLVMNativeMemory.checkPointer(ptr));
        unsafe.putShort(ptr, value);
    }

    @Override
    public void putI32(long ptr, int value) {
        assert (LLVMNativeMemory.checkPointer(ptr));
        unsafe.putInt(ptr, value);
    }

    @Override
    public void putI64(long ptr, long value) {
        assert (LLVMNativeMemory.checkPointer(ptr));
        unsafe.putLong(ptr, value);
    }

    @Override
    public void putIVarBit(LLVMNativePointer addr, LLVMIVarBit value) {
        byte[] bytes = value.getBytes();
        long currentptr = addr.asNative();
        for (int i = bytes.length - 1; i >= 0; --i) {
            this.putI8(currentptr, bytes[i]);
            ++currentptr;
        }
    }

    @Override
    public void putByteArray(long ptr, byte[] bytes) {
        long currentptr = ptr;
        for (int i = 0; i < bytes.length; ++i) {
            this.putI8(currentptr, bytes[i]);
            ++currentptr;
        }
    }

    @Override
    public void putFloat(long ptr, float value) {
        assert (LLVMNativeMemory.checkPointer(ptr));
        unsafe.putFloat(ptr, value);
    }

    @Override
    public void putDouble(long ptr, double value) {
        assert (LLVMNativeMemory.checkPointer(ptr));
        unsafe.putDouble(ptr, value);
    }

    @Override
    public void put80BitFloat(long ptr, LLVM80BitFloat value) {
        this.putByteArray(ptr, value.getBytes());
    }

    @Override
    public void putPointer(long ptr, long ptrValue) {
        assert (ptr != 0L);
        unsafe.putAddress(ptr, ptrValue);
    }

    @Override
    public LLVMMemory.CMPXCHGI32 compareAndSwapI32(LLVMNativePointer p, int comparisonValue, int newValue) {
        boolean b;
        int t;
        assert (LLVMNativeMemory.checkPointer(p.asNative()));
        do {
            if (!CompilerDirectives.injectBranchProbability((double)0.75, (boolean)(b = unsafe.compareAndSwapInt(null, p.asNative(), comparisonValue, newValue)))) continue;
            return new LLVMMemory.CMPXCHGI32(comparisonValue, b);
        } while (CompilerDirectives.injectBranchProbability((double)0.25, ((t = unsafe.getIntVolatile(null, p.asNative())) == comparisonValue ? 1 : 0) != 0));
        return new LLVMMemory.CMPXCHGI32(t, b);
    }

    @Override
    public LLVMMemory.CMPXCHGI64 compareAndSwapI64(LLVMNativePointer p, long comparisonValue, long newValue) {
        boolean b;
        long t;
        assert (LLVMNativeMemory.checkPointer(p.asNative()));
        do {
            if (!CompilerDirectives.injectBranchProbability((double)0.75, (boolean)(b = unsafe.compareAndSwapLong(null, p.asNative(), comparisonValue, newValue)))) continue;
            return new LLVMMemory.CMPXCHGI64(comparisonValue, b);
        } while (CompilerDirectives.injectBranchProbability((double)0.25, ((t = unsafe.getLongVolatile(null, p.asNative())) == comparisonValue ? 1 : 0) != 0));
        return new LLVMMemory.CMPXCHGI64(t, b);
    }

    private static long alignToI32(long address) {
        long mask = 3L;
        return address & (mask ^ 0xFFFFFFFFFFFFFFFFL);
    }

    private static int getI8Index(long address) {
        long mask = 3L;
        return (int)(address & mask);
    }

    private static byte getI8At(int value, int index) {
        return (byte)(value >> 8 * index & 0xFF);
    }

    private static int replaceI8(int index, int value, byte replaceByte) {
        return value & ~(255 << index * 8) | (replaceByte & 0xFF) << index * 8;
    }

    @Override
    public LLVMMemory.CMPXCHGI8 compareAndSwapI8(LLVMNativePointer p, byte comparisonValue, byte newValue) {
        int newVal;
        int t;
        boolean c;
        assert (LLVMNativeMemory.checkPointer(p.asNative()));
        int byteIndex = LLVMNativeMemory.getI8Index(p.asNative());
        long address = LLVMNativeMemory.alignToI32(p.asNative());
        do {
            byte b;
            if (!CompilerDirectives.injectBranchProbability((double)0.75, ((b = LLVMNativeMemory.getI8At(t = unsafe.getIntVolatile(null, address), byteIndex)) != comparisonValue ? 1 : 0) != 0)) continue;
            return new LLVMMemory.CMPXCHGI8(b, false);
        } while (!CompilerDirectives.injectBranchProbability((double)0.75, (boolean)(c = unsafe.compareAndSwapInt(null, address, t, newVal = LLVMNativeMemory.replaceI8(byteIndex, t, newValue)))));
        return new LLVMMemory.CMPXCHGI8(comparisonValue, true);
    }

    private static int getI16Index(long address) {
        long mask = 3L;
        return (int)(address & mask) >> 1;
    }

    private static short getI16At(int value, int index) {
        return (short)(value >> 16 * index & 0xFFFF);
    }

    private static int replaceI16(int index, int value, short replace) {
        return value & ~(65535 << index * 16) | (replace & 0xFFFF) << index * 16;
    }

    @Override
    public LLVMMemory.CMPXCHGI16 compareAndSwapI16(LLVMNativePointer p, short comparisonValue, short newValue) {
        int newVal;
        int t;
        boolean c;
        assert (LLVMNativeMemory.checkPointer(p.asNative()));
        int idx = LLVMNativeMemory.getI16Index(p.asNative());
        long address = LLVMNativeMemory.alignToI32(p.asNative());
        do {
            short b;
            if (!CompilerDirectives.injectBranchProbability((double)0.75, ((b = LLVMNativeMemory.getI16At(t = unsafe.getIntVolatile(null, address), idx)) != comparisonValue ? 1 : 0) != 0)) continue;
            return new LLVMMemory.CMPXCHGI16(b, false);
        } while (!CompilerDirectives.injectBranchProbability((double)0.75, (boolean)(c = unsafe.compareAndSwapInt(null, address, t, newVal = LLVMNativeMemory.replaceI16(idx, t, newValue)))));
        return new LLVMMemory.CMPXCHGI16(comparisonValue, true);
    }

    @Override
    public long getAndSetI64(LLVMNativePointer address, long value) {
        assert (LLVMNativeMemory.checkPointer(address.asNative()));
        return unsafe.getAndSetLong(null, address.asNative(), value);
    }

    @Override
    public long getAndAddI64(LLVMNativePointer address, long value) {
        assert (LLVMNativeMemory.checkPointer(address.asNative()));
        return unsafe.getAndAddLong(null, address.asNative(), value);
    }

    @Override
    public long getAndSubI64(LLVMNativePointer address, long value) {
        assert (LLVMNativeMemory.checkPointer(address.asNative()));
        return unsafe.getAndAddLong(null, address.asNative(), -value);
    }

    @Override
    public long getAndOpI64(LLVMNativePointer address, long value, LongBinaryOperator f) {
        long nevv;
        long old;
        assert (LLVMNativeMemory.checkPointer(address.asNative()));
        long addr = address.asNative();
        while (!unsafe.compareAndSwapLong(null, addr, old = this.getI64(address), nevv = f.applyAsLong(old, value))) {
        }
        return old;
    }

    @Override
    public int getAndSetI32(LLVMNativePointer address, int value) {
        assert (LLVMNativeMemory.checkPointer(address.asNative()));
        return unsafe.getAndSetInt(null, address.asNative(), value);
    }

    @Override
    public int getAndAddI32(LLVMNativePointer address, int value) {
        assert (LLVMNativeMemory.checkPointer(address.asNative()));
        return unsafe.getAndAddInt(null, address.asNative(), value);
    }

    @Override
    public int getAndSubI32(LLVMNativePointer address, int value) {
        assert (LLVMNativeMemory.checkPointer(address.asNative()));
        return unsafe.getAndAddInt(null, address.asNative(), -value);
    }

    @Override
    public int getAndOpI32(LLVMNativePointer address, int value, IntBinaryOperator f) {
        int nevv;
        int old;
        assert (LLVMNativeMemory.checkPointer(address.asNative()));
        long addr = address.asNative();
        while (!unsafe.compareAndSwapInt(null, addr, old = this.getI32(address), nevv = f.applyAsInt(old, value))) {
        }
        return old;
    }

    @Override
    public short getAndOpI16(LLVMNativePointer address, short value, LLVMMemory.ShortBinaryOperator f) {
        short nevv;
        short old;
        while (!this.compareAndSwapI16(address, old = this.getI16(address), nevv = f.apply(old, value)).isSwap()) {
        }
        return old;
    }

    @Override
    public byte getAndOpI8(LLVMNativePointer address, byte value, LLVMMemory.ByteBinaryOperator f) {
        byte nevv;
        byte old;
        while (!this.compareAndSwapI8(address, old = this.getI8(address), nevv = f.apply(old, value)).isSwap()) {
        }
        return old;
    }

    @Override
    public boolean getAndOpI1(LLVMNativePointer address, boolean value, LLVMMemory.BooleanBinaryOperator f) {
        boolean nevv;
        byte old;
        while (!this.compareAndSwapI8(address, old, (byte)((nevv = f.apply((old = this.getI8(address)) != 0, value)) ? 1 : 0)).isSwap()) {
        }
        return old != 0;
    }

    @Override
    public void fullFence() {
        unsafe.fullFence();
    }

    @Override
    public boolean isHandleMemory(long addr) {
        return addr < -3458764513820540928L;
    }

    @Override
    public boolean isDerefHandleMemory(long addr) {
        return !this.noDerefHandleAssumption.isValid() && this.derefHandleContainer.accept(addr);
    }

    public static long getDerefHandleObjectMask() {
        return 1048575L;
    }

    private static final class CommonHandleContainer
    extends HandleContainer {
        CommonHandleContainer(long startAddr, long endAddr, long objectSize) {
            super(startAddr, endAddr, objectSize);
        }

        @Override
        boolean accept(long address) {
            return this.rangeStart <= address && address < this.rangeEnd;
        }
    }

    private static final class DerefHandleContainer
    extends HandleContainer {
        DerefHandleContainer(long startAddr, long endAddr, long objectSize) {
            super(startAddr, endAddr, objectSize);
        }

        @Override
        boolean accept(long address) {
            return address < this.rangeEnd;
        }
    }

    private static abstract class HandleContainer {
        protected final long rangeStart;
        protected final long rangeEnd;
        protected final long objectSize;
        private long top;
        private FreeListNode freeList;
        private final Object freeListLock = new Object();
        private final Object topLock = new Object();

        HandleContainer(long startAddr, long endAddr, long objectSize) {
            this.rangeStart = startAddr;
            this.rangeEnd = endAddr;
            this.top = startAddr;
            assert (HandleContainer.isPowerOfTwo(objectSize));
            this.objectSize = objectSize;
        }

        abstract boolean accept(long var1);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        long allocate() {
            Object object = this.freeListLock;
            synchronized (object) {
                if (this.freeList != null) {
                    FreeListNode n = this.freeList;
                    this.freeList = n.next;
                    return n.address;
                }
            }
            object = this.topLock;
            synchronized (object) {
                long addr = this.top;
                assert (this.top >= this.rangeStart);
                this.top += this.objectSize;
                if (!this.accept(this.top)) {
                    CompilerDirectives.transferToInterpreter();
                    throw new OutOfMemoryError();
                }
                return addr;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean isAllocated(long address) {
            Object object = this.topLock;
            synchronized (object) {
                if (address < this.rangeStart || address >= this.top) {
                    return false;
                }
            }
            object = this.freeListLock;
            synchronized (object) {
                FreeListNode cur = this.freeList;
                while (cur != null) {
                    if (cur.address == address) {
                        return false;
                    }
                    cur = cur.next;
                }
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        void free(long address) {
            if (!this.isAllocated(address)) {
                throw new IllegalStateException("double-free of " + Long.toHexString(address));
            }
            Object object = this.freeListLock;
            synchronized (object) {
                this.freeList = new FreeListNode(address & (this.getObjectMask() ^ 0xFFFFFFFFFFFFFFFFL), this.freeList);
            }
        }

        private long getObjectMask() {
            return this.objectSize - 1L;
        }

        static boolean isPowerOfTwo(long x) {
            return x > 0L && (x & x - 1L) == 0L;
        }

        protected static final class FreeListNode {
            private final long address;
            private final FreeListNode next;

            protected FreeListNode(long address, FreeListNode next) {
                this.address = address;
                this.next = next;
            }
        }
    }
}

