/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.api;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.GenerateWrapper;
import com.oracle.truffle.api.instrumentation.InstrumentableNode;
import com.oracle.truffle.api.instrumentation.ProbeNode;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.LLVMIVarBit;
import com.oracle.truffle.llvm.runtime.floating.LLVM80BitFloat;
import com.oracle.truffle.llvm.runtime.interop.LLVMInternalTruffleObject;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNodeWrapper;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMInstrumentableNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypesGen;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.runtime.vector.LLVMDoubleVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMFloatVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI16Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI1Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI32Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI64Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI8Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMPointerVector;

@GenerateWrapper
public abstract class LLVMExpressionNode
extends LLVMInstrumentableNode {
    public static final LLVMExpressionNode[] NO_EXPRESSIONS = new LLVMExpressionNode[0];

    @GenerateWrapper.OutgoingConverter
    Object convertOutgoing(Object object) {
        return null;
    }

    public abstract Object executeGeneric(VirtualFrame var1);

    public LLVM80BitFloat executeLLVM80BitFloat(VirtualFrame frame) throws UnexpectedResultException {
        return LLVMTypesGen.expectLLVM80BitFloat(this.executeGeneric(frame));
    }

    public LLVMPointer executeLLVMPointer(VirtualFrame frame) throws UnexpectedResultException {
        return LLVMTypesGen.expectLLVMPointer(this.executeGeneric(frame));
    }

    public LLVMNativePointer executeLLVMNativePointer(VirtualFrame frame) throws UnexpectedResultException {
        return LLVMTypesGen.expectLLVMNativePointer(this.executeGeneric(frame));
    }

    public LLVMManagedPointer executeLLVMManagedPointer(VirtualFrame frame) throws UnexpectedResultException {
        return LLVMTypesGen.expectLLVMManagedPointer(this.executeGeneric(frame));
    }

    public double executeDouble(VirtualFrame frame) throws UnexpectedResultException {
        return LLVMTypesGen.expectDouble(this.executeGeneric(frame));
    }

    public float executeFloat(VirtualFrame frame) throws UnexpectedResultException {
        return LLVMTypesGen.expectFloat(this.executeGeneric(frame));
    }

    public short executeI16(VirtualFrame frame) throws UnexpectedResultException {
        return LLVMTypesGen.expectShort(this.executeGeneric(frame));
    }

    public boolean executeI1(VirtualFrame frame) throws UnexpectedResultException {
        return LLVMTypesGen.expectBoolean(this.executeGeneric(frame));
    }

    public int executeI32(VirtualFrame frame) throws UnexpectedResultException {
        return LLVMTypesGen.expectInteger(this.executeGeneric(frame));
    }

    public long executeI64(VirtualFrame frame) throws UnexpectedResultException {
        return LLVMTypesGen.expectLong(this.executeGeneric(frame));
    }

    public LLVMIVarBit executeLLVMIVarBit(VirtualFrame frame) throws UnexpectedResultException {
        return LLVMTypesGen.expectLLVMIVarBit(this.executeGeneric(frame));
    }

    public byte executeI8(VirtualFrame frame) throws UnexpectedResultException {
        return LLVMTypesGen.expectByte(this.executeGeneric(frame));
    }

    public LLVMI8Vector executeLLVMI8Vector(VirtualFrame frame) throws UnexpectedResultException {
        return LLVMTypesGen.expectLLVMI8Vector(this.executeGeneric(frame));
    }

    public LLVMI64Vector executeLLVMI64Vector(VirtualFrame frame) throws UnexpectedResultException {
        return LLVMTypesGen.expectLLVMI64Vector(this.executeGeneric(frame));
    }

    public LLVMI32Vector executeLLVMI32Vector(VirtualFrame frame) throws UnexpectedResultException {
        return LLVMTypesGen.expectLLVMI32Vector(this.executeGeneric(frame));
    }

    public LLVMI1Vector executeLLVMI1Vector(VirtualFrame frame) throws UnexpectedResultException {
        return LLVMTypesGen.expectLLVMI1Vector(this.executeGeneric(frame));
    }

    public LLVMI16Vector executeLLVMI16Vector(VirtualFrame frame) throws UnexpectedResultException {
        return LLVMTypesGen.expectLLVMI16Vector(this.executeGeneric(frame));
    }

    public LLVMFloatVector executeLLVMFloatVector(VirtualFrame frame) throws UnexpectedResultException {
        return LLVMTypesGen.expectLLVMFloatVector(this.executeGeneric(frame));
    }

    public LLVMDoubleVector executeLLVMDoubleVector(VirtualFrame frame) throws UnexpectedResultException {
        return LLVMTypesGen.expectLLVMDoubleVector(this.executeGeneric(frame));
    }

    public LLVMPointerVector executeLLVMPointerVector(VirtualFrame frame) throws UnexpectedResultException {
        return LLVMTypesGen.expectLLVMPointerVector(this.executeGeneric(frame));
    }

    public String getSourceDescription() {
        return this.getRootNode().getName();
    }

    public InstrumentableNode.WrapperNode createWrapper(ProbeNode probe) {
        return new LLVMExpressionNodeWrapper(this, probe);
    }

    public static boolean notLLVM(Object object) {
        return !(object instanceof LLVMInternalTruffleObject) && !LLVMPointer.isInstance(object);
    }
}

