/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.api;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.TypeSystemReference;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMFunctionDescriptor;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.datalayout.DataLayout;
import com.oracle.truffle.llvm.runtime.memory.LLVMMemory;
import com.oracle.truffle.llvm.runtime.memory.UnsafeArrayAccess;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMHasDatalayoutNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.options.SulongEngineOption;
import java.io.PrintStream;

@TypeSystemReference(value=LLVMTypes.class)
public abstract class LLVMNode
extends Node {
    public static final int DOUBLE_SIZE_IN_BYTES = 8;
    public static final int FLOAT_SIZE_IN_BYTES = 4;
    public static final int I16_SIZE_IN_BYTES = 2;
    public static final int I16_SIZE_IN_BITS = 16;
    public static final int I16_MASK = 65535;
    public static final int I32_SIZE_IN_BYTES = 4;
    public static final int I32_SIZE_IN_BITS = 32;
    public static final long I32_MASK = 0xFFFFFFFFL;
    public static final int I64_SIZE_IN_BYTES = 8;
    public static final int I64_SIZE_IN_BITS = 64;
    public static final int I8_SIZE_IN_BYTES = 1;
    public static final int I8_SIZE_IN_BITS = 8;
    public static final int I8_MASK = 255;
    public static final int I1_SIZE_IN_BYTES = 1;
    public static final int ADDRESS_SIZE_IN_BYTES = 8;

    public static LLVMMemory getLLVMMemory() {
        CompilerAsserts.neverPartOfCompilation();
        return LLVMLanguage.getLanguage().getCapability(LLVMMemory.class);
    }

    public static UnsafeArrayAccess getUnsafeArrayAccess() {
        CompilerAsserts.neverPartOfCompilation();
        return LLVMLanguage.getLanguage().getCapability(UnsafeArrayAccess.class);
    }

    protected static PrintStream nativeCallStatisticsStream(TruffleLanguage.ContextReference<LLVMContext> context) {
        CompilerAsserts.neverPartOfCompilation();
        return SulongEngineOption.getStream((String)((LLVMContext)context.get()).getEnv().getOptions().get(SulongEngineOption.NATIVE_CALL_STATS));
    }

    protected static boolean nativeCallStatisticsEnabled(TruffleLanguage.ContextReference<LLVMContext> context) {
        CompilerAsserts.neverPartOfCompilation();
        return SulongEngineOption.isTrue((String)((LLVMContext)context.get()).getEnv().getOptions().get(SulongEngineOption.NATIVE_CALL_STATS));
    }

    protected static boolean isFunctionDescriptor(Object object) {
        return object instanceof LLVMFunctionDescriptor;
    }

    protected static LLVMFunctionDescriptor asFunctionDescriptor(Object object) {
        return object instanceof LLVMFunctionDescriptor ? (LLVMFunctionDescriptor)object : null;
    }

    protected static boolean isSameObject(Object a, Object b) {
        return a == b;
    }

    public final DataLayout getDataLayout() {
        LLVMNode datalayoutNode = this;
        while (!(datalayoutNode instanceof LLVMHasDatalayoutNode)) {
            if (datalayoutNode.getParent() != null) {
                assert (!(datalayoutNode instanceof RootNode)) : "root node must not have a parent";
                datalayoutNode = datalayoutNode.getParent();
                continue;
            }
            return LLVMLanguage.getContext().getLibsulongDataLayout();
        }
        return ((LLVMHasDatalayoutNode)((Object)datalayoutNode)).getDatalayout();
    }
}

