/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.asm;

import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMStatementNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.support.LLVMAMD64UpdateFlagsNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.support.LLVMAMD64WriteBooleanNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.support.LLVMAMD64WriteTupelNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.support.LLVMAMD64WriteValueNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.support.LongMultiplication;

public abstract class LLVMAMD64MulNode
extends LLVMStatementNode {
    @Node.Child
    protected LLVMAMD64WriteBooleanNode writeCFNode;
    @Node.Child
    protected LLVMAMD64WriteBooleanNode writePFNode;
    @Node.Child
    protected LLVMAMD64WriteBooleanNode writeAFNode;
    @Node.Child
    protected LLVMAMD64WriteBooleanNode writeZFNode;
    @Node.Child
    protected LLVMAMD64WriteBooleanNode writeSFNode;
    @Node.Child
    protected LLVMAMD64WriteBooleanNode writeOFNode;

    protected void setFlags(VirtualFrame frame, byte value, boolean overflow, boolean sign) {
        this.writeCFNode.execute(frame, overflow);
        this.writePFNode.execute(frame, LLVMAMD64UpdateFlagsNode.getParity(value));
        this.writeAFNode.execute(frame, false);
        this.writeZFNode.execute(frame, false);
        this.writeSFNode.execute(frame, sign);
        this.writeOFNode.execute(frame, overflow);
    }

    public LLVMAMD64MulNode(LLVMAMD64WriteBooleanNode writeCFNode, LLVMAMD64WriteBooleanNode writePFNode, LLVMAMD64WriteBooleanNode writeAFNode, LLVMAMD64WriteBooleanNode writeZFNode, LLVMAMD64WriteBooleanNode writeSFNode, LLVMAMD64WriteBooleanNode writeOFNode) {
        this.writeCFNode = writeCFNode;
        this.writePFNode = writePFNode;
        this.writeAFNode = writeAFNode;
        this.writeZFNode = writeZFNode;
        this.writeSFNode = writeSFNode;
        this.writeOFNode = writeOFNode;
    }

    @NodeChildren(value={@NodeChild(value="left", type=LLVMExpressionNode.class), @NodeChild(value="right", type=LLVMExpressionNode.class)})
    public static abstract class LLVMAMD64MulqNode
    extends LLVMAMD64MulNode {
        @Node.Child
        private LLVMAMD64WriteTupelNode out;

        public LLVMAMD64MulqNode(LLVMAMD64WriteBooleanNode writeCFNode, LLVMAMD64WriteBooleanNode writePFNode, LLVMAMD64WriteBooleanNode writeAFNode, LLVMAMD64WriteBooleanNode writeZFNode, LLVMAMD64WriteBooleanNode writeSFNode, LLVMAMD64WriteBooleanNode writeOFNode, LLVMAMD64WriteTupelNode out) {
            super(writeCFNode, writePFNode, writeAFNode, writeZFNode, writeSFNode, writeOFNode);
            this.out = out;
        }

        @Specialization
        protected void doOp(VirtualFrame frame, long left, long right) {
            long value = left * right;
            long hi = LongMultiplication.multiplyHighUnsigned(left, right);
            this.setFlags(frame, (byte)value, hi != 0L, value < 0L);
            this.out.execute(frame, value, hi);
        }
    }

    @NodeChildren(value={@NodeChild(value="left", type=LLVMExpressionNode.class), @NodeChild(value="right", type=LLVMExpressionNode.class)})
    public static abstract class LLVMAMD64MullNode
    extends LLVMAMD64MulNode {
        @Node.Child
        private LLVMAMD64WriteTupelNode out;

        public LLVMAMD64MullNode(LLVMAMD64WriteBooleanNode writeCFNode, LLVMAMD64WriteBooleanNode writePFNode, LLVMAMD64WriteBooleanNode writeAFNode, LLVMAMD64WriteBooleanNode writeZFNode, LLVMAMD64WriteBooleanNode writeSFNode, LLVMAMD64WriteBooleanNode writeOFNode, LLVMAMD64WriteTupelNode out) {
            super(writeCFNode, writePFNode, writeAFNode, writeZFNode, writeSFNode, writeOFNode);
            this.out = out;
        }

        @Specialization
        protected void doOp(VirtualFrame frame, int left, int right) {
            long value = Integer.toUnsignedLong(left) * Integer.toUnsignedLong(right);
            int hi = (int)(value >> 32);
            this.setFlags(frame, (byte)value, hi != 0, (int)value < 0);
            this.out.execute(frame, (int)value, hi);
        }
    }

    @NodeChildren(value={@NodeChild(value="left", type=LLVMExpressionNode.class), @NodeChild(value="right", type=LLVMExpressionNode.class)})
    public static abstract class LLVMAMD64MulwNode
    extends LLVMAMD64MulNode {
        @Node.Child
        private LLVMAMD64WriteTupelNode out;

        public LLVMAMD64MulwNode(LLVMAMD64WriteBooleanNode writeCFNode, LLVMAMD64WriteBooleanNode writePFNode, LLVMAMD64WriteBooleanNode writeAFNode, LLVMAMD64WriteBooleanNode writeZFNode, LLVMAMD64WriteBooleanNode writeSFNode, LLVMAMD64WriteBooleanNode writeOFNode, LLVMAMD64WriteTupelNode out) {
            super(writeCFNode, writePFNode, writeAFNode, writeZFNode, writeSFNode, writeOFNode);
            this.out = out;
        }

        @Specialization
        protected void doOp(VirtualFrame frame, short left, short right) {
            int value = Short.toUnsignedInt(left) * Short.toUnsignedInt(right);
            short hi = (short)(value >> 16);
            this.setFlags(frame, (byte)value, hi != 0, (short)value < 0);
            this.out.execute(frame, (short)value, hi);
        }
    }

    @NodeChildren(value={@NodeChild(value="left", type=LLVMExpressionNode.class), @NodeChild(value="right", type=LLVMExpressionNode.class)})
    public static abstract class LLVMAMD64MulbNode
    extends LLVMAMD64MulNode {
        @Node.Child
        private LLVMAMD64WriteValueNode out;

        public LLVMAMD64MulbNode(LLVMAMD64WriteBooleanNode writeCFNode, LLVMAMD64WriteBooleanNode writePFNode, LLVMAMD64WriteBooleanNode writeAFNode, LLVMAMD64WriteBooleanNode writeZFNode, LLVMAMD64WriteBooleanNode writeSFNode, LLVMAMD64WriteBooleanNode writeOFNode, LLVMAMD64WriteValueNode out) {
            super(writeCFNode, writePFNode, writeAFNode, writeZFNode, writeSFNode, writeOFNode);
            this.out = out;
        }

        @Specialization
        protected void doOp(VirtualFrame frame, byte left, byte right) {
            short value = (short)(Byte.toUnsignedInt(left) * Byte.toUnsignedInt(right));
            byte valueb = (byte)value;
            boolean overflow = (value >> 8 & 0xFF) != 0;
            boolean sign = valueb < 0;
            this.setFlags(frame, valueb, overflow, sign);
            this.out.execute(frame, value);
        }
    }
}

