/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.asm;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.llvm.runtime.memory.LLVMMemory;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.LLVMAMD64PopNode;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=LLVMAMD64PopNode.class)
public final class LLVMAMD64PopNodeFactory {

    @GeneratedBy(value=LLVMAMD64PopNode.LLVMAMD64PopqNode.class)
    public static final class LLVMAMD64PopqNodeGen
    extends LLVMAMD64PopNode.LLVMAMD64PopqNode {
        @CompilerDirectives.CompilationFinal
        private int state_;
        @CompilerDirectives.CompilationFinal
        private FrameSlot slot_;
        @CompilerDirectives.CompilationFinal
        private LLVMMemory memory_;

        private LLVMAMD64PopqNodeGen() {
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state = this.state_;
            if (state != 0) {
                return this.doI64(frameValue, this.slot_, this.memory_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(frameValue);
        }

        @Override
        public long executeI64(VirtualFrame frameValue) {
            int state = this.state_;
            if (state != 0) {
                return this.doI64(frameValue, this.slot_, this.memory_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(frameValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private long executeAndSpecialize(VirtualFrame frameValue) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                this.slot_ = this.getStackPointerSlot();
                this.memory_ = LLVMNode.getLLVMMemory();
                this.state_ = state |= 1;
                lock.unlock();
                hasLock = false;
                long l = this.doI64(frameValue, this.slot_, this.memory_);
                return l;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMAMD64PopNode.LLVMAMD64PopqNode create() {
            return new LLVMAMD64PopqNodeGen();
        }
    }

    @GeneratedBy(value=LLVMAMD64PopNode.LLVMAMD64PoplNode.class)
    public static final class LLVMAMD64PoplNodeGen
    extends LLVMAMD64PopNode.LLVMAMD64PoplNode {
        @CompilerDirectives.CompilationFinal
        private int state_;
        @CompilerDirectives.CompilationFinal
        private FrameSlot slot_;
        @CompilerDirectives.CompilationFinal
        private LLVMMemory memory_;

        private LLVMAMD64PoplNodeGen() {
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state = this.state_;
            if (state != 0) {
                return this.doI32(frameValue, this.slot_, this.memory_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(frameValue);
        }

        @Override
        public int executeI32(VirtualFrame frameValue) {
            int state = this.state_;
            if (state != 0) {
                return this.doI32(frameValue, this.slot_, this.memory_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(frameValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int executeAndSpecialize(VirtualFrame frameValue) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                this.slot_ = this.getStackPointerSlot();
                this.memory_ = LLVMNode.getLLVMMemory();
                this.state_ = state |= 1;
                lock.unlock();
                hasLock = false;
                int n = this.doI32(frameValue, this.slot_, this.memory_);
                return n;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMAMD64PopNode.LLVMAMD64PoplNode create() {
            return new LLVMAMD64PoplNodeGen();
        }
    }

    @GeneratedBy(value=LLVMAMD64PopNode.LLVMAMD64PopwNode.class)
    public static final class LLVMAMD64PopwNodeGen
    extends LLVMAMD64PopNode.LLVMAMD64PopwNode {
        @CompilerDirectives.CompilationFinal
        private int state_;
        @CompilerDirectives.CompilationFinal
        private FrameSlot slot_;
        @CompilerDirectives.CompilationFinal
        private LLVMMemory memory_;

        private LLVMAMD64PopwNodeGen() {
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state = this.state_;
            if (state != 0) {
                return this.doI16(frameValue, this.slot_, this.memory_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(frameValue);
        }

        @Override
        public short executeI16(VirtualFrame frameValue) {
            int state = this.state_;
            if (state != 0) {
                return this.doI16(frameValue, this.slot_, this.memory_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(frameValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private short executeAndSpecialize(VirtualFrame frameValue) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                this.slot_ = this.getStackPointerSlot();
                this.memory_ = LLVMNode.getLLVMMemory();
                this.state_ = state |= 1;
                lock.unlock();
                hasLock = false;
                short s = this.doI16(frameValue, this.slot_, this.memory_);
                return s;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMAMD64PopNode.LLVMAMD64PopwNode create() {
            return new LLVMAMD64PopwNodeGen();
        }
    }
}

