/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.asm;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.LLVMAMD64XorNode;

@GeneratedBy(value=LLVMAMD64XorNode.class)
public final class LLVMAMD64XorNodeFactory {

    @GeneratedBy(value=LLVMAMD64XorNode.LLVMAMD64XorqNode.class)
    public static final class LLVMAMD64XorqNodeGen
    extends LLVMAMD64XorNode.LLVMAMD64XorqNode {
        @Node.Child
        private LLVMExpressionNode left_;
        @Node.Child
        private LLVMExpressionNode right_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMAMD64XorqNodeGen(LLVMExpressionNode left, LLVMExpressionNode right) {
            this.left_ = left;
            this.right_ = right;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            long rightValue_;
            long leftValue_;
            int state = this.state_;
            try {
                leftValue_ = this.left_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object rightValue = this.right_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), rightValue);
            }
            try {
                rightValue_ = this.right_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(leftValue_, ex.getResult());
            }
            if (state != 0) {
                return this.doI64(leftValue_, rightValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftValue_, rightValue_);
        }

        @Override
        public long executeI64(VirtualFrame frameValue) {
            long rightValue_;
            long leftValue_;
            int state = this.state_;
            try {
                leftValue_ = this.left_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object rightValue = this.right_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), rightValue);
            }
            try {
                rightValue_ = this.right_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(leftValue_, ex.getResult());
            }
            if (state != 0) {
                return this.doI64(leftValue_, rightValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftValue_, rightValue_);
        }

        private long executeAndSpecialize(Object leftValue, Object rightValue) {
            int state = this.state_;
            if (leftValue instanceof Long) {
                long leftValue_ = (Long)leftValue;
                if (rightValue instanceof Long) {
                    long rightValue_ = (Long)rightValue;
                    this.state_ = state |= 1;
                    return this.doI64(leftValue_, rightValue_);
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.left_, this.right_}, new Object[]{leftValue, rightValue});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMAMD64XorNode.LLVMAMD64XorqNode create(LLVMExpressionNode left, LLVMExpressionNode right) {
            return new LLVMAMD64XorqNodeGen(left, right);
        }
    }

    @GeneratedBy(value=LLVMAMD64XorNode.LLVMAMD64XorlNode.class)
    public static final class LLVMAMD64XorlNodeGen
    extends LLVMAMD64XorNode.LLVMAMD64XorlNode {
        @Node.Child
        private LLVMExpressionNode left_;
        @Node.Child
        private LLVMExpressionNode right_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMAMD64XorlNodeGen(LLVMExpressionNode left, LLVMExpressionNode right) {
            this.left_ = left;
            this.right_ = right;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int rightValue_;
            int leftValue_;
            int state = this.state_;
            try {
                leftValue_ = this.left_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object rightValue = this.right_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), rightValue);
            }
            try {
                rightValue_ = this.right_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(leftValue_, ex.getResult());
            }
            if (state != 0) {
                return this.doI32(leftValue_, rightValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftValue_, rightValue_);
        }

        @Override
        public int executeI32(VirtualFrame frameValue) {
            int rightValue_;
            int leftValue_;
            int state = this.state_;
            try {
                leftValue_ = this.left_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object rightValue = this.right_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), rightValue);
            }
            try {
                rightValue_ = this.right_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(leftValue_, ex.getResult());
            }
            if (state != 0) {
                return this.doI32(leftValue_, rightValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftValue_, rightValue_);
        }

        private int executeAndSpecialize(Object leftValue, Object rightValue) {
            int state = this.state_;
            if (leftValue instanceof Integer) {
                int leftValue_ = (Integer)leftValue;
                if (rightValue instanceof Integer) {
                    int rightValue_ = (Integer)rightValue;
                    this.state_ = state |= 1;
                    return this.doI32(leftValue_, rightValue_);
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.left_, this.right_}, new Object[]{leftValue, rightValue});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMAMD64XorNode.LLVMAMD64XorlNode create(LLVMExpressionNode left, LLVMExpressionNode right) {
            return new LLVMAMD64XorlNodeGen(left, right);
        }
    }

    @GeneratedBy(value=LLVMAMD64XorNode.LLVMAMD64XorwNode.class)
    public static final class LLVMAMD64XorwNodeGen
    extends LLVMAMD64XorNode.LLVMAMD64XorwNode {
        @Node.Child
        private LLVMExpressionNode left_;
        @Node.Child
        private LLVMExpressionNode right_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMAMD64XorwNodeGen(LLVMExpressionNode left, LLVMExpressionNode right) {
            this.left_ = left;
            this.right_ = right;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            short rightValue_;
            short leftValue_;
            int state = this.state_;
            try {
                leftValue_ = this.left_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object rightValue = this.right_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), rightValue);
            }
            try {
                rightValue_ = this.right_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(leftValue_, ex.getResult());
            }
            if (state != 0) {
                return this.doI16(leftValue_, rightValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftValue_, rightValue_);
        }

        @Override
        public short executeI16(VirtualFrame frameValue) {
            short rightValue_;
            short leftValue_;
            int state = this.state_;
            try {
                leftValue_ = this.left_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object rightValue = this.right_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), rightValue);
            }
            try {
                rightValue_ = this.right_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(leftValue_, ex.getResult());
            }
            if (state != 0) {
                return this.doI16(leftValue_, rightValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftValue_, rightValue_);
        }

        private short executeAndSpecialize(Object leftValue, Object rightValue) {
            int state = this.state_;
            if (leftValue instanceof Short) {
                short leftValue_ = (Short)leftValue;
                if (rightValue instanceof Short) {
                    short rightValue_ = (Short)rightValue;
                    this.state_ = state |= 1;
                    return this.doI16(leftValue_, rightValue_);
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.left_, this.right_}, new Object[]{leftValue, rightValue});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMAMD64XorNode.LLVMAMD64XorwNode create(LLVMExpressionNode left, LLVMExpressionNode right) {
            return new LLVMAMD64XorwNodeGen(left, right);
        }
    }

    @GeneratedBy(value=LLVMAMD64XorNode.LLVMAMD64XorbNode.class)
    public static final class LLVMAMD64XorbNodeGen
    extends LLVMAMD64XorNode.LLVMAMD64XorbNode {
        @Node.Child
        private LLVMExpressionNode left_;
        @Node.Child
        private LLVMExpressionNode right_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMAMD64XorbNodeGen(LLVMExpressionNode left, LLVMExpressionNode right) {
            this.left_ = left;
            this.right_ = right;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            byte rightValue_;
            byte leftValue_;
            int state = this.state_;
            try {
                leftValue_ = this.left_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object rightValue = this.right_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), rightValue);
            }
            try {
                rightValue_ = this.right_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(leftValue_, ex.getResult());
            }
            if (state != 0) {
                return this.doI8(leftValue_, rightValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftValue_, rightValue_);
        }

        @Override
        public byte executeI8(VirtualFrame frameValue) {
            byte rightValue_;
            byte leftValue_;
            int state = this.state_;
            try {
                leftValue_ = this.left_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object rightValue = this.right_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), rightValue);
            }
            try {
                rightValue_ = this.right_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(leftValue_, ex.getResult());
            }
            if (state != 0) {
                return this.doI8(leftValue_, rightValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftValue_, rightValue_);
        }

        private byte executeAndSpecialize(Object leftValue, Object rightValue) {
            int state = this.state_;
            if (leftValue instanceof Byte) {
                byte leftValue_ = (Byte)leftValue;
                if (rightValue instanceof Byte) {
                    byte rightValue_ = (Byte)rightValue;
                    this.state_ = state |= 1;
                    return this.doI8(leftValue_, rightValue_);
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.left_, this.right_}, new Object[]{leftValue, rightValue});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMAMD64XorNode.LLVMAMD64XorbNode create(LLVMExpressionNode left, LLVMExpressionNode right) {
            return new LLVMAMD64XorbNodeGen(left, right);
        }
    }
}

