/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.asm.syscall;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.asm.syscall.LLVMAMD64SyscallArchPrctlNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMPointerStoreNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=LLVMAMD64SyscallArchPrctlNode.class)
public final class LLVMAMD64SyscallArchPrctlNodeGen
extends LLVMAMD64SyscallArchPrctlNode {
    @CompilerDirectives.CompilationFinal
    private int state_;
    @CompilerDirectives.CompilationFinal
    private TruffleLanguage.ContextReference<LLVMContext> lLVMLanguageContextReference_;
    @Node.Child
    private LLVMPointerStoreNode op0_store_;
    @Node.Child
    private LLVMPointerStoreNode op1_store_;

    private LLVMAMD64SyscallArchPrctlNodeGen() {
    }

    @Override
    public long execute(Object arg0Value, Object arg1Value, Object arg2, Object arg3, Object arg4, Object arg5) {
        int state = this.state_;
        if (state != 0 && arg0Value instanceof Long) {
            long arg0Value_ = (Long)arg0Value;
            if ((state & 1) != 0 && arg1Value instanceof Long) {
                long arg1Value_ = (Long)arg1Value;
                return this.doOp(arg0Value_, arg1Value_, (LLVMContext)this.lLVMLanguageContextReference_.get(), this.op0_store_);
            }
            if ((state & 2) != 0 && LLVMTypes.isPointer(arg1Value)) {
                LLVMPointer arg1Value_ = LLVMTypes.asPointer(arg1Value);
                return this.doOp(arg0Value_, arg1Value_, (LLVMContext)this.lLVMLanguageContextReference_.get(), this.op1_store_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value, arg1Value);
    }

    private long executeAndSpecialize(Object arg0Value, Object arg1Value) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        try {
            if (arg0Value instanceof Long) {
                long arg0Value_ = (Long)arg0Value;
                if (arg1Value instanceof Long) {
                    long arg1Value_ = (Long)arg1Value;
                    TruffleLanguage.ContextReference lLVMLanguageContextReference__ = this.lLVMLanguageContextReference_;
                    if (lLVMLanguageContextReference__ == null) {
                        this.lLVMLanguageContextReference_ = lLVMLanguageContextReference__ = super.lookupContextReference(LLVMLanguage.class);
                    }
                    this.op0_store_ = (LLVMPointerStoreNode)super.insert((Node)this.createAddressStoreNode());
                    this.state_ = state |= 1;
                    lock.unlock();
                    hasLock = false;
                    long l = this.doOp(arg0Value_, arg1Value_, (LLVMContext)lLVMLanguageContextReference__.get(), this.op0_store_);
                    return l;
                }
                if (LLVMTypes.isPointer(arg1Value)) {
                    LLVMPointer arg1Value_ = LLVMTypes.asPointer(arg1Value);
                    TruffleLanguage.ContextReference lLVMLanguageContextReference__ = this.lLVMLanguageContextReference_;
                    if (lLVMLanguageContextReference__ == null) {
                        this.lLVMLanguageContextReference_ = lLVMLanguageContextReference__ = super.lookupContextReference(LLVMLanguage.class);
                    }
                    this.op1_store_ = (LLVMPointerStoreNode)super.insert((Node)this.createAddressStoreNode());
                    this.state_ = state |= 2;
                    lock.unlock();
                    hasLock = false;
                    long l = this.doOp(arg0Value_, arg1Value_, (LLVMContext)lLVMLanguageContextReference__.get(), this.op1_store_);
                    return l;
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & state - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public static LLVMAMD64SyscallArchPrctlNode create() {
        return new LLVMAMD64SyscallArchPrctlNodeGen();
    }
}

