/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.asm.syscall;

import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.memory.LLVMSyscallOperationNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI64StoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI64StoreNodeGen;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

public abstract class LLVMAMD64SyscallClockGetTimeNode
extends LLVMSyscallOperationNode {
    @Node.Child
    private LLVMI64StoreNode writeI64 = LLVMI64StoreNodeGen.create(null, null);

    @Override
    public final String getName() {
        return "clock_gettime";
    }

    @Specialization
    protected long doI64(long clkId, LLVMPointer tp) {
        return this.clockGetTime((int)clkId, tp);
    }

    @Specialization
    protected long doI64(long clkId, long tp) {
        return this.doI64(clkId, LLVMNativePointer.create(tp));
    }

    private int clockGetTime(int clkId, LLVMPointer timespec) {
        long ns;
        long s;
        switch (clkId) {
            case 0: {
                long t = System.currentTimeMillis();
                s = t / 1000L;
                ns = t % 1000L * 1000000L;
                break;
            }
            case 1: {
                long t = System.nanoTime();
                s = t / 1000000000L;
                ns = t % 1000000000L;
                break;
            }
            default: {
                return -22;
            }
        }
        LLVMPointer ptr = timespec;
        this.writeI64.executeWithTarget(ptr, s);
        ptr = ptr.increment(8L);
        this.writeI64.executeWithTarget(ptr, ns);
        return 0;
    }
}

