/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.asm.syscall;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.CachedContext;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.memory.LLVMMemory;
import com.oracle.truffle.llvm.runtime.memory.LLVMSyscallOperationNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.support.LLVMString;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;

public abstract class LLVMAMD64SyscallGetcwdNode
extends LLVMSyscallOperationNode {
    @Override
    public final String getName() {
        return "getcwd";
    }

    @Specialization
    protected long doOp(LLVMNativePointer buf, long size, @Cached(value="getLLVMMemory()") LLVMMemory memory, @CachedContext(value=LLVMLanguage.class) LLVMContext ctx) {
        String cwd = ctx.getEnv().getCurrentWorkingDirectory().getPath();
        if ((long)cwd.length() >= size) {
            return -34L;
        }
        LLVMString.strcpy(memory, buf, cwd);
        return (long)cwd.length() + 1L;
    }

    @Specialization
    protected long doOp(long buf, long size, @Cached(value="getLLVMMemory()") LLVMMemory memory, @CachedContext(value=LLVMLanguage.class) LLVMContext ctx) {
        return this.doOp(LLVMNativePointer.create(buf), size, memory, ctx);
    }
}

