/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.asm.syscall;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.llvm.runtime.memory.LLVMMemory;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.asm.syscall.LLVMAMD64SyscallUnameNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=LLVMAMD64SyscallUnameNode.class)
public final class LLVMAMD64SyscallUnameNodeGen
extends LLVMAMD64SyscallUnameNode {
    @CompilerDirectives.CompilationFinal
    private int state_;
    @CompilerDirectives.CompilationFinal
    private LLVMMemory op0_memory_;
    @CompilerDirectives.CompilationFinal
    private LLVMMemory op1_memory_;

    private LLVMAMD64SyscallUnameNodeGen() {
    }

    @Override
    public long execute(Object arg0Value, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        int state = this.state_;
        if ((state & 1) != 0 && LLVMTypes.isNativePointer(arg0Value)) {
            LLVMNativePointer arg0Value_ = LLVMTypes.asNativePointer(arg0Value);
            return this.doOp(arg0Value_, this.op0_memory_);
        }
        if ((state & 2) != 0 && arg0Value instanceof Long) {
            long arg0Value_ = (Long)arg0Value;
            return this.doOp(arg0Value_, this.op1_memory_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value);
    }

    private long executeAndSpecialize(Object arg0Value) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        try {
            if (LLVMTypes.isNativePointer(arg0Value)) {
                LLVMNativePointer arg0Value_ = LLVMTypes.asNativePointer(arg0Value);
                this.op0_memory_ = LLVMNode.getLLVMMemory();
                this.state_ = state |= 1;
                lock.unlock();
                hasLock = false;
                long l = this.doOp(arg0Value_, this.op0_memory_);
                return l;
            }
            if (arg0Value instanceof Long) {
                long arg0Value_ = (Long)arg0Value;
                this.op1_memory_ = LLVMNode.getLLVMMemory();
                this.state_ = state |= 2;
                lock.unlock();
                hasLock = false;
                long l = this.doOp(arg0Value_, this.op1_memory_);
                return l;
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{null}, new Object[]{arg0Value});
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & state - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public static LLVMAMD64SyscallUnameNode create() {
        return new LLVMAMD64SyscallUnameNodeGen();
    }
}

