/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.base;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.GenerateWrapper;
import com.oracle.truffle.api.instrumentation.InstrumentableNode;
import com.oracle.truffle.api.instrumentation.ProbeNode;
import com.oracle.truffle.api.nodes.ControlFlowException;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMControlFlowNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMStatementNode;
import com.oracle.truffle.llvm.runtime.nodes.base.LLVMBasicBlockNodeWrapper;
import com.oracle.truffle.llvm.runtime.nodes.func.LLVMFunctionStartNode;
import com.oracle.truffle.llvm.runtime.options.SulongEngineOption;

@GenerateWrapper
public abstract class LLVMBasicBlockNode
extends LLVMStatementNode {
    public static final int RETURN_FROM_FUNCTION = -1;
    private final int blockId;
    private final String blockName;

    public static LLVMBasicBlockNode createBasicBlockNode(LLVMContext context, LLVMStatementNode[] statements, LLVMControlFlowNode termInstruction, int blockId, String blockName) {
        if (((Boolean)context.getEnv().getOptions().get(SulongEngineOption.LAZY_PARSING)).booleanValue()) {
            return new LazyBlock(statements, termInstruction, blockId, blockName);
        }
        return new InitializedBlock(statements, termInstruction, blockId, blockName);
    }

    public LLVMBasicBlockNode(int blockId, String blockName) {
        this.blockId = blockId;
        this.blockName = blockName;
    }

    protected LLVMBasicBlockNode(LLVMBasicBlockNode other) {
        this.blockId = other.blockId;
        this.blockName = other.blockName;
    }

    @Override
    public InstrumentableNode.WrapperNode createWrapper(ProbeNode probeNode) {
        return new LLVMBasicBlockNodeWrapper(this, this, probeNode);
    }

    public abstract LLVMBasicBlockNode initialize();

    @Override
    public abstract void execute(VirtualFrame var1);

    public abstract LLVMControlFlowNode getTerminatingInstruction();

    public int getBlockId() {
        return this.blockId;
    }

    public String getBlockName() {
        return this.blockName;
    }

    @Override
    public String getSourceDescription() {
        LLVMFunctionStartNode functionStartNode = (LLVMFunctionStartNode)NodeUtil.findParent((Node)this, LLVMFunctionStartNode.class);
        assert (functionStartNode != null) : this.getParent().getClass();
        return String.format("Function: %s - Block: %s", functionStartNode.getBcName(), this.blockName());
    }

    private String blockName() {
        return String.format("id: %d name: %s", this.blockId, this.blockName == null ? "N/A" : this.blockName);
    }

    public abstract double getBranchProbability(int var1);

    public abstract void increaseBranchProbability(int var1);

    public String toString() {
        CompilerAsserts.neverPartOfCompilation();
        return String.format("basic block %s", this.getBlockId());
    }

    private static final class LazyBlock
    extends LLVMBasicBlockNode {
        @CompilerDirectives.CompilationFinal(dimensions=1)
        private final LLVMStatementNode[] statements;
        private final LLVMControlFlowNode termInstruction;

        private LazyBlock(LLVMStatementNode[] statements, LLVMControlFlowNode termInstruction, int blockId, String blockName) {
            super(blockId, blockName);
            this.statements = statements;
            this.termInstruction = termInstruction;
        }

        @Override
        public LLVMBasicBlockNode initialize() {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            InitializedBlock materializedBlock = new InitializedBlock(this.statements, this.termInstruction, this.getBlockId(), this.getBlockName());
            materializedBlock.setSourceDescriptor(this.getSourceDescriptor());
            this.replace(materializedBlock, "Lazily Inserting LLVM Basic Block");
            this.notifyInserted(materializedBlock);
            return materializedBlock;
        }

        @Override
        public void execute(VirtualFrame frame) {
            CompilerDirectives.transferToInterpreter();
            throw new IllegalStateException("Lazy block should have been materialized");
        }

        @Override
        public LLVMControlFlowNode getTerminatingInstruction() {
            return this.termInstruction;
        }

        @Override
        public double getBranchProbability(int successorIndex) {
            return 0.0;
        }

        @Override
        public void increaseBranchProbability(int successorIndex) {
        }

        @Override
        public String toString() {
            CompilerAsserts.neverPartOfCompilation();
            return String.format("uninitialized basic block %s (#statements: %s, terminating instruction: %s)", new Object[]{this.getBlockId(), this.statements.length, this.termInstruction});
        }
    }

    private static final class InitializedBlock
    extends LLVMBasicBlockNode {
        private final BranchProfile controlFlowExceptionProfile = BranchProfile.create();
        private final BranchProfile blockEntered = BranchProfile.create();
        @CompilerDirectives.CompilationFinal(dimensions=1)
        private final long[] successorExecutionCount;
        @Node.Children
        private final LLVMStatementNode[] statements;
        @Node.Child
        public LLVMControlFlowNode termInstruction;

        InitializedBlock(LLVMStatementNode[] statements, LLVMControlFlowNode termInstruction, int blockId, String blockName) {
            super(blockId, blockName);
            this.successorExecutionCount = termInstruction.needsBranchProfiling() ? new long[termInstruction.getSuccessorCount()] : null;
            this.statements = statements;
            this.termInstruction = termInstruction;
        }

        @Override
        public LLVMBasicBlockNode initialize() {
            return this;
        }

        @Override
        @ExplodeLoop
        public void execute(VirtualFrame frame) {
            this.blockEntered.enter();
            for (int i = 0; i < this.statements.length; ++i) {
                LLVMStatementNode statement = this.statements[i];
                try {
                    statement.execute(frame);
                    continue;
                }
                catch (ControlFlowException e) {
                    this.controlFlowExceptionProfile.enter();
                    throw e;
                }
            }
        }

        @Override
        public LLVMControlFlowNode getTerminatingInstruction() {
            return this.termInstruction;
        }

        @Override
        @ExplodeLoop
        public double getBranchProbability(int successorIndex) {
            double successorBranchProbability;
            assert (this.termInstruction.needsBranchProfiling());
            long succCount = 0L;
            long totalExecutionCount = 0L;
            for (int i = 0; i < this.successorExecutionCount.length; ++i) {
                long v = this.successorExecutionCount[i];
                if (successorIndex == i) {
                    succCount = v;
                }
                totalExecutionCount += v;
            }
            if (succCount == 0L) {
                successorBranchProbability = 0.0;
            } else {
                assert (totalExecutionCount > 0L);
                successorBranchProbability = (double)succCount / (double)totalExecutionCount;
            }
            assert (!Double.isNaN(successorBranchProbability) && successorBranchProbability >= 0.0 && successorBranchProbability <= 1.0);
            return successorBranchProbability;
        }

        @Override
        public void increaseBranchProbability(int successorIndex) {
            CompilerAsserts.neverPartOfCompilation();
            if (this.termInstruction.needsBranchProfiling()) {
                this.incrementCountAtIndex(successorIndex);
            }
        }

        private void incrementCountAtIndex(int successorIndex) {
            assert (this.termInstruction.needsBranchProfiling());
            int n = successorIndex;
            this.successorExecutionCount[n] = this.successorExecutionCount[n] + 1L;
        }
    }
}

