/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.cast;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.llvm.runtime.CommonNodeFactory;
import com.oracle.truffle.llvm.runtime.LLVMIVarBit;
import com.oracle.truffle.llvm.runtime.floating.LLVM80BitFloat;
import com.oracle.truffle.llvm.runtime.interop.convert.ForeignToLLVM;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMToNativeNode;
import com.oracle.truffle.llvm.runtime.nodes.cast.LLVMToI64Node;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.runtime.vector.LLVMFloatVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI16Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI1Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI32Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI8Vector;

@NodeChild(value="fromNode", type=LLVMExpressionNode.class)
public abstract class LLVMToI32Node
extends LLVMExpressionNode {
    @Specialization(guards={"isForeign(from)"})
    protected int doManagedPointer(LLVMManagedPointer from, @Cached(value="createForeignToLLVM()") ForeignToLLVM toLLVM) {
        return (Integer)toLLVM.executeWithTarget(from.getObject());
    }

    @Specialization
    protected int doPointer(LLVMPointer from, @Cached(value="createToNativeWithTarget()") LLVMToNativeNode toNative) {
        return (int)toNative.executeWithTarget(from).asNative();
    }

    protected ForeignToLLVM createForeignToLLVM() {
        return CommonNodeFactory.createForeignToLLVM(ForeignToLLVM.ForeignToLLVMType.I32);
    }

    protected boolean isForeign(LLVMManagedPointer pointer) {
        return pointer.getOffset() == 0L && LLVMToI32Node.notLLVM(pointer.getObject());
    }

    public static abstract class LLVMBitcastToI32Node
    extends LLVMToI32Node {
        @Specialization
        protected int doI32(int from) {
            return from;
        }

        @Specialization
        protected int doI32(float from) {
            return Float.floatToIntBits(from);
        }

        @Specialization
        protected int doI1Vector(LLVMI1Vector from) {
            return (int)LLVMToI64Node.LLVMBitcastToI64Node.castI1Vector(from, 32);
        }

        @Specialization
        protected int doI8Vector(LLVMI8Vector from) {
            return (int)LLVMToI64Node.LLVMBitcastToI64Node.castI8Vector(from, 4);
        }

        @Specialization
        protected int doI16Vector(LLVMI16Vector from) {
            return (int)LLVMToI64Node.LLVMBitcastToI64Node.castI16Vector(from, 2);
        }

        @Specialization
        protected int doI32Vector(LLVMI32Vector from) {
            assert (from.getLength() == 1) : "invalid vector size";
            return from.getValue(0);
        }

        @Specialization
        protected int doFloatVector(LLVMFloatVector from) {
            assert (from.getLength() == 1) : "invalid vector size!";
            return Float.floatToIntBits(from.getValue(0));
        }
    }

    public static abstract class LLVMUnsignedCastToI32Node
    extends LLVMToI32Node {
        private static final float MAX_INT_AS_FLOAT = 2.1474836E9f;
        private static final double MAX_INT_AS_DOUBLE = 2.147483647E9;

        @Specialization
        protected int doI1(boolean from) {
            return from ? 1 : 0;
        }

        @Specialization
        protected int doI8(byte from) {
            return from & 0xFF;
        }

        @Specialization
        protected int doI16(short from) {
            return from & 0xFFFF;
        }

        @Specialization
        protected int doI32(int from) {
            return from;
        }

        @Specialization
        protected int doIVarBit(LLVMIVarBit from) {
            return from.getZeroExtendedIntValue();
        }

        @Specialization(guards={"fitsIntoSignedInt(from)"})
        protected int doFloat(float from) {
            return (int)from;
        }

        @Specialization(guards={"!fitsIntoSignedInt(from)"})
        protected int doFloatConversion(float from) {
            return (int)(from + -2.1474836E9f) - Integer.MIN_VALUE;
        }

        @Specialization(guards={"fitsIntoSignedInt(from)"})
        protected int doDouble(double from) {
            return (int)from;
        }

        @Specialization(guards={"!fitsIntoSignedInt(from)"})
        protected int doDoubleConversion(double from) {
            return (int)(from + -2.147483648E9) - Integer.MIN_VALUE;
        }

        @Specialization
        protected int doLLVM80BitFloat(LLVM80BitFloat from) {
            return from.getIntValue();
        }

        protected static boolean fitsIntoSignedInt(float from) {
            return from < 2.1474836E9f;
        }

        protected static boolean fitsIntoSignedInt(double from) {
            return from < 2.147483647E9;
        }
    }

    public static abstract class LLVMSignedCastToI32Node
    extends LLVMToI32Node {
        @Specialization
        protected int doI32(boolean from) {
            return from ? -1 : 0;
        }

        @Specialization
        protected int doI32(byte from) {
            return from;
        }

        @Specialization
        protected int doI32(short from) {
            return from;
        }

        @Specialization
        protected int doI32(int from) {
            return from;
        }

        @Specialization
        protected int doI32(long from) {
            return (int)from;
        }

        @Specialization
        protected int doI32(LLVMIVarBit from) {
            return from.getIntValue();
        }

        @Specialization
        protected int doI32(float from) {
            return (int)from;
        }

        @Specialization
        protected int doI32(double from) {
            return (int)from;
        }

        @Specialization
        protected int doI32(LLVM80BitFloat from) {
            return from.getIntValue();
        }
    }
}

