/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.control;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.GenerateWrapper;
import com.oracle.truffle.api.instrumentation.InstrumentableNode;
import com.oracle.truffle.api.instrumentation.ProbeNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMControlFlowNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMStatementNode;
import com.oracle.truffle.llvm.runtime.nodes.control.LLVMConditionalBranchNodeWrapper;

@GenerateWrapper
public abstract class LLVMConditionalBranchNode
extends LLVMControlFlowNode {
    public static final int TRUE_SUCCESSOR = 0;
    public static final int FALSE_SUCCESSOR = 1;

    public static LLVMConditionalBranchNode create(int trueSuccessor, int falseSuccessor, LLVMStatementNode truePhi, LLVMStatementNode falsePhi, LLVMExpressionNode condition) {
        return new LLVMConditionalBranchNodeImpl(trueSuccessor, falseSuccessor, truePhi, falsePhi, condition);
    }

    public InstrumentableNode.WrapperNode createWrapper(ProbeNode probe) {
        return new LLVMConditionalBranchNodeWrapper(this, probe);
    }

    public abstract boolean executeCondition(VirtualFrame var1);

    public abstract int getTrueSuccessor();

    public abstract int getFalseSuccessor();

    private static final class LLVMConditionalBranchNodeImpl
    extends LLVMConditionalBranchNode {
        @Node.Child
        private LLVMExpressionNode condition;
        @Node.Child
        private LLVMStatementNode truePhi;
        @Node.Child
        private LLVMStatementNode falsePhi;
        private final int trueSuccessor;
        private final int falseSuccessor;

        private LLVMConditionalBranchNodeImpl(int trueSuccessor, int falseSuccessor, LLVMStatementNode truePhi, LLVMStatementNode falsePhi, LLVMExpressionNode condition) {
            this.trueSuccessor = trueSuccessor;
            this.falseSuccessor = falseSuccessor;
            this.truePhi = truePhi;
            this.falsePhi = falsePhi;
            this.condition = condition;
        }

        @Override
        public int getSuccessorCount() {
            return 2;
        }

        @Override
        public LLVMStatementNode getPhiNode(int successorIndex) {
            CompilerAsserts.partialEvaluationConstant((int)successorIndex);
            if (successorIndex == 0) {
                return this.truePhi;
            }
            assert (successorIndex == 1);
            return this.falsePhi;
        }

        @Override
        public boolean executeCondition(VirtualFrame frame) {
            try {
                return this.condition.executeI1(frame);
            }
            catch (UnexpectedResultException e) {
                CompilerDirectives.transferToInterpreter();
                throw new IllegalStateException(e);
            }
        }

        @Override
        public int getTrueSuccessor() {
            return this.trueSuccessor;
        }

        @Override
        public int getFalseSuccessor() {
            return this.falseSuccessor;
        }
    }
}

