/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.control;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.StandardTags;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.memory.LLVMUniquesRegionAllocNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMStatementNode;
import com.oracle.truffle.llvm.runtime.nodes.base.LLVMFrameNullerUtil;
import com.oracle.truffle.llvm.runtime.nodes.control.LLVMDispatchBasicBlockNode;

public final class LLVMFunctionRootNode
extends LLVMExpressionNode {
    private static final FrameSlot[] NO_SLOTS = new FrameSlot[0];
    @Node.Children
    private final LLVMStatementNode[] copyArgumentsToFrame;
    @Node.Child
    private LLVMUniquesRegionAllocNode uniquesRegionAllocNode;
    @Node.Child
    private LLVMExpressionNode rootBody;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final FrameSlot[] frameSlotsToInitialize;

    public LLVMFunctionRootNode(LLVMUniquesRegionAllocNode uniquesRegionAllocNode, LLVMStatementNode[] copyArgumentsToFrame, LLVMDispatchBasicBlockNode rootBody, FrameDescriptor frameDescriptor) {
        this.uniquesRegionAllocNode = uniquesRegionAllocNode;
        this.copyArgumentsToFrame = copyArgumentsToFrame;
        this.rootBody = rootBody;
        this.frameSlotsToInitialize = frameDescriptor.getSlots().toArray(NO_SLOTS);
    }

    @ExplodeLoop
    private void copyArgumentsToFrame(VirtualFrame frame) {
        for (LLVMStatementNode n : this.copyArgumentsToFrame) {
            n.execute(frame);
        }
    }

    @Override
    public Object executeGeneric(VirtualFrame frame) {
        this.nullStack(frame);
        this.copyArgumentsToFrame(frame);
        this.uniquesRegionAllocNode.execute(frame);
        return this.rootBody.executeGeneric(frame);
    }

    @ExplodeLoop
    private void nullStack(VirtualFrame frame) {
        for (FrameSlot frameSlot : this.frameSlotsToInitialize) {
            LLVMFrameNullerUtil.nullFrameSlot(frame, frameSlot, true);
        }
    }

    @Override
    public boolean hasTag(Class<? extends Tag> tag) {
        if (tag == StandardTags.StatementTag.class) {
            return false;
        }
        if (tag == StandardTags.RootTag.class) {
            return true;
        }
        return super.hasTag(tag);
    }
}

