/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.control;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.LLVMIVarBit;
import com.oracle.truffle.llvm.runtime.floating.LLVM80BitFloat;
import com.oracle.truffle.llvm.runtime.memory.LLVMMemMoveNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypesGen;
import com.oracle.truffle.llvm.runtime.nodes.control.LLVMRetNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.runtime.vector.LLVMDoubleVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMFloatVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI16Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI1Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI32Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI64Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI8Vector;

@GeneratedBy(value=LLVMRetNode.class)
public final class LLVMRetNodeFactory {

    @GeneratedBy(value=LLVMRetNode.LLVMVoidReturnNode.class)
    public static final class LLVMVoidReturnNodeGen
    extends LLVMRetNode.LLVMVoidReturnNode {
        private LLVMVoidReturnNodeGen() {
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return this.doOp();
        }

        public NodeCost getCost() {
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMRetNode.LLVMVoidReturnNode create() {
            return new LLVMVoidReturnNodeGen();
        }
    }

    @GeneratedBy(value=LLVMRetNode.LLVMStructRetNode.class)
    public static final class LLVMStructRetNodeGen
    extends LLVMRetNode.LLVMStructRetNode {
        private final long structSize;
        @Node.Child
        private LLVMExpressionNode retResult_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMStructRetNodeGen(LLVMMemMoveNode memMove, LLVMExpressionNode retResult, long structSize) {
            super(memMove);
            this.structSize = structSize;
            this.retResult_ = retResult;
        }

        @Override
        public long getStructSize() {
            return this.structSize;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = this.state_;
            Object retResultValue_ = this.retResult_.executeGeneric(frameValue);
            if (state != 0 && LLVMTypes.isPointer(retResultValue_)) {
                LLVMPointer retResultValue__ = LLVMTypes.asPointer(retResultValue_);
                return this.doOp(frameValue, retResultValue__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(frameValue, retResultValue_);
        }

        private Object executeAndSpecialize(VirtualFrame frameValue, Object retResultValue) {
            int state = this.state_;
            if (LLVMTypes.isPointer(retResultValue)) {
                LLVMPointer retResultValue_ = LLVMTypes.asPointer(retResultValue);
                this.state_ = state |= 1;
                return this.doOp(frameValue, retResultValue_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.retResult_}, new Object[]{retResultValue});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMRetNode.LLVMStructRetNode create(LLVMMemMoveNode memMove, LLVMExpressionNode retResult, long structSize) {
            return new LLVMStructRetNodeGen(memMove, retResult, structSize);
        }
    }

    @GeneratedBy(value=LLVMRetNode.LLVMVectorRetNode.class)
    public static final class LLVMVectorRetNodeGen
    extends LLVMRetNode.LLVMVectorRetNode {
        @Node.Child
        private LLVMExpressionNode retResult_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMVectorRetNodeGen(LLVMExpressionNode retResult) {
            this.retResult_ = retResult;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = this.state_;
            Object retResultValue_ = this.retResult_.executeGeneric(frameValue);
            if ((state & 1) != 0 && retResultValue_ instanceof LLVMDoubleVector) {
                LLVMDoubleVector retResultValue__ = (LLVMDoubleVector)retResultValue_;
                return this.doOp(retResultValue__);
            }
            if ((state & 2) != 0 && retResultValue_ instanceof LLVMFloatVector) {
                LLVMFloatVector retResultValue__ = (LLVMFloatVector)retResultValue_;
                return this.doOp(retResultValue__);
            }
            if ((state & 4) != 0 && retResultValue_ instanceof LLVMI16Vector) {
                LLVMI16Vector retResultValue__ = (LLVMI16Vector)retResultValue_;
                return this.doOp(retResultValue__);
            }
            if ((state & 8) != 0 && retResultValue_ instanceof LLVMI1Vector) {
                LLVMI1Vector retResultValue__ = (LLVMI1Vector)retResultValue_;
                return this.doOp(retResultValue__);
            }
            if ((state & 0x10) != 0 && retResultValue_ instanceof LLVMI32Vector) {
                LLVMI32Vector retResultValue__ = (LLVMI32Vector)retResultValue_;
                return this.doOp(retResultValue__);
            }
            if ((state & 0x20) != 0 && retResultValue_ instanceof LLVMI64Vector) {
                LLVMI64Vector retResultValue__ = (LLVMI64Vector)retResultValue_;
                return this.doOp(retResultValue__);
            }
            if ((state & 0x40) != 0 && retResultValue_ instanceof LLVMI8Vector) {
                LLVMI8Vector retResultValue__ = (LLVMI8Vector)retResultValue_;
                return this.doOp(retResultValue__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(retResultValue_);
        }

        private Object executeAndSpecialize(Object retResultValue) {
            int state = this.state_;
            if (retResultValue instanceof LLVMDoubleVector) {
                LLVMDoubleVector retResultValue_ = (LLVMDoubleVector)retResultValue;
                this.state_ = state |= 1;
                return this.doOp(retResultValue_);
            }
            if (retResultValue instanceof LLVMFloatVector) {
                LLVMFloatVector retResultValue_ = (LLVMFloatVector)retResultValue;
                this.state_ = state |= 2;
                return this.doOp(retResultValue_);
            }
            if (retResultValue instanceof LLVMI16Vector) {
                LLVMI16Vector retResultValue_ = (LLVMI16Vector)retResultValue;
                this.state_ = state |= 4;
                return this.doOp(retResultValue_);
            }
            if (retResultValue instanceof LLVMI1Vector) {
                LLVMI1Vector retResultValue_ = (LLVMI1Vector)retResultValue;
                this.state_ = state |= 8;
                return this.doOp(retResultValue_);
            }
            if (retResultValue instanceof LLVMI32Vector) {
                LLVMI32Vector retResultValue_ = (LLVMI32Vector)retResultValue;
                this.state_ = state |= 0x10;
                return this.doOp(retResultValue_);
            }
            if (retResultValue instanceof LLVMI64Vector) {
                LLVMI64Vector retResultValue_ = (LLVMI64Vector)retResultValue;
                this.state_ = state |= 0x20;
                return this.doOp(retResultValue_);
            }
            if (retResultValue instanceof LLVMI8Vector) {
                LLVMI8Vector retResultValue_ = (LLVMI8Vector)retResultValue;
                this.state_ = state |= 0x40;
                return this.doOp(retResultValue_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.retResult_}, new Object[]{retResultValue});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMRetNode.LLVMVectorRetNode create(LLVMExpressionNode retResult) {
            return new LLVMVectorRetNodeGen(retResult);
        }
    }

    @GeneratedBy(value=LLVMRetNode.LLVMAddressRetNode.class)
    public static final class LLVMAddressRetNodeGen
    extends LLVMRetNode.LLVMAddressRetNode {
        @Node.Child
        private LLVMExpressionNode retResult_;

        private LLVMAddressRetNodeGen(LLVMExpressionNode retResult) {
            this.retResult_ = retResult;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            Object retResultValue_ = this.retResult_.executeGeneric(frameValue);
            return this.doOp(retResultValue_);
        }

        public NodeCost getCost() {
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMRetNode.LLVMAddressRetNode create(LLVMExpressionNode retResult) {
            return new LLVMAddressRetNodeGen(retResult);
        }
    }

    @GeneratedBy(value=LLVMRetNode.LLVM80BitFloatRetNode.class)
    public static final class LLVM80BitFloatRetNodeGen
    extends LLVMRetNode.LLVM80BitFloatRetNode {
        @Node.Child
        private LLVMExpressionNode retResult_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVM80BitFloatRetNodeGen(LLVMExpressionNode retResult) {
            this.retResult_ = retResult;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = this.state_;
            Object retResultValue_ = this.retResult_.executeGeneric(frameValue);
            if (state != 0 && retResultValue_ instanceof LLVM80BitFloat) {
                LLVM80BitFloat retResultValue__ = (LLVM80BitFloat)retResultValue_;
                return this.doOp(retResultValue__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(retResultValue_);
        }

        private Object executeAndSpecialize(Object retResultValue) {
            int state = this.state_;
            if (retResultValue instanceof LLVM80BitFloat) {
                LLVM80BitFloat retResultValue_ = (LLVM80BitFloat)retResultValue;
                this.state_ = state |= 1;
                return this.doOp(retResultValue_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.retResult_}, new Object[]{retResultValue});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMRetNode.LLVM80BitFloatRetNode create(LLVMExpressionNode retResult) {
            return new LLVM80BitFloatRetNodeGen(retResult);
        }
    }

    @GeneratedBy(value=LLVMRetNode.LLVMDoubleRetNode.class)
    public static final class LLVMDoubleRetNodeGen
    extends LLVMRetNode.LLVMDoubleRetNode {
        @Node.Child
        private LLVMExpressionNode retResult_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMDoubleRetNodeGen(LLVMExpressionNode retResult) {
            this.retResult_ = retResult;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            double retResultValue_;
            int state = this.state_;
            try {
                retResultValue_ = this.retResult_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            if (state != 0) {
                return this.doOp(retResultValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(retResultValue_);
        }

        private Object executeAndSpecialize(Object retResultValue) {
            int state = this.state_;
            if (retResultValue instanceof Double) {
                double retResultValue_ = (Double)retResultValue;
                this.state_ = state |= 1;
                return this.doOp(retResultValue_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.retResult_}, new Object[]{retResultValue});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMRetNode.LLVMDoubleRetNode create(LLVMExpressionNode retResult) {
            return new LLVMDoubleRetNodeGen(retResult);
        }
    }

    @GeneratedBy(value=LLVMRetNode.LLVMFloatRetNode.class)
    public static final class LLVMFloatRetNodeGen
    extends LLVMRetNode.LLVMFloatRetNode {
        @Node.Child
        private LLVMExpressionNode retResult_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMFloatRetNodeGen(LLVMExpressionNode retResult) {
            this.retResult_ = retResult;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            float retResultValue_;
            int state = this.state_;
            try {
                retResultValue_ = this.retResult_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            if (state != 0) {
                return this.doOp(retResultValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(Float.valueOf(retResultValue_));
        }

        private Object executeAndSpecialize(Object retResultValue) {
            int state = this.state_;
            if (retResultValue instanceof Float) {
                float retResultValue_ = ((Float)retResultValue).floatValue();
                this.state_ = state |= 1;
                return this.doOp(retResultValue_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.retResult_}, new Object[]{retResultValue});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMRetNode.LLVMFloatRetNode create(LLVMExpressionNode retResult) {
            return new LLVMFloatRetNodeGen(retResult);
        }
    }

    @GeneratedBy(value=LLVMRetNode.LLVMIVarBitRetNode.class)
    public static final class LLVMIVarBitRetNodeGen
    extends LLVMRetNode.LLVMIVarBitRetNode {
        @Node.Child
        private LLVMExpressionNode retResult_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMIVarBitRetNodeGen(LLVMExpressionNode retResult) {
            this.retResult_ = retResult;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = this.state_;
            Object retResultValue_ = this.retResult_.executeGeneric(frameValue);
            if ((state & 1) != 0 && LLVMTypesGen.isImplicitLLVMIVarBit((state & 0xE) >>> 1, retResultValue_)) {
                LLVMIVarBit retResultValue__ = LLVMTypesGen.asImplicitLLVMIVarBit((state & 0xE) >>> 1, retResultValue_);
                return this.doOp(retResultValue__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(retResultValue_);
        }

        private Object executeAndSpecialize(Object retResultValue) {
            int state = this.state_;
            int lLVMIVarBitCast0 = LLVMTypesGen.specializeImplicitLLVMIVarBit(retResultValue);
            if (lLVMIVarBitCast0 != 0) {
                LLVMIVarBit retResultValue_ = LLVMTypesGen.asImplicitLLVMIVarBit(lLVMIVarBitCast0, retResultValue);
                state |= lLVMIVarBitCast0 << 1;
                this.state_ = state |= 1;
                return this.doOp(retResultValue_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.retResult_}, new Object[]{retResultValue});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if ((state & 1) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMRetNode.LLVMIVarBitRetNode create(LLVMExpressionNode retResult) {
            return new LLVMIVarBitRetNodeGen(retResult);
        }
    }

    @GeneratedBy(value=LLVMRetNode.LLVMI64RetNode.class)
    public static final class LLVMI64RetNodeGen
    extends LLVMRetNode.LLVMI64RetNode {
        @Node.Child
        private LLVMExpressionNode retResult_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMI64RetNodeGen(LLVMExpressionNode retResult) {
            this.retResult_ = retResult;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = this.state_;
            if ((state & 2) == 0 && state != 0) {
                return this.execute_long0(frameValue, state);
            }
            return this.execute_generic1(frameValue, state);
        }

        private Object execute_long0(VirtualFrame frameValue, int state) {
            long retResultValue_;
            try {
                retResultValue_ = this.retResult_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 1) != 0);
            return this.doOp(retResultValue_);
        }

        private Object execute_generic1(VirtualFrame frameValue, int state) {
            Object retResultValue_ = this.retResult_.executeGeneric(frameValue);
            if ((state & 1) != 0 && retResultValue_ instanceof Long) {
                long retResultValue__ = (Long)retResultValue_;
                return this.doOp(retResultValue__);
            }
            if ((state & 2) != 0 && LLVMTypes.isPointer(retResultValue_)) {
                LLVMPointer retResultValue__ = LLVMTypes.asPointer(retResultValue_);
                return this.doOp(retResultValue__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(retResultValue_);
        }

        private Object executeAndSpecialize(Object retResultValue) {
            int state = this.state_;
            if (retResultValue instanceof Long) {
                long retResultValue_ = (Long)retResultValue;
                this.state_ = state |= 1;
                return this.doOp(retResultValue_);
            }
            if (LLVMTypes.isPointer(retResultValue)) {
                LLVMPointer retResultValue_ = LLVMTypes.asPointer(retResultValue);
                this.state_ = state |= 2;
                return this.doOp(retResultValue_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.retResult_}, new Object[]{retResultValue});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMRetNode.LLVMI64RetNode create(LLVMExpressionNode retResult) {
            return new LLVMI64RetNodeGen(retResult);
        }
    }

    @GeneratedBy(value=LLVMRetNode.LLVMI32RetNode.class)
    public static final class LLVMI32RetNodeGen
    extends LLVMRetNode.LLVMI32RetNode {
        @Node.Child
        private LLVMExpressionNode retResult_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMI32RetNodeGen(LLVMExpressionNode retResult) {
            this.retResult_ = retResult;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int retResultValue_;
            int state = this.state_;
            try {
                retResultValue_ = this.retResult_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            if (state != 0) {
                return this.doOp(retResultValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(retResultValue_);
        }

        private Object executeAndSpecialize(Object retResultValue) {
            int state = this.state_;
            if (retResultValue instanceof Integer) {
                int retResultValue_ = (Integer)retResultValue;
                this.state_ = state |= 1;
                return this.doOp(retResultValue_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.retResult_}, new Object[]{retResultValue});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMRetNode.LLVMI32RetNode create(LLVMExpressionNode retResult) {
            return new LLVMI32RetNodeGen(retResult);
        }
    }

    @GeneratedBy(value=LLVMRetNode.LLVMI16RetNode.class)
    public static final class LLVMI16RetNodeGen
    extends LLVMRetNode.LLVMI16RetNode {
        @Node.Child
        private LLVMExpressionNode retResult_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMI16RetNodeGen(LLVMExpressionNode retResult) {
            this.retResult_ = retResult;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            short retResultValue_;
            int state = this.state_;
            try {
                retResultValue_ = this.retResult_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            if (state != 0) {
                return this.doOp(retResultValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(retResultValue_);
        }

        private Object executeAndSpecialize(Object retResultValue) {
            int state = this.state_;
            if (retResultValue instanceof Short) {
                short retResultValue_ = (Short)retResultValue;
                this.state_ = state |= 1;
                return this.doOp(retResultValue_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.retResult_}, new Object[]{retResultValue});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMRetNode.LLVMI16RetNode create(LLVMExpressionNode retResult) {
            return new LLVMI16RetNodeGen(retResult);
        }
    }

    @GeneratedBy(value=LLVMRetNode.LLVMI8RetNode.class)
    public static final class LLVMI8RetNodeGen
    extends LLVMRetNode.LLVMI8RetNode {
        @Node.Child
        private LLVMExpressionNode retResult_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMI8RetNodeGen(LLVMExpressionNode retResult) {
            this.retResult_ = retResult;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            byte retResultValue_;
            int state = this.state_;
            try {
                retResultValue_ = this.retResult_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            if (state != 0) {
                return this.doOp(retResultValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(retResultValue_);
        }

        private Object executeAndSpecialize(Object retResultValue) {
            int state = this.state_;
            if (retResultValue instanceof Byte) {
                byte retResultValue_ = (Byte)retResultValue;
                this.state_ = state |= 1;
                return this.doOp(retResultValue_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.retResult_}, new Object[]{retResultValue});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMRetNode.LLVMI8RetNode create(LLVMExpressionNode retResult) {
            return new LLVMI8RetNodeGen(retResult);
        }
    }

    @GeneratedBy(value=LLVMRetNode.LLVMI1RetNode.class)
    public static final class LLVMI1RetNodeGen
    extends LLVMRetNode.LLVMI1RetNode {
        @Node.Child
        private LLVMExpressionNode retResult_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMI1RetNodeGen(LLVMExpressionNode retResult) {
            this.retResult_ = retResult;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            boolean retResultValue_;
            int state = this.state_;
            try {
                retResultValue_ = this.retResult_.executeI1(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            if (state != 0) {
                return this.doOp(retResultValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(retResultValue_);
        }

        private Object executeAndSpecialize(Object retResultValue) {
            int state = this.state_;
            if (retResultValue instanceof Boolean) {
                boolean retResultValue_ = (Boolean)retResultValue;
                this.state_ = state |= 1;
                return this.doOp(retResultValue_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.retResult_}, new Object[]{retResultValue});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMRetNode.LLVMI1RetNode create(LLVMExpressionNode retResult) {
            return new LLVMI1RetNodeGen(retResult);
        }
    }
}

