/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.factories;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.llvm.runtime.interop.LLVMDataEscapeNode;
import com.oracle.truffle.llvm.runtime.interop.convert.ForeignToLLVM;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMObjectAccess;
import com.oracle.truffle.llvm.runtime.nodes.factories.LLVMObjectAccessFactory;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=LLVMObjectAccessFactory.class)
public final class LLVMObjectAccessFactoryFactory {

    @GeneratedBy(value=LLVMObjectAccessFactory.GetWriteIdentifierNode.class)
    static final class GetWriteIdentifierNodeGen
    extends LLVMObjectAccessFactory.GetWriteIdentifierNode {
        @CompilerDirectives.CompilationFinal
        private int state_;

        private GetWriteIdentifierNodeGen() {
        }

        @Override
        long execute(long arg0Value, Object arg1Value) {
            int state = this.state_;
            if (state != 0) {
                if ((state & 1) != 0 && arg1Value instanceof Byte) {
                    byte arg1Value_ = (Byte)arg1Value;
                    return this.doByte(arg0Value, arg1Value_);
                }
                if ((state & 2) != 0 && arg1Value instanceof Short) {
                    short arg1Value_ = (Short)arg1Value;
                    return this.doShort(arg0Value, arg1Value_);
                }
                if ((state & 4) != 0 && arg1Value instanceof Character) {
                    char arg1Value_ = ((Character)arg1Value).charValue();
                    return this.doChar(arg0Value, arg1Value_);
                }
                if ((state & 8) != 0 && arg1Value instanceof Integer) {
                    int arg1Value_ = (Integer)arg1Value;
                    return this.doInt(arg0Value, arg1Value_);
                }
                if ((state & 0x10) != 0 && arg1Value instanceof Float) {
                    float arg1Value_ = ((Float)arg1Value).floatValue();
                    return this.doFloat(arg0Value, arg1Value_);
                }
                if ((state & 0x20) != 0 && GetWriteIdentifierNodeGen.fallbackGuard_(state, arg0Value, arg1Value)) {
                    return this.doDouble(arg0Value, arg1Value);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value, arg1Value);
        }

        private long executeAndSpecialize(long arg0Value, Object arg1Value) {
            int state = this.state_;
            if (arg1Value instanceof Byte) {
                byte arg1Value_ = (Byte)arg1Value;
                this.state_ = state |= 1;
                return this.doByte(arg0Value, arg1Value_);
            }
            if (arg1Value instanceof Short) {
                short arg1Value_ = (Short)arg1Value;
                this.state_ = state |= 2;
                return this.doShort(arg0Value, arg1Value_);
            }
            if (arg1Value instanceof Character) {
                char arg1Value_ = ((Character)arg1Value).charValue();
                this.state_ = state |= 4;
                return this.doChar(arg0Value, arg1Value_);
            }
            if (arg1Value instanceof Integer) {
                int arg1Value_ = (Integer)arg1Value;
                this.state_ = state |= 8;
                return this.doInt(arg0Value, arg1Value_);
            }
            if (arg1Value instanceof Float) {
                float arg1Value_ = ((Float)arg1Value).floatValue();
                this.state_ = state |= 0x10;
                return this.doFloat(arg0Value, arg1Value_);
            }
            this.state_ = state |= 0x20;
            return this.doDouble(arg0Value, arg1Value);
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        private static boolean fallbackGuard_(int state, long arg0Value, Object arg1Value) {
            if ((state & 1) == 0 && arg1Value instanceof Byte) {
                return false;
            }
            if ((state & 2) == 0 && arg1Value instanceof Short) {
                return false;
            }
            if ((state & 4) == 0 && arg1Value instanceof Character) {
                return false;
            }
            if ((state & 8) == 0 && arg1Value instanceof Integer) {
                return false;
            }
            return (state & 0x10) != 0 || !(arg1Value instanceof Float);
        }

        public static LLVMObjectAccessFactory.GetWriteIdentifierNode create() {
            return new GetWriteIdentifierNodeGen();
        }
    }

    @GeneratedBy(value=LLVMObjectAccessFactory.FallbackWriteNode.class)
    static final class FallbackWriteNodeGen
    extends LLVMObjectAccessFactory.FallbackWriteNode {
        @CompilerDirectives.CompilationFinal
        private int state_;
        @CompilerDirectives.CompilationFinal
        private int exclude_;
        @Node.Child
        private CachedTypeData cachedType_cache;

        private FallbackWriteNodeGen() {
        }

        @Override
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        public void executeWrite(Object arg0Value, long arg1Value, Object arg2Value, ForeignToLLVM.ForeignToLLVMType arg3Value) {
            int state = this.state_;
            if (state != 0) {
                if ((state & 1) != 0) {
                    CachedTypeData s1_ = this.cachedType_cache;
                    while (s1_ != null) {
                        if (arg3Value == s1_.cachedType_) {
                            this.doCachedType(arg0Value, arg1Value, arg2Value, arg3Value, s1_.cachedType_, s1_.dataEscape_);
                            return;
                        }
                        s1_ = s1_.next_;
                    }
                }
                if ((state & 2) != 0) {
                    this.doUncached(arg0Value, arg1Value, arg2Value, arg3Value);
                    return;
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void executeAndSpecialize(Object arg0Value, long arg1Value, Object arg2Value, ForeignToLLVM.ForeignToLLVMType arg3Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            int exclude = this.exclude_;
            try {
                if (exclude == 0) {
                    int count1_ = 0;
                    CachedTypeData s1_ = this.cachedType_cache;
                    if ((state & 1) != 0) {
                        while (s1_ != null && arg3Value != s1_.cachedType_) {
                            s1_ = s1_.next_;
                            ++count1_;
                        }
                    }
                    if (s1_ == null && count1_ < 3) {
                        s1_ = (CachedTypeData)super.insert((Node)new CachedTypeData(this.cachedType_cache));
                        s1_.cachedType_ = arg3Value;
                        s1_.dataEscape_ = s1_.insertAccessor(LLVMDataEscapeNode.create(s1_.cachedType_));
                        this.cachedType_cache = s1_;
                        this.state_ = state |= 1;
                    }
                    if (s1_ != null) {
                        lock.unlock();
                        hasLock = false;
                        this.doCachedType(arg0Value, arg1Value, arg2Value, arg3Value, s1_.cachedType_, s1_.dataEscape_);
                        return;
                    }
                }
                this.exclude_ = exclude |= 1;
                this.cachedType_cache = null;
                state &= 0xFFFFFFFE;
                this.state_ = state |= 2;
                lock.unlock();
                hasLock = false;
                this.doUncached(arg0Value, arg1Value, arg2Value, arg3Value);
                return;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            CachedTypeData s1_;
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0 && ((s1_ = this.cachedType_cache) == null || s1_.next_ == null)) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMObjectAccessFactory.FallbackWriteNode create() {
            return new FallbackWriteNodeGen();
        }

        @GeneratedBy(value=LLVMObjectAccessFactory.FallbackWriteNode.class)
        private static final class CachedTypeData
        extends Node {
            @Node.Child
            CachedTypeData next_;
            @CompilerDirectives.CompilationFinal
            ForeignToLLVM.ForeignToLLVMType cachedType_;
            @Node.Child
            LLVMDataEscapeNode dataEscape_;

            CachedTypeData(CachedTypeData next_) {
                this.next_ = next_;
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }
    }

    @GeneratedBy(value=LLVMObjectAccessFactory.CachedWriteNode.class)
    static final class CachedWriteNodeGen
    extends LLVMObjectAccessFactory.CachedWriteNode {
        @CompilerDirectives.CompilationFinal
        private int state_;
        @Node.Child
        private WriteData write_cache;

        private CachedWriteNodeGen() {
        }

        @Override
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        public void executeWrite(Object arg0Value, long arg1Value, Object arg2Value, ForeignToLLVM.ForeignToLLVMType arg3Value) {
            int state = this.state_;
            if (state != 0) {
                WriteData s1_ = this.write_cache;
                while (s1_ != null) {
                    if (s1_.impl_.canAccess(arg0Value)) {
                        this.doWrite(arg0Value, arg1Value, arg2Value, arg3Value, s1_.impl_);
                        return;
                    }
                    s1_ = s1_.next_;
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value);
        }

        private void executeAndSpecialize(Object arg0Value, long arg1Value, Object arg2Value, ForeignToLLVM.ForeignToLLVMType arg3Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                LLVMObjectAccess.LLVMObjectWriteNode impl__;
                int count1_ = 0;
                WriteData s1_ = this.write_cache;
                if (state != 0) {
                    while (s1_ != null && !s1_.impl_.canAccess(arg0Value)) {
                        s1_ = s1_.next_;
                        ++count1_;
                    }
                }
                if (s1_ == null && (impl__ = this.createWriteNode(arg0Value)).canAccess(arg0Value) && count1_ < 8) {
                    s1_ = (WriteData)super.insert((Node)new WriteData(this.write_cache));
                    LLVMObjectAccess.LLVMObjectWriteNode impl___ = impl__;
                    if (impl___ instanceof Node) {
                        s1_.insertAccessor((Node)impl___);
                    }
                    s1_.impl_ = impl___;
                    this.write_cache = s1_;
                    this.state_ = state |= 1;
                }
                if (s1_ != null) {
                    lock.unlock();
                    hasLock = false;
                    this.doWrite(arg0Value, arg1Value, arg2Value, arg3Value, s1_.impl_);
                    return;
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null, null, null}, new Object[]{arg0Value, arg1Value, arg2Value, arg3Value});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            WriteData s1_;
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0 && ((s1_ = this.write_cache) == null || s1_.next_ == null)) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMObjectAccessFactory.CachedWriteNode create() {
            return new CachedWriteNodeGen();
        }

        @GeneratedBy(value=LLVMObjectAccessFactory.CachedWriteNode.class)
        private static final class WriteData
        extends Node {
            @Node.Child
            WriteData next_;
            @Node.Child
            LLVMObjectAccess.LLVMObjectWriteNode impl_;

            WriteData(WriteData next_) {
                this.next_ = next_;
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }
    }

    @GeneratedBy(value=LLVMObjectAccessFactory.UseLLVMObjectAccessNode.class)
    static final class UseLLVMObjectAccessNodeGen
    extends LLVMObjectAccessFactory.UseLLVMObjectAccessNode {
        @CompilerDirectives.CompilationFinal
        private int state_;
        @CompilerDirectives.CompilationFinal
        private int exclude_;
        @CompilerDirectives.CompilationFinal
        private NonDynamicObjectCachedData nonDynamicObjectCached_cache;
        @CompilerDirectives.CompilationFinal
        private DynamicObjectCachedData dynamicObjectCached_cache;

        private UseLLVMObjectAccessNodeGen() {
        }

        @Override
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        public boolean executeWithTarget(Object arg0Value) {
            int state = this.state_;
            if ((state & 1) != 0) {
                NonDynamicObjectCachedData s1_ = this.nonDynamicObjectCached_cache;
                while (s1_ != null) {
                    if (arg0Value.getClass() == s1_.cachedClass_) {
                        assert (!this.isDynamicObject(s1_.cachedClass_));
                        return this.doNonDynamicObjectCached(arg0Value, s1_.cachedClass_);
                    }
                    s1_ = s1_.next_;
                }
            }
            if ((state & 2) != 0 && arg0Value instanceof DynamicObject) {
                DynamicObject arg0Value_ = (DynamicObject)arg0Value;
                DynamicObjectCachedData s2_ = this.dynamicObjectCached_cache;
                while (s2_ != null) {
                    if (s2_.cachedObjectTypeClass_ == arg0Value_.getShape().getObjectType().getClass()) {
                        return this.doDynamicObjectCached(arg0Value_, s2_.cachedObjectTypeClass_);
                    }
                    s2_ = s2_.next_;
                }
            }
            if ((state & 4) != 0) {
                return this.uncached(arg0Value);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean executeAndSpecialize(Object arg0Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            int exclude = this.exclude_;
            try {
                if ((exclude & 1) == 0) {
                    int count1_ = 0;
                    NonDynamicObjectCachedData s1_ = this.nonDynamicObjectCached_cache;
                    if ((state & 1) != 0) {
                        while (s1_ != null) {
                            if (arg0Value.getClass() == s1_.cachedClass_) {
                                assert (!this.isDynamicObject(s1_.cachedClass_));
                                break;
                            }
                            s1_ = s1_.next_;
                            ++count1_;
                        }
                    }
                    if (s1_ == null) {
                        Class<?> cachedClass__ = arg0Value.getClass();
                        if (arg0Value.getClass() == cachedClass__ && !this.isDynamicObject(cachedClass__) && count1_ < 3) {
                            s1_ = new NonDynamicObjectCachedData(this.nonDynamicObjectCached_cache);
                            s1_.cachedClass_ = cachedClass__;
                            this.nonDynamicObjectCached_cache = s1_;
                            this.state_ = state |= 1;
                        }
                    }
                    if (s1_ != null) {
                        lock.unlock();
                        hasLock = false;
                        boolean cachedClass__ = this.doNonDynamicObjectCached(arg0Value, s1_.cachedClass_);
                        return cachedClass__;
                    }
                }
                if ((exclude & 2) == 0 && arg0Value instanceof DynamicObject) {
                    Class<?> cachedObjectTypeClass__;
                    DynamicObject arg0Value_ = (DynamicObject)arg0Value;
                    int count2_ = 0;
                    DynamicObjectCachedData s2_ = this.dynamicObjectCached_cache;
                    if ((state & 2) != 0) {
                        while (s2_ != null && s2_.cachedObjectTypeClass_ != arg0Value_.getShape().getObjectType().getClass()) {
                            s2_ = s2_.next_;
                            ++count2_;
                        }
                    }
                    if (s2_ == null && (cachedObjectTypeClass__ = arg0Value_.getShape().getObjectType().getClass()) == arg0Value_.getShape().getObjectType().getClass() && count2_ < 3) {
                        s2_ = new DynamicObjectCachedData(this.dynamicObjectCached_cache);
                        s2_.cachedObjectTypeClass_ = cachedObjectTypeClass__;
                        this.dynamicObjectCached_cache = s2_;
                        this.state_ = state |= 2;
                    }
                    if (s2_ != null) {
                        lock.unlock();
                        hasLock = false;
                        boolean bl = this.doDynamicObjectCached(arg0Value_, s2_.cachedObjectTypeClass_);
                        return bl;
                    }
                }
                this.exclude_ = exclude |= 3;
                this.nonDynamicObjectCached_cache = null;
                this.dynamicObjectCached_cache = null;
                state &= 0xFFFFFFFC;
                this.state_ = state |= 4;
                lock.unlock();
                hasLock = false;
                boolean bl = this.uncached(arg0Value);
                return bl;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                NonDynamicObjectCachedData s1_ = this.nonDynamicObjectCached_cache;
                DynamicObjectCachedData s2_ = this.dynamicObjectCached_cache;
                if (!(s1_ != null && s1_.next_ != null || s2_ != null && s2_.next_ != null)) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMObjectAccessFactory.UseLLVMObjectAccessNode create() {
            return new UseLLVMObjectAccessNodeGen();
        }

        @GeneratedBy(value=LLVMObjectAccessFactory.UseLLVMObjectAccessNode.class)
        private static final class DynamicObjectCachedData {
            @CompilerDirectives.CompilationFinal
            DynamicObjectCachedData next_;
            @CompilerDirectives.CompilationFinal
            Class<?> cachedObjectTypeClass_;

            DynamicObjectCachedData(DynamicObjectCachedData next_) {
                this.next_ = next_;
            }
        }

        @GeneratedBy(value=LLVMObjectAccessFactory.UseLLVMObjectAccessNode.class)
        private static final class NonDynamicObjectCachedData {
            @CompilerDirectives.CompilationFinal
            NonDynamicObjectCachedData next_;
            @CompilerDirectives.CompilationFinal
            Class<?> cachedClass_;

            NonDynamicObjectCachedData(NonDynamicObjectCachedData next_) {
                this.next_ = next_;
            }
        }
    }

    @GeneratedBy(value=LLVMObjectAccessFactory.CachedReadNode.class)
    static final class CachedReadNodeGen
    extends LLVMObjectAccessFactory.CachedReadNode {
        @CompilerDirectives.CompilationFinal
        private int state_;
        @Node.Child
        private ReadData read_cache;

        private CachedReadNodeGen() {
        }

        @Override
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        public Object executeRead(Object arg0Value, long arg1Value, ForeignToLLVM.ForeignToLLVMType arg2Value) {
            int state = this.state_;
            if (state != 0) {
                ReadData s1_ = this.read_cache;
                while (s1_ != null) {
                    if (s1_.impl_.canAccess(arg0Value)) {
                        return this.doRead(arg0Value, arg1Value, arg2Value, s1_.impl_);
                    }
                    s1_ = s1_.next_;
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value);
        }

        private Object executeAndSpecialize(Object arg0Value, long arg1Value, ForeignToLLVM.ForeignToLLVMType arg2Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                LLVMObjectAccess.LLVMObjectReadNode impl__;
                int count1_ = 0;
                ReadData s1_ = this.read_cache;
                if (state != 0) {
                    while (s1_ != null && !s1_.impl_.canAccess(arg0Value)) {
                        s1_ = s1_.next_;
                        ++count1_;
                    }
                }
                if (s1_ == null && (impl__ = this.createReadNode(arg0Value)).canAccess(arg0Value) && count1_ < 8) {
                    s1_ = (ReadData)super.insert((Node)new ReadData(this.read_cache));
                    LLVMObjectAccess.LLVMObjectReadNode impl___ = impl__;
                    if (impl___ instanceof Node) {
                        s1_.insertAccessor((Node)impl___);
                    }
                    s1_.impl_ = impl___;
                    this.read_cache = s1_;
                    this.state_ = state |= 1;
                }
                if (s1_ != null) {
                    lock.unlock();
                    hasLock = false;
                    Object object = this.doRead(arg0Value, arg1Value, arg2Value, s1_.impl_);
                    return object;
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null, null}, new Object[]{arg0Value, arg1Value, arg2Value});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            ReadData s1_;
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0 && ((s1_ = this.read_cache) == null || s1_.next_ == null)) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMObjectAccessFactory.CachedReadNode create() {
            return new CachedReadNodeGen();
        }

        @GeneratedBy(value=LLVMObjectAccessFactory.CachedReadNode.class)
        private static final class ReadData
        extends Node {
            @Node.Child
            ReadData next_;
            @Node.Child
            LLVMObjectAccess.LLVMObjectReadNode impl_;

            ReadData(ReadData next_) {
                this.next_ = next_;
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }
    }
}

