/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.func;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.GenerateWrapper;
import com.oracle.truffle.api.instrumentation.InstrumentableNode;
import com.oracle.truffle.api.instrumentation.ProbeNode;
import com.oracle.truffle.api.instrumentation.StandardTags;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMControlFlowNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMStatementNode;
import com.oracle.truffle.llvm.runtime.nodes.func.LLVMDispatchNode;
import com.oracle.truffle.llvm.runtime.nodes.func.LLVMDispatchNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.func.LLVMInvokeNodeWrapper;
import com.oracle.truffle.llvm.runtime.nodes.func.LLVMLookupDispatchTargetNode;
import com.oracle.truffle.llvm.runtime.nodes.func.LLVMLookupDispatchTargetNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.others.LLVMValueProfilingNode;
import com.oracle.truffle.llvm.runtime.types.FunctionType;
import com.oracle.truffle.llvm.runtime.types.PointerType;
import com.oracle.truffle.llvm.runtime.types.PrimitiveType;
import com.oracle.truffle.llvm.runtime.types.Type;
import com.oracle.truffle.llvm.runtime.types.VoidType;

@GenerateWrapper
public abstract class LLVMInvokeNode
extends LLVMControlFlowNode {
    public static final int NORMAL_SUCCESSOR = 0;
    public static final int UNWIND_SUCCESSOR = 1;

    public InstrumentableNode.WrapperNode createWrapper(ProbeNode probe) {
        return new LLVMInvokeNodeWrapper(this, probe);
    }

    public abstract int getNormalSuccessor();

    public abstract int getUnwindSuccessor();

    public abstract void execute(VirtualFrame var1);

    public abstract void writeResult(VirtualFrame var1, Object var2);

    public abstract void writePhis(VirtualFrame var1, int var2);

    @Override
    public boolean needsBranchProfiling() {
        return false;
    }

    @Override
    public boolean hasTag(Class<? extends Tag> tag) {
        if (tag == StandardTags.CallTag.class) {
            return this.getSourceLocation() != null;
        }
        return super.hasTag(tag);
    }

    public static final class LLVMFunctionInvokeNode
    extends LLVMInvokeNodeImpl {
        @Node.Children
        private final LLVMExpressionNode[] argumentNodes;
        @Node.Child
        private LLVMLookupDispatchTargetNode dispatchTargetNode;
        @Node.Child
        private LLVMDispatchNode dispatchNode;

        public LLVMFunctionInvokeNode(FunctionType type, FrameSlot resultLocation, LLVMExpressionNode functionNode, LLVMExpressionNode[] argumentNodes, int normalSuccessor, int unwindSuccessor, LLVMStatementNode normalPhiNode, LLVMStatementNode unwindPhiNode) {
            super(type, resultLocation, normalSuccessor, unwindSuccessor, normalPhiNode, unwindPhiNode);
            this.argumentNodes = argumentNodes;
            this.dispatchTargetNode = LLVMLookupDispatchTargetNodeGen.create(functionNode);
            this.dispatchNode = LLVMDispatchNodeGen.create(type);
        }

        @Override
        public void execute(VirtualFrame frame) {
            Object function = this.dispatchTargetNode.executeGeneric(frame);
            Object[] argValues = this.prepareArguments(frame);
            this.writeResult(frame, this.dispatchNode.executeDispatch(function, argValues));
        }

        @ExplodeLoop
        private Object[] prepareArguments(VirtualFrame frame) {
            Object[] argValues = new Object[this.argumentNodes.length];
            for (int i = 0; i < this.argumentNodes.length; ++i) {
                argValues[i] = this.argumentNodes[i].executeGeneric(frame);
            }
            return argValues;
        }
    }

    public static final class LLVMSubstitutionInvokeNode
    extends LLVMInvokeNodeImpl {
        @Node.Child
        private LLVMExpressionNode substitution;

        public LLVMSubstitutionInvokeNode(FunctionType type, FrameSlot resultLocation, LLVMExpressionNode substitution, int normalSuccessor, int unwindSuccessor, LLVMStatementNode normalPhiNode, LLVMStatementNode unwindPhiNode) {
            super(type, resultLocation, normalSuccessor, unwindSuccessor, normalPhiNode, unwindPhiNode);
            this.substitution = substitution;
        }

        @Override
        public void execute(VirtualFrame frame) {
            this.writeResult(frame, this.substitution.executeGeneric(frame));
        }
    }

    private static class LLVMInvokeNodeImpl
    extends LLVMInvokeNode {
        @Node.Child
        protected LLVMStatementNode normalPhiNode;
        @Node.Child
        protected LLVMStatementNode unwindPhiNode;
        @Node.Child
        protected LLVMValueProfilingNode returnValueProfile;
        protected final FunctionType type;
        @CompilerDirectives.CompilationFinal
        private FrameSlot stackPointer;
        private final int normalSuccessor;
        private final int unwindSuccessor;
        private final FrameSlot resultLocation;
        private final ConditionProfile profile = ConditionProfile.createCountingProfile();

        LLVMInvokeNodeImpl(FunctionType type, FrameSlot resultLocation, int normalSuccessor, int unwindSuccessor, LLVMStatementNode normalPhiNode, LLVMStatementNode unwindPhiNode) {
            this.normalSuccessor = normalSuccessor;
            this.unwindSuccessor = unwindSuccessor;
            this.type = type;
            this.normalPhiNode = normalPhiNode;
            this.unwindPhiNode = unwindPhiNode;
            this.resultLocation = resultLocation;
            this.initializeReturnValueProfileNode();
        }

        @Override
        public int getSuccessorCount() {
            return 2;
        }

        @Override
        public int getNormalSuccessor() {
            return this.normalSuccessor;
        }

        @Override
        public int getUnwindSuccessor() {
            return this.unwindSuccessor;
        }

        @Override
        public void execute(VirtualFrame frame) {
            throw new UnsupportedOperationException("Unimplemented LLVMInvokeNode");
        }

        private void initializeReturnValueProfileNode() {
            CompilerAsserts.neverPartOfCompilation();
            this.returnValueProfile = (LLVMValueProfilingNode)LLVMValueProfilingNode.create(null, this.type.getReturnType());
        }

        @Override
        public LLVMStatementNode getPhiNode(int successorIndex) {
            if (successorIndex == 0) {
                return this.normalPhiNode;
            }
            assert (successorIndex == 1);
            return this.unwindPhiNode;
        }

        @Override
        public void writeResult(VirtualFrame frame, Object value) {
            Type returnType = this.type.getReturnType();
            CompilerAsserts.partialEvaluationConstant((Object)returnType);
            if (returnType instanceof VoidType) {
                return;
            }
            if (returnType instanceof PrimitiveType) {
                switch (((PrimitiveType)returnType).getPrimitiveKind()) {
                    case I1: {
                        frame.setBoolean(this.resultLocation, ((Boolean)this.returnValueProfile.executeWithTarget(value)).booleanValue());
                        break;
                    }
                    case I8: {
                        frame.setByte(this.resultLocation, ((Byte)this.returnValueProfile.executeWithTarget(value)).byteValue());
                        break;
                    }
                    case I16: {
                        frame.setInt(this.resultLocation, (int)((Short)this.returnValueProfile.executeWithTarget(value)).shortValue());
                        break;
                    }
                    case I32: {
                        frame.setInt(this.resultLocation, ((Integer)this.returnValueProfile.executeWithTarget(value)).intValue());
                        break;
                    }
                    case I64: {
                        frame.setLong(this.resultLocation, ((Long)this.returnValueProfile.executeWithTarget(value)).longValue());
                        break;
                    }
                    case FLOAT: {
                        frame.setFloat(this.resultLocation, ((Float)this.returnValueProfile.executeWithTarget(value)).floatValue());
                        break;
                    }
                    case DOUBLE: {
                        frame.setDouble(this.resultLocation, ((Double)this.returnValueProfile.executeWithTarget(value)).doubleValue());
                        break;
                    }
                    default: {
                        frame.setObject(this.resultLocation, value);
                        break;
                    }
                }
            } else if (this.type.getReturnType() instanceof PointerType) {
                Object profiledValue = this.returnValueProfile.executeWithTarget(value);
                frame.setObject(this.resultLocation, profiledValue);
            } else {
                frame.setObject(this.resultLocation, value);
            }
        }

        @Override
        @ExplodeLoop
        public void writePhis(VirtualFrame frame, int successorIndex) {
            if (this.profile.profile(successorIndex == 0)) {
                this.normalPhiNode.execute(frame);
            } else {
                assert (successorIndex == 1);
                this.unwindPhiNode.execute(frame);
            }
        }
    }
}

