/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.func;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.FrameSlotTypeException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.GenerateWrapper;
import com.oracle.truffle.api.instrumentation.InstrumentableNode;
import com.oracle.truffle.api.instrumentation.ProbeNode;
import com.oracle.truffle.llvm.runtime.except.LLVMUserException;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMControlFlowNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMStatementNode;
import com.oracle.truffle.llvm.runtime.nodes.func.LLVMResumeNodeWrapper;

@GenerateWrapper
public class LLVMResumeNode
extends LLVMControlFlowNode {
    private final FrameSlot exceptionSlot;

    public LLVMResumeNode(FrameSlot exceptionSlot) {
        this.exceptionSlot = exceptionSlot;
    }

    public LLVMResumeNode(LLVMResumeNode delegate) {
        this.exceptionSlot = delegate.exceptionSlot;
    }

    public InstrumentableNode.WrapperNode createWrapper(ProbeNode probe) {
        return new LLVMResumeNodeWrapper(this, this, probe);
    }

    @Override
    public int getSuccessorCount() {
        return 0;
    }

    @Override
    public LLVMStatementNode getPhiNode(int successorIndex) {
        return null;
    }

    public void execute(VirtualFrame frame) {
        try {
            LLVMUserException thrownException = (LLVMUserException)frame.getObject(this.exceptionSlot);
            throw thrownException;
        }
        catch (FrameSlotTypeException e) {
            CompilerDirectives.transferToInterpreter();
            throw new IllegalStateException(e);
        }
    }
}

