/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.llvm.runtime.except.LLVMPolyglotException;
import com.oracle.truffle.llvm.runtime.interop.LLVMInternalTruffleObject;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedReadLibrary;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedWriteLibrary;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMToPointerNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.LLVMIntrinsic;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.spi.NativeTypeLibrary;

@NodeChild(type=LLVMExpressionNode.class)
public abstract class LLVMTruffleManagedMalloc
extends LLVMIntrinsic {
    @Specialization
    protected Object doIntrinsic(long size) {
        if (size < 0L) {
            CompilerDirectives.transferToInterpreter();
            throw new IllegalArgumentException("Can't truffle_managed_malloc less than zero bytes");
        }
        long sizeInWords = (size + 8L - 1L) / 8L;
        if (sizeInWords > Integer.MAX_VALUE) {
            CompilerDirectives.transferToInterpreter();
            throw new IllegalArgumentException("Can't truffle_managed_malloc for more than 2^31 objects");
        }
        return LLVMManagedPointer.create(new ManagedMallocObject((int)sizeInWords));
    }

    @ExportLibrary.Repeat(value={@ExportLibrary(value=InteropLibrary.class), @ExportLibrary(value=LLVMManagedReadLibrary.class), @ExportLibrary(value=LLVMManagedWriteLibrary.class), @ExportLibrary(value=NativeTypeLibrary.class)})
    public static class ManagedMallocObject
    implements LLVMInternalTruffleObject {
        private final LLVMPointer[] contents;
        private static final LLVMInteropType NATIVE_TYPE = LLVMInteropType.ValueKind.POINTER.type.toArray(0L);

        public ManagedMallocObject(int entries) {
            this.contents = new LLVMPointer[entries];
        }

        public LLVMPointer get(int index) {
            return this.contents[index];
        }

        public void set(int index, LLVMPointer value) {
            this.contents[index] = value;
        }

        @ExportMessage
        boolean hasNativeType() {
            return true;
        }

        @ExportMessage
        Object getNativeType() {
            return NATIVE_TYPE;
        }

        @ExportMessage
        boolean hasArrayElements() {
            return true;
        }

        @ExportMessage
        long getArraySize() {
            return this.contents.length;
        }

        @ExportMessage.Repeat(value={@ExportMessage(name="isArrayElementReadable"), @ExportMessage(name="isArrayElementModifiable"), @ExportMessage(name="isArrayElementInsertable")})
        boolean isArrayElementValid(long index) {
            return 0L <= index && index < this.getArraySize();
        }

        @ExportMessage
        Object readArrayElement(long index, @Cached.Shared(value="exception") @Cached BranchProfile exception) throws InvalidArrayIndexException {
            if (this.isArrayElementValid(index)) {
                return this.get((int)index);
            }
            exception.enter();
            throw InvalidArrayIndexException.create((long)index);
        }

        @ExportMessage
        void writeArrayElement(long index, Object value, @Cached LLVMToPointerNode toPointer, @Cached.Shared(value="exception") @Cached BranchProfile exception) throws InvalidArrayIndexException {
            if (!this.isArrayElementValid(index)) {
                exception.enter();
                throw InvalidArrayIndexException.create((long)index);
            }
            this.set((int)index, toPointer.executeWithTarget(value));
        }

        @ExportMessage.Repeat(value={@ExportMessage(name="isReadable"), @ExportMessage(name="isWritable")})
        boolean isAccessible() {
            return true;
        }

        @ExportMessage
        byte readI8(long offset, @CachedLibrary(value="this") LLVMManagedReadLibrary read) {
            throw new LLVMPolyglotException((Node)read, "Can't read I8 from managed malloc object at offset %d.", offset);
        }

        @ExportMessage
        short readI16(long offset, @CachedLibrary(value="this") LLVMManagedReadLibrary read) {
            throw new LLVMPolyglotException((Node)read, "Can't read I16 from managed malloc object at offset %d.", offset);
        }

        @ExportMessage
        int readI32(long offset, @CachedLibrary(value="this") LLVMManagedReadLibrary read) {
            throw new LLVMPolyglotException((Node)read, "Can't read I32 from managed malloc object at offset %d.", offset);
        }

        @ExportMessage
        double readDouble(long offset, @CachedLibrary(value="this") LLVMManagedReadLibrary read) {
            throw new LLVMPolyglotException((Node)read, "Can't read double from managed malloc object at offset %d.", offset);
        }

        @ExportMessage
        LLVMPointer readPointer(long offset, @Cached BranchProfile exception, @CachedLibrary(value="this") LLVMManagedReadLibrary read) {
            long idx;
            if (offset % 8L == 0L && (idx = offset / 8L) == (long)((int)idx)) {
                return this.get((int)idx);
            }
            exception.enter();
            throw new LLVMPolyglotException((Node)read, "Can't read pointer from managed malloc object at offset %d.", offset);
        }

        @ExportMessage
        LLVMPointer readGenericI64(long offset, @CachedLibrary(value="this") LLVMManagedReadLibrary read) {
            return read.readPointer(this, offset);
        }

        @ExportMessage
        void writeI8(long offset, byte value, @CachedLibrary(value="this") LLVMManagedWriteLibrary write) {
            throw new LLVMPolyglotException((Node)write, "Can't write I8 to managed malloc object at offset %d.", offset);
        }

        @ExportMessage
        void writeI16(long offset, short value, @CachedLibrary(value="this") LLVMManagedWriteLibrary write) {
            throw new LLVMPolyglotException((Node)write, "Can't write I16 to managed malloc object at offset %d.", offset);
        }

        @ExportMessage
        void writeI32(long offset, int value, @CachedLibrary(value="this") LLVMManagedWriteLibrary write) {
            throw new LLVMPolyglotException((Node)write, "Can't write I32 to managed malloc object at offset %d.", offset);
        }

        @ExportMessage
        void writePointer(long offset, LLVMPointer value, @Cached BranchProfile exception, @CachedLibrary(value="this") LLVMManagedWriteLibrary write) {
            long idx;
            if (offset % 8L == 0L && (idx = offset / 8L) == (long)((int)idx)) {
                this.set((int)idx, value);
                return;
            }
            exception.enter();
            throw new LLVMPolyglotException((Node)write, "Can't write pointer to managed malloc object at offset %d.", offset);
        }

        @ExportMessage
        void writeI64(long offset, long value, @CachedLibrary(value="this") LLVMManagedWriteLibrary write) {
            write.writePointer(this, offset, LLVMNativePointer.create(value));
        }

        @ExportMessage
        void writeGenericI64(long offset, Object value, @Cached LLVMToPointerNode toPointer, @CachedLibrary(value="this") LLVMManagedWriteLibrary write) {
            write.writePointer(this, offset, toPointer.executeWithTarget(value));
        }
    }
}

