/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.memory.LLVMMemory;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.LLVMFrameAddress;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=LLVMFrameAddress.class)
public final class LLVMFrameAddressNodeGen
extends LLVMFrameAddress {
    @Node.Child
    private LLVMExpressionNode val_;
    @CompilerDirectives.CompilationFinal
    private int state_;
    @CompilerDirectives.CompilationFinal
    private LLVMMemory memory_;

    private LLVMFrameAddressNodeGen(LLVMExpressionNode val) {
        this.val_ = val;
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        int valValue_;
        int state = this.state_;
        try {
            valValue_ = this.val_.executeI32(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(frameValue, ex.getResult());
        }
        if (state != 0) {
            return this.doPointee(frameValue, valValue_, this.memory_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(frameValue, valValue_);
    }

    private LLVMNativePointer executeAndSpecialize(VirtualFrame frameValue, Object valValue) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        try {
            if (valValue instanceof Integer) {
                int valValue_ = (Integer)valValue;
                this.memory_ = LLVMNode.getLLVMMemory();
                this.state_ = state |= 1;
                lock.unlock();
                hasLock = false;
                LLVMNativePointer lLVMNativePointer = this.doPointee(frameValue, valValue_, this.memory_);
                return lLVMNativePointer;
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.val_}, new Object[]{valValue});
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        return NodeCost.MONOMORPHIC;
    }

    public static LLVMFrameAddress create(LLVMExpressionNode val) {
        return new LLVMFrameAddressNodeGen(val);
    }
}

