/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.debug;

import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.llvm.runtime.debug.value.LLVMDebugValue;
import com.oracle.truffle.llvm.runtime.global.LLVMGlobalContainer;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMNativeLibrary;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.debug.LLDBMemoryValue;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

public abstract class LLVMToDebugDeclarationNode
extends LLVMNode
implements LLVMDebugValue.Builder {
    public abstract LLVMDebugValue executeWithTarget(Object var1);

    @Override
    public LLVMDebugValue build(Object irValue) {
        return this.executeWithTarget(irValue);
    }

    @Specialization
    protected LLVMDebugValue fromPointer(LLVMPointer pointer) {
        Object target;
        if (LLVMManagedPointer.isInstance(pointer) && (target = LLVMManagedPointer.cast(pointer).getObject()) instanceof LLVMGlobalContainer) {
            return LLVMToDebugDeclarationNode.fromGlobalContainer((LLVMGlobalContainer)target);
        }
        return new LLDBMemoryValue(pointer);
    }

    private static LLVMDebugValue fromGlobalContainer(LLVMGlobalContainer globalContainer) {
        if (globalContainer.isPointer()) {
            try {
                return new LLDBMemoryValue(LLVMNativePointer.create(globalContainer.asPointer()));
            }
            catch (UnsupportedMessageException e) {
                return LLVMDebugValue.UNAVAILABLE;
            }
        }
        Object currentValue = globalContainer.get();
        if (LLVMPointer.isInstance(currentValue)) {
            return new LLDBMemoryValue(LLVMPointer.cast(currentValue));
        }
        return new LLDBMemoryValue(LLVMManagedPointer.create(currentValue));
    }

    @Specialization(limit="3", guards={"llvmNative.isPointer(address)"})
    protected LLVMDebugValue fromNative(Object address, @CachedLibrary(value="address") LLVMNativeLibrary llvmNative) {
        return this.fromPointer(llvmNative.toNativePointer(address));
    }

    @Fallback
    protected LLVMDebugValue fromGenericObject(Object object) {
        return LLVMDebugValue.UNAVAILABLE;
    }
}

